/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.DirectDecrypter;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.profile.JwtGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Service;

@Service
public class GenerateJwtCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateJwtCommand.class);
    private static final int SEP_LENGTH = 8;
    private static final int DEFAULT_SIGNING_SECRET_SIZE = 256;
    private static final int DEFAULT_ENCRYPTION_SECRET_SIZE = 48;
    private static final String DEFAULT_SIGNING_ALGORITHM = "HS256";
    private static final String DEFAULT_ENCRYPTION_ALGORITHM = "dir";
    private static final String DEFAULT_ENCRYPTION_METHOD = "A192CBC-HS384";

    public void generate(String subject) {
        this.generate(256, 48, DEFAULT_SIGNING_ALGORITHM, DEFAULT_ENCRYPTION_ALGORITHM, DEFAULT_ENCRYPTION_METHOD, subject);
    }

    @CliCommand(value={"generate-jwt"}, help="Generate a JWT with given size and algorithm for signing and encryption.")
    public void generate(@CliOption(key={"signingSecretSize"}, help="Size of the signing secret", optionContext="Size of the signing secret", specifiedDefaultValue="256", unspecifiedDefaultValue="256") int signingSecretSize, @CliOption(key={"encryptionSecretSize"}, help="Size of the encryption secret", optionContext="Size of the encryption secret", specifiedDefaultValue="48", unspecifiedDefaultValue="48") int encryptionSecretSize, @CliOption(key={"signingAlgorithm"}, help="Algorithm to use for signing", optionContext="Algorithm to use for signing", specifiedDefaultValue="HS256", unspecifiedDefaultValue="HS256") String signingAlgorithm, @CliOption(key={"encryptionAlgorithm"}, help="Algorithm to use for encryption", optionContext="Algorithm to use for encryption", specifiedDefaultValue="dir", unspecifiedDefaultValue="dir") String encryptionAlgorithm, @CliOption(key={"encryptionMethod"}, help="Method to use for encryption", optionContext="Method to use for encryption", specifiedDefaultValue="A192CBC-HS384", unspecifiedDefaultValue="A192CBC-HS384") String encryptionMethod, @CliOption(key={"subject"}, help="Subject to use for the JWT", optionContext="Subject to use for the JWT", mandatory=true) String subject) {
        JwtGenerator g = new JwtGenerator();
        this.configureJwtSigning(signingSecretSize, signingAlgorithm, g);
        this.configureJwtEncryption(encryptionSecretSize, encryptionAlgorithm, encryptionMethod, g);
        CommonProfile profile = new CommonProfile();
        profile.setId((Object)subject);
        LOGGER.debug(StringUtils.repeat((char)'=', (int)8));
        LOGGER.info("\nGenerating JWT for subject [{}] with signing key size [{}], signing algorithm [{}], encryption key size [{}], encryption method [{}] and encryption algorithm [{}]\n", new Object[]{subject, signingSecretSize, signingAlgorithm, encryptionSecretSize, encryptionMethod, encryptionAlgorithm});
        LOGGER.debug(StringUtils.repeat((char)'=', (int)8));
        String token = g.generate(profile);
        LOGGER.info("==== JWT ====\n{}", (Object)token);
    }

    private void configureJwtEncryption(int encryptionSecretSize, String encryptionAlgorithm, String encryptionMethod, JwtGenerator<CommonProfile> g) {
        if (encryptionSecretSize <= 0 || StringUtils.isBlank((CharSequence)encryptionMethod) || StringUtils.isBlank((CharSequence)encryptionAlgorithm)) {
            LOGGER.info("No encryption algorithm or size specified, so the generated JWT will not be encrypted");
            return;
        }
        String encryptionSecret = RandomStringUtils.randomAlphanumeric((int)encryptionSecretSize);
        LOGGER.info("==== Encryption Secret ====\n{}\n", (Object)encryptionSecret);
        String acceptedEncAlgs = Arrays.stream(JWEAlgorithm.class.getDeclaredFields()).filter(f -> f.getType().equals(JWEAlgorithm.class)).map(Unchecked.function(f -> {
            f.setAccessible(true);
            return ((JWEAlgorithm)f.get(null)).getName();
        })).collect(Collectors.joining(","));
        LOGGER.debug("Encryption algorithm: [{}]. Available algorithms are [{}]", (Object)encryptionAlgorithm, (Object)acceptedEncAlgs);
        String acceptedEncMethods = Arrays.stream(EncryptionMethod.class.getDeclaredFields()).filter(f -> f.getType().equals(EncryptionMethod.class)).map(Unchecked.function(f -> {
            f.setAccessible(true);
            return ((EncryptionMethod)f.get(null)).getName();
        })).collect(Collectors.joining(","));
        LOGGER.debug("Encryption method: [{}]. Available methods are [{}]", (Object)encryptionMethod, (Object)acceptedEncMethods);
        JWEAlgorithm algorithm = JWEAlgorithm.parse((String)encryptionAlgorithm);
        if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm.getName()) && !DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(encryptionMethod)) {
            LOGGER.warn("Encrypted method [{}] is not supported for algorithm [{}]. Accepted methods are [{}]", new Object[]{encryptionMethod, encryptionAlgorithm, DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS});
            return;
        }
        if (AESDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && !AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(encryptionMethod)) {
            LOGGER.warn("Encrypted method [{}] is not supported for algorithm [{}]. Accepted methods are [{}]", new Object[]{encryptionMethod, encryptionAlgorithm, AESDecrypter.SUPPORTED_ENCRYPTION_METHODS});
            return;
        }
        EncryptionMethod encMethod = EncryptionMethod.parse((String)encryptionMethod);
        g.setEncryptionConfiguration((EncryptionConfiguration)new SecretEncryptionConfiguration(encryptionSecret, algorithm, encMethod));
    }

    private void configureJwtSigning(int signingSecretSize, String signingAlgorithm, JwtGenerator<CommonProfile> g) {
        if (signingSecretSize <= 0 || StringUtils.isBlank((CharSequence)signingAlgorithm)) {
            LOGGER.info("No signing algorithm or size specified, so the generated JWT will not be encrypted");
            return;
        }
        String signingSecret = RandomStringUtils.randomAlphanumeric((int)signingSecretSize);
        LOGGER.info("==== Signing Secret ====\n{}\n", (Object)signingSecret);
        String acceptedSigningAlgs = Arrays.stream(JWSAlgorithm.class.getDeclaredFields()).filter(f -> f.getType().equals(JWSAlgorithm.class)).map(Unchecked.function(f -> {
            f.setAccessible(true);
            return ((JWSAlgorithm)f.get(null)).getName();
        })).collect(Collectors.joining(","));
        LOGGER.debug("Signing algorithm: [{}]. Available algorithms are [{}]", (Object)signingAlgorithm, (Object)acceptedSigningAlgs);
        g.setSignatureConfiguration((SignatureConfiguration)new SecretSignatureConfiguration(signingSecret, JWSAlgorithm.parse((String)signingAlgorithm)));
    }
}

