/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.util.DefaultRegisteredServiceJsonSerializer;
import org.apereo.cas.services.util.RegisteredServiceYamlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Service;

@Service
public class GenerateYamlRegisteredServiceCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateYamlRegisteredServiceCommand.class);
    private static final int SEP_LINE_LENGTH = 70;

    @CliCommand(value={"generate-yaml"}, help="Generate a YAML registered service definition")
    public void generateYaml(@CliOption(key={"file"}, help="Path to the JSON service definition file", specifiedDefaultValue="", unspecifiedDefaultValue="", mandatory=true, optionContext="Path to the JSON service definition") String file, @CliOption(key={"destination"}, help="Path to the destination YAML service definition file", specifiedDefaultValue="", unspecifiedDefaultValue="", optionContext="Path to the destination YAML service definition file") String destination) {
        if (StringUtils.isBlank((CharSequence)file)) {
            LOGGER.warn("File must be specified");
            return;
        }
        File filePath = new File(file);
        File result = StringUtils.isBlank((CharSequence)destination) ? null : new File(destination);
        this.generate(filePath, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(File filePath, File result) {
        block19: {
            try {
                DefaultRegisteredServiceJsonSerializer validator = new DefaultRegisteredServiceJsonSerializer();
                if (filePath.isFile() && filePath.exists() && filePath.canRead() && filePath.length() > 0L) {
                    RegisteredService svc = (RegisteredService)validator.from(filePath);
                    LOGGER.info("Service [{}] is valid at [{}].", (Object)svc.getName(), (Object)filePath.getCanonicalPath());
                    RegisteredServiceYamlSerializer yaml = new RegisteredServiceYamlSerializer();
                    try (StringWriter writer = new StringWriter();){
                        yaml.to((Writer)writer, (Object)svc);
                        LOGGER.info(writer.toString());
                        if (result != null) {
                            yaml.to(result, (Object)svc);
                            LOGGER.info("YAML service definition is saved at [{}].", (Object)result.getCanonicalPath());
                        }
                        break block19;
                    }
                }
                LOGGER.warn("File [{}] is does not exist, is not readable or is empty", (Object)filePath.getCanonicalPath());
            }
            catch (Exception e) {
                LOGGER.error("Could not understand and validate [{}]: [{}]", (Object)filePath.getPath(), (Object)e.getMessage());
            }
            finally {
                LOGGER.info(StringUtils.repeat((char)'-', (int)70));
            }
        }
    }
}

