/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.shell.cli.CasCommandLineParser;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.spring.boot.DefaultCasBanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.shell.plugin.support.DefaultBannerProvider;
import org.springframework.stereotype.Service;

@Service(value="casBannerProvider")
@Order(value=-2147483648)
public class CasBannerProvider
extends DefaultBannerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasBannerProvider.class);
    @Autowired
    private Environment environment;

    public String getProviderName() {
        return "CAS Command-line Shell";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBanner() {
        if (CasCommandLineParser.isSkippingBanner((Environment)this.environment)) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String content;
            PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());
            new DefaultCasBanner().printBanner(this.environment, this.getClass(), ps);
            String string = content = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "CAS";
        }
    }

    public String getVersion() {
        if (StringUtils.isBlank((CharSequence)CasVersion.getVersion())) {
            return "";
        }
        return CasVersion.getVersion() + "#" + CasVersion.getSpecificationVersion();
    }

    public String getWelcomeMessage() {
        return "Welcome to " + this.getProviderName() + ". For assistance press or type \"help\" then hit ENTER.";
    }
}

