/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.cli;

import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apereo.cas.shell.cli.CasCommandLineParser;
import org.apereo.cas.shell.commands.FindPropertiesCommand;
import org.apereo.cas.shell.commands.GenerateCryptoKeysCommand;
import org.apereo.cas.shell.commands.GenerateJwtCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasCommandLineEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCommandLineEngine.class);

    public void execute(String[] args) {
        CasCommandLineParser parser = new CasCommandLineParser();
        CommandLine line = parser.parse(args);
        if (args.length == 0 || parser.isHelp(line)) {
            parser.printHelp();
            return;
        }
        boolean strict = parser.isStrictMatch(line);
        Pattern propertyPattern = parser.getProperty(line);
        if (parser.isGeneratingKey(line)) {
            GenerateCryptoKeysCommand cmd = new GenerateCryptoKeysCommand();
            cmd.generateKey(parser.getPropertyValue(line));
        } else if (parser.isGeneratingJwt(line)) {
            GenerateJwtCommand cmd = new GenerateJwtCommand();
            cmd.generate(parser.getSubject(line));
        } else {
            FindPropertiesCommand cmd = new FindPropertiesCommand();
            cmd.find(propertyPattern.pattern(), strict, parser.isSummary(line));
        }
    }
}

