/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.shell.commands.FindPropertiesCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Service
public class AddPropertiesToConfigurationCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindPropertiesCommand.class);

    @CliCommand(value={"add-properties"}, help="Add properties associated with a CAS group/module to a Properties/Yaml configuration file.")
    public void add(@CliOption(key={"file"}, help="Path to the CAS configuration file", unspecifiedDefaultValue="/etc/cas/config/cas.properties", specifiedDefaultValue="/etc/cas/config/cas.properties", optionContext="Path to the CAS configuration file") String file, @CliOption(key={"group"}, specifiedDefaultValue="", unspecifiedDefaultValue="", help="Group/module whose associated settings should be added to the CAS configuration file", optionContext="Group/module whose associated settings should be added to the CAS configuration file", mandatory=true) String group) throws Exception {
        if (StringUtils.isBlank((CharSequence)file)) {
            LOGGER.warn("Configuration file must be specified");
            return;
        }
        File filePath = new File(file);
        if (filePath.exists() && (filePath.isDirectory() || !filePath.canRead() || !filePath.canWrite())) {
            LOGGER.warn("Configuration file [{}] is not readable/writable or is not a path to a file", (Object)filePath.getCanonicalPath());
            return;
        }
        Map results = this.findProperties(group);
        LOGGER.info("Located [{}] properties matching [{}]", (Object)results.size(), (Object)group);
        switch (FilenameUtils.getExtension((String)filePath.getName()).toLowerCase()) {
            case "properties": {
                this.createConfigurationFileIfNeeded(filePath);
                Properties props = this.loadPropertiesFromConfigurationFile(filePath);
                this.writeConfigurationPropertiesToFile(filePath, results, props);
                break;
            }
            case "yml": {
                this.createConfigurationFileIfNeeded(filePath);
                Properties yamlProps = this.loadYamlPropertiesFromConfigurationFile(filePath);
                this.writeYamlConfigurationPropertiesToFile(filePath, results, yamlProps);
                break;
            }
            default: {
                LOGGER.warn("Configuration file format [{}] is not recognized", (Object)filePath.getCanonicalPath());
            }
        }
    }

    private void writeYamlConfigurationPropertiesToFile(File filePath, Map<String, ConfigurationMetadataProperty> results, Properties yamlProps) throws Exception {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setPrettyFlow(true);
        options.setAllowUnicode(true);
        Yaml yaml = new Yaml(options);
        try (FileWriter writer = new FileWriter(filePath);){
            this.putResultsIntoProperties(results, yamlProps);
            yaml.dump((Object)yamlProps, (Writer)writer);
        }
    }

    private Properties loadYamlPropertiesFromConfigurationFile(File filePath) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResolutionMethod(YamlProcessor.ResolutionMethod.OVERRIDE);
        factory.setResources(new Resource[]{new FileSystemResource(filePath)});
        factory.setSingleton(true);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    private void writeConfigurationPropertiesToFile(File filePath, Map<String, ConfigurationMetadataProperty> results, Properties p) throws Exception {
        LOGGER.info("Located [{}] properties in configuration file [{}]", (Object)results.size(), (Object)filePath.getCanonicalPath());
        this.putResultsIntoProperties(results, p);
        List lines = p.stringPropertyNames().stream().map(s -> s + "=" + p.get(s)).collect(Collectors.toList());
        Collections.sort(lines, Comparator.naturalOrder());
        FileUtils.writeLines((File)filePath, lines);
    }

    private void putResultsIntoProperties(Map<String, ConfigurationMetadataProperty> results, Properties p) {
        List<ConfigurationMetadataProperty> lines = results.values().stream().collect(Collectors.toList());
        Collections.sort(lines, Comparator.comparing(ConfigurationMetadataProperty::getName));
        lines.forEach(v -> {
            String value = v.getDefaultValue() == null ? "" : v.getDefaultValue().toString();
            LOGGER.info("Adding property [{}={}]", (Object)v.getId(), (Object)value);
            p.put("# " + v.getId(), value);
        });
    }

    private Properties loadPropertiesFromConfigurationFile(File filePath) throws IOException {
        Properties p = new Properties();
        try (FileReader f = new FileReader(filePath);){
            p.load(f);
        }
        return p;
    }

    private Map<String, ConfigurationMetadataProperty> findProperties(String group) {
        FindPropertiesCommand find = new FindPropertiesCommand();
        Map results = find.findByProperty(group);
        return results;
    }

    private void createConfigurationFileIfNeeded(File filePath) throws IOException {
        if (!filePath.exists()) {
            LOGGER.debug("Creating configuration file [{}]", (Object)filePath.getCanonicalPath());
            boolean created = filePath.createNewFile();
            if (created) {
                LOGGER.info("Created configuration file [{}]", (Object)filePath.getCanonicalPath());
            }
        }
    }
}

