/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Service;

@Service
public class FindPropertiesCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindPropertiesCommand.class);
    private static final int SEP_LINE_LENGTH = 70;

    @CliCommand(value={"find"}, help="Look up properties associated with a CAS group/module.")
    public void find(@CliOption(key={"name"}, help="Property name regex pattern", optionContext="Property name regex pattern", specifiedDefaultValue=".+", unspecifiedDefaultValue=".+") String name, @CliOption(key={"strict-match"}, help="Whether pattern should be done in strict-mode which means the matching engine tries to match the entire region for the query.", optionContext="Whether pattern should be done in strict-mode which means the matching engine tries to match the entire region for the query.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean strict, @CliOption(key={"summary"}, help="Whether results should be presented in summarized mode", optionContext="Whether results should be presented in summarized mode", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean summary) {
        Map results = this.find(strict, RegexUtils.createPattern((String)name));
        if (results.isEmpty()) {
            LOGGER.info("Could not find any results matching the criteria");
            return;
        }
        results.forEach((k, v) -> {
            if (summary) {
                LOGGER.info("{}={}", k, v.getDefaultValue());
                String value = StringUtils.normalizeSpace((String)v.getShortDescription());
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    LOGGER.info("{}", (Object)value);
                }
            } else {
                LOGGER.info("Property: {}", k);
                LOGGER.info("Group: {}", (Object)StringUtils.substringBeforeLast((String)k, (String)"."));
                LOGGER.info("Default Value: {}", ObjectUtils.defaultIfNull((Object)v.getDefaultValue(), (Object)"[blank]"));
                LOGGER.info("Type: {}", (Object)v.getType());
                LOGGER.info("Summary: {}", (Object)StringUtils.normalizeSpace((String)v.getShortDescription()));
                LOGGER.info("Description: {}", (Object)StringUtils.normalizeSpace((String)v.getDescription()));
                LOGGER.info("Deprecated: {}", (Object)BooleanUtils.toStringYesNo((boolean)v.isDeprecated()));
            }
            LOGGER.info(StringUtils.repeat((char)'-', (int)70));
        });
    }

    public Map<String, ConfigurationMetadataProperty> find(boolean strict, Pattern propertyPattern) {
        LinkedHashMap<String, ConfigurationMetadataProperty> results = new LinkedHashMap<String, ConfigurationMetadataProperty>();
        CasConfigurationMetadataRepository repository = new CasConfigurationMetadataRepository();
        Map props = repository.getRepository().getAllProperties();
        props.forEach((k, v) -> {
            boolean matched = StreamSupport.stream(RelaxedNames.forCamelCase((String)k).spliterator(), false).map(Object::toString).anyMatch(name -> strict ? RegexUtils.matches((Pattern)propertyPattern, (String)name) : RegexUtils.find((Pattern)propertyPattern, (String)name));
            if (matched) {
                results.put((String)k, (ConfigurationMetadataProperty)v);
            }
        });
        return results;
    }

    public Map<String, ConfigurationMetadataProperty> findByProperty(String name) {
        return this.find(false, RegexUtils.createPattern((String)name));
    }
}

