/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Service;

@Service
public class GenerateCryptoKeysCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateCryptoKeysCommand.class);

    @CliCommand(value={"generate-key"}, help="Generate signing/encryption crypto keys for CAS settings")
    public void generateKey(@CliOption(key={"group"}, help="Property group that holds the key (i.e. cas.webflow). The group must have a child category of 'crypto'.", mandatory=true, specifiedDefaultValue="", unspecifiedDefaultValue="", optionContext="Property name for that holds the key") String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            LOGGER.warn("No property/setting name is specified for signing/encryption key generation.");
            return;
        }
        CasConfigurationMetadataRepository repository = new CasConfigurationMetadataRepository();
        String cryptoGroup = name.concat(".crypto");
        repository.getRepository().getAllGroups().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(cryptoGroup)).forEach(e -> {
            ConfigurationMetadataGroup grp = (ConfigurationMetadataGroup)e.getValue();
            grp.getSources().forEach(Unchecked.biConsumer((k, v) -> {
                Object obj = ClassUtils.getClass((String)k, (boolean)true).newInstance();
                if (obj instanceof EncryptionJwtSigningJwtCryptographyProperties) {
                    EncryptionJwtSigningJwtCryptographyProperties crypto = (EncryptionJwtSigningJwtCryptographyProperties)obj;
                    LOGGER.info(cryptoGroup.concat(".encryption.key=" + EncodingUtils.generateJsonWebKey((int)crypto.getEncryption().getKeySize())));
                    LOGGER.info(cryptoGroup.concat(".signing.key=" + EncodingUtils.generateJsonWebKey((int)crypto.getSigning().getKeySize())));
                } else if (obj instanceof EncryptionRandomizedSigningJwtCryptographyProperties) {
                    EncryptionRandomizedSigningJwtCryptographyProperties crypto = (EncryptionRandomizedSigningJwtCryptographyProperties)obj;
                    String encKey = new Base64RandomStringGenerator(crypto.getEncryption().getKeySize()).getNewString();
                    LOGGER.info(cryptoGroup.concat(".encryption.key=" + encKey));
                    LOGGER.info(cryptoGroup.concat(".signing.key=" + EncodingUtils.generateJsonWebKey((int)crypto.getSigning().getKeySize())));
                }
            }));
        });
    }
}

