/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.stereotype.Service;

@Service
public class ListUndocumentedPropertiesCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListUndocumentedPropertiesCommand.class);

    @CliCommand(value={"list-undocumented"}, help="List all CAS undocumented properties.")
    public void listUndocumented() {
        CasConfigurationMetadataRepository repository = new CasConfigurationMetadataRepository();
        repository.getRepository().getAllProperties().entrySet().stream().filter(p -> ((String)p.getKey()).startsWith("cas.") && (StringUtils.isBlank((CharSequence)((ConfigurationMetadataProperty)p.getValue()).getShortDescription()) || StringUtils.isBlank((CharSequence)((ConfigurationMetadataProperty)p.getValue()).getDescription()))).map(Map.Entry::getValue).sorted(Comparator.comparing(ConfigurationMetadataProperty::getId)).forEach(p -> LOGGER.info("Property: {} @ {}", (Object)p.getId(), (Object)p.getType()));
    }
}

