/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.shell.commands;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.util.DefaultRegisteredServiceJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Service;

@Service
public class ValidateRegisteredServiceCommand
implements CommandMarker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateRegisteredServiceCommand.class);
    private static final int SEP_LINE_LENGTH = 70;

    @CliCommand(value={"validate-service"}, help="Validate a given JSON/YAML service definition by path or directory")
    public void validateService(@CliOption(key={"file"}, help="Path to the JSON/YAML service definition file", specifiedDefaultValue="", unspecifiedDefaultValue="", optionContext="Path to the JSON/YAML service definition") String file, @CliOption(key={"directory"}, help="Path to the JSON/YAML service definitions directory", specifiedDefaultValue="/etc/cas/services", unspecifiedDefaultValue="/etc/cas/services", optionContext="Path to the JSON/YAML service definitions directory") String directory) {
        if (StringUtils.isBlank((CharSequence)file) && StringUtils.isBlank((CharSequence)directory)) {
            LOGGER.warn("Either file or directory must be specified");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)file)) {
            File filePath = new File(file);
            this.validate(filePath);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)directory)) {
            File directoryPath = new File(directory);
            if (directoryPath.isDirectory()) {
                FileUtils.listFiles((File)directoryPath, (String[])new String[]{"json", "yml"}, (boolean)false).forEach(arg_0 -> this.validate(arg_0));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(File filePath) {
        try {
            DefaultRegisteredServiceJsonSerializer validator = new DefaultRegisteredServiceJsonSerializer();
            if (filePath.isFile() && filePath.exists() && filePath.canRead() && filePath.length() > 0L) {
                RegisteredService svc = (RegisteredService)validator.from(filePath);
                LOGGER.info("Service [{}] is valid at [{}].", (Object)svc.getName(), (Object)filePath.getCanonicalPath());
            } else {
                LOGGER.warn("File [{}] is does not exist, is not readable or is empty", (Object)filePath.getCanonicalPath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not understand and validate [{}]: [{}]", (Object)filePath.getPath(), (Object)e.getMessage());
        }
        finally {
            LOGGER.info(StringUtils.repeat((char)'-', (int)70));
        }
    }
}

