/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.thymeleaf.spring4.view.AbstractThymeleafView;

public class ThemeViewResolver
extends AbstractCachingViewResolver {
    @Nonnull
    private final ViewResolver delegate;
    @Nonnull
    private final ThymeleafProperties thymeleafProperties;
    @Nonnull
    private final String theme;

    public ThemeViewResolver(@Nonnull ViewResolver baseResolver, @Nonnull ThymeleafProperties thymeleafProperties, @Nonnull String theme) {
        this.delegate = baseResolver;
        this.thymeleafProperties = thymeleafProperties;
        this.theme = theme;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        View view = this.delegate.resolveViewName(viewName, locale);
        if (view instanceof AbstractThymeleafView) {
            AbstractThymeleafView thymeleafView = (AbstractThymeleafView)view;
            String baseTemplateName = thymeleafView.getTemplateName();
            String templateName = this.theme + "/" + baseTemplateName;
            TemplateLocation location = new TemplateLocation(this.thymeleafProperties.getPrefix().concat(templateName).concat(this.thymeleafProperties.getSuffix()));
            if (location.exists((ResourcePatternResolver)this.getApplicationContext())) {
                thymeleafView.setTemplateName(templateName);
            }
        }
        return view;
    }

    public static class Factory
    implements ThemeViewResolverFactory,
    ApplicationContextAware {
        @Nonnull
        private final ViewResolver delegate;
        @Nonnull
        private final ThymeleafProperties thymeleafProperties;
        private ApplicationContext applicationContext;

        public Factory(@Nonnull ViewResolver delegate, @Nonnull ThymeleafProperties thymeleafProperties) {
            this.delegate = delegate;
            this.thymeleafProperties = thymeleafProperties;
        }

        public ThemeViewResolver create(@Nonnull String theme) {
            ThemeViewResolver resolver = new ThemeViewResolver(this.delegate, this.thymeleafProperties, theme);
            resolver.setApplicationContext(this.applicationContext);
            resolver.setCache(this.thymeleafProperties.isCache());
            return resolver;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }
}

