/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class RegisteredServiceThemeResolver
extends AbstractThemeResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceThemeResolver.class);
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final CasConfigurationProperties casProperties;
    private final ResourceLoader resourceLoader;
    private final Map<Pattern, String> overrides;

    public RegisteredServiceThemeResolver(ServicesManager servicesManager, Map<String, String> mobileOverrides, AuthenticationServiceSelectionPlan serviceSelectionStrategies, ResourceLoader resourceLoader, CasConfigurationProperties casProperties) {
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = serviceSelectionStrategies;
        this.resourceLoader = resourceLoader;
        this.casProperties = casProperties;
        this.overrides = mobileOverrides.entrySet().stream().collect(Collectors.toMap(entry -> Pattern.compile((String)entry.getKey()), Map.Entry::getValue));
    }

    public String resolveThemeName(HttpServletRequest request) {
        if (this.servicesManager == null) {
            return this.rememberThemeName(request);
        }
        String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return this.rememberThemeName(request);
        }
        this.overrides.entrySet().stream().filter(entry -> ((Pattern)entry.getKey()).matcher(userAgent).matches()).findFirst().ifPresent(entry -> {
            request.setAttribute("isMobile", (Object)Boolean.TRUE.toString());
            request.setAttribute("browserType", entry.getValue());
        });
        RequestContext context = RequestContextHolder.getRequestContext();
        WebApplicationService serviceContext = WebUtils.getService((RequestContext)context);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)serviceContext);
        if (service == null) {
            LOGGER.trace("No service is found in the request context. Falling back to the default theme [{}]", (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        RegisteredService rService = this.servicesManager.findServiceBy(service);
        if (rService == null || !rService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("No registered service is found to match [{}] or access is denied. Using default theme [{}]", (Object)service, (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        if (StringUtils.isBlank((CharSequence)rService.getTheme())) {
            LOGGER.trace("No theme name is specified for service [{}]. Using default theme [{}]", (Object)rService, (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        String themeName = this.determineThemeNameToChoose(request, service, rService);
        return this.rememberThemeName(request, themeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String determineThemeNameToChoose(HttpServletRequest request, Service service, RegisteredService rService) {
        HttpResponse response = null;
        try {
            LOGGER.debug("Service [{}] is configured to use a custom theme [{}]", (Object)rService, (Object)rService.getTheme());
            AbstractResource resource = ResourceUtils.getRawResourceFrom((String)rService.getTheme());
            if (resource instanceof FileSystemResource && resource.exists()) {
                LOGGER.debug("Executing groovy script to determine theme for [{}]", (Object)service.getId());
                String result = (String)ScriptingUtils.executeGroovyScript((Resource)resource, (Object[])new Object[]{service, rService, request.getQueryString(), HttpRequestUtils.getRequestHeaders((HttpServletRequest)request), LOGGER}, String.class, (boolean)true);
                String string = (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)this.getDefaultThemeName());
                HttpUtils.close((HttpResponse)response);
                return string;
            }
            if (resource instanceof UrlResource) {
                String url = resource.getURL().toExternalForm();
                LOGGER.debug("Executing URL [{}] to determine theme for [{}]", (Object)url, (Object)service.getId());
                response = HttpUtils.executeGet((String)url, (Map)CollectionUtils.wrap((String)"service", (Object)service.getId()));
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    String string = (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)this.getDefaultThemeName());
                    HttpUtils.close((HttpResponse)response);
                    return string;
                }
            }
            CasThemeResourceBundleMessageSource messageSource = new CasThemeResourceBundleMessageSource();
            messageSource.setBasename(rService.getTheme());
            if (messageSource.doGetBundle(rService.getTheme(), request.getLocale()) != null) {
                LOGGER.trace("Found custom theme [{}] for service [{}]", (Object)rService.getTheme(), (Object)rService);
                String string = rService.getTheme();
                HttpUtils.close((HttpResponse)response);
                return string;
            }
            LOGGER.warn("Custom theme [{}] for service [{}] cannot be located. Falling back to default theme...", (Object)rService.getTheme(), (Object)rService);
            HttpUtils.close((HttpResponse)response);
            return this.getDefaultThemeName();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.getDefaultThemeName();
        }
        finally {
            HttpUtils.close(response);
        }
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    protected String rememberThemeName(HttpServletRequest request) {
        return this.rememberThemeName(request, this.getDefaultThemeName());
    }

    protected String rememberThemeName(HttpServletRequest request, String themeName) {
        request.setAttribute(this.casProperties.getTheme().getParamName(), (Object)themeName);
        return themeName;
    }

    private static class CasThemeResourceBundleMessageSource
    extends ResourceBundleMessageSource {
        private CasThemeResourceBundleMessageSource() {
        }

        protected ResourceBundle doGetBundle(String basename, Locale locale) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
                if (bundle != null && !bundle.keySet().isEmpty()) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

