/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.appfuse.dao.GenericDao;
import org.appfuse.dao.SearchException;
import org.appfuse.dao.hibernate.HibernateSearchTools;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.orm.ObjectRetrievalFailureException;

public class GenericDaoHibernate<T, PK extends Serializable>
implements GenericDao<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Class<T> persistentClass;
    @Resource
    private SessionFactory sessionFactory;
    private Analyzer defaultAnalyzer;

    public GenericDaoHibernate(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
        this.defaultAnalyzer = new StandardAnalyzer(Version.LUCENE_36);
    }

    public GenericDaoHibernate(Class<T> persistentClass, SessionFactory sessionFactory) {
        this.persistentClass = persistentClass;
        this.sessionFactory = sessionFactory;
        this.defaultAnalyzer = new StandardAnalyzer(Version.LUCENE_36);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session getSession() throws HibernateException {
        Session sess = this.getSessionFactory().getCurrentSession();
        if (sess == null) {
            sess = this.getSessionFactory().openSession();
        }
        return sess;
    }

    @Autowired
    @Required
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<T> getAll() {
        Session sess = this.getSession();
        return sess.createCriteria(this.persistentClass).list();
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public List<T> search(String searchTerm) throws SearchException {
        Query qry;
        Session sess = this.getSession();
        FullTextSession txtSession = Search.getFullTextSession((Session)sess);
        try {
            qry = HibernateSearchTools.generateQuery(searchTerm, this.persistentClass, sess, this.defaultAnalyzer);
        }
        catch (ParseException ex) {
            throw new SearchException(ex);
        }
        FullTextQuery hibQuery = txtSession.createFullTextQuery(qry, new Class[]{this.persistentClass});
        return hibQuery.list();
    }

    @Override
    public T get(PK id) {
        Session sess = this.getSession();
        IdentifierLoadAccess byId = sess.byId(this.persistentClass);
        Object entity = byId.load(id);
        if (entity == null) {
            this.log.warn((Object)("Uh oh, '" + this.persistentClass + "' object with id '" + id + "' not found..."));
            throw new ObjectRetrievalFailureException(this.persistentClass, id);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Session sess = this.getSession();
        IdentifierLoadAccess byId = sess.byId(this.persistentClass);
        Object entity = byId.load(id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        Session sess = this.getSession();
        return (T)sess.merge(object);
    }

    @Override
    public void remove(T object) {
        Session sess = this.getSession();
        sess.delete(object);
    }

    @Override
    public void remove(PK id) {
        Session sess = this.getSession();
        IdentifierLoadAccess byId = sess.byId(this.persistentClass);
        Object entity = byId.load(id);
        sess.delete(entity);
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        Session sess = this.getSession();
        org.hibernate.Query namedQuery = sess.getNamedQuery(queryName);
        for (String s : queryParams.keySet()) {
            Object val = queryParams.get(s);
            if (val instanceof Collection) {
                namedQuery.setParameterList(s, (Collection)val);
                continue;
            }
            namedQuery.setParameter(s, val);
        }
        return namedQuery.list();
    }

    @Override
    public void reindex() {
        HibernateSearchTools.reindex(this.persistentClass, this.getSessionFactory().getCurrentSession());
    }

    @Override
    public void reindexAll(boolean async) {
        HibernateSearchTools.reindexAll(async, this.getSessionFactory().getCurrentSession());
    }
}

