/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import org.asynchttpclient.Request;

public interface KeepAliveStrategy {
    public boolean keepAlive(Request var1, HttpRequest var2, HttpResponse var3);

    public static enum DefaultKeepAliveStrategy implements KeepAliveStrategy
    {
        INSTANCE;


        @Override
        public boolean keepAlive(Request ahcRequest, HttpRequest request, HttpResponse response) {
            String responseConnectionHeader = this.connectionHeader((HttpMessage)response);
            if ("close".equalsIgnoreCase(responseConnectionHeader)) {
                return false;
            }
            String requestConnectionHeader = this.connectionHeader((HttpMessage)request);
            if (request.getProtocolVersion() == HttpVersion.HTTP_1_0) {
                return "keep-alive".equalsIgnoreCase(requestConnectionHeader) && "keep-alive".equalsIgnoreCase(responseConnectionHeader);
            }
            return !"close".equalsIgnoreCase(requestConnectionHeader);
        }

        private String connectionHeader(HttpMessage message) {
            return message.headers().get("Connection");
        }
    }
}

