/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.cookie.CookieEncoder;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.netty.request.body.NettyBodyBody;
import org.asynchttpclient.netty.request.body.NettyByteArrayBody;
import org.asynchttpclient.netty.request.body.NettyByteBufferBody;
import org.asynchttpclient.netty.request.body.NettyCompositeByteArrayBody;
import org.asynchttpclient.netty.request.body.NettyDirectBody;
import org.asynchttpclient.netty.request.body.NettyFileBody;
import org.asynchttpclient.netty.request.body.NettyInputStreamBody;
import org.asynchttpclient.netty.request.body.NettyMultipartBody;
import org.asynchttpclient.netty.request.body.NettyReactiveStreamsBody;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.request.body.generator.FileBodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.ws.WebSocketUtils;

public final class NettyRequestFactory {
    public static final String GZIP_DEFLATE = "gzip,deflate";
    private final AsyncHttpClientConfig config;

    public NettyRequestFactory(AsyncHttpClientConfig config) {
        this.config = config;
    }

    private NettyBody body(Request request, boolean connect) {
        NettyBody nettyBody = null;
        if (!connect) {
            Charset bodyCharset;
            Charset charset = bodyCharset = request.getCharset() == null ? HttpUtils.DEFAULT_CHARSET : request.getCharset();
            if (request.getByteData() != null) {
                nettyBody = new NettyByteArrayBody(request.getByteData());
            } else if (request.getCompositeByteData() != null) {
                nettyBody = new NettyCompositeByteArrayBody(request.getCompositeByteData());
            } else if (request.getStringData() != null) {
                nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer(request.getStringData(), bodyCharset));
            } else if (request.getByteBufferData() != null) {
                nettyBody = new NettyByteBufferBody(request.getByteBufferData());
            } else if (request.getStreamData() != null) {
                nettyBody = new NettyInputStreamBody(request.getStreamData());
            } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
                String contentType = null;
                if (!request.getHeaders().contains("Content-Type")) {
                    contentType = "application/x-www-form-urlencoded";
                }
                nettyBody = new NettyByteBufferBody(HttpUtils.urlEncodeFormParams(request.getFormParams(), bodyCharset), contentType);
            } else if (MiscUtils.isNonEmpty(request.getBodyParts())) {
                nettyBody = new NettyMultipartBody(request.getBodyParts(), request.getHeaders(), this.config);
            } else if (request.getFile() != null) {
                nettyBody = new NettyFileBody(request.getFile(), this.config);
            } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
                FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
                nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.config);
            } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
                nettyBody = new NettyInputStreamBody(((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator())).getInputStream());
            } else if (request.getBodyGenerator() instanceof ReactiveStreamsBodyGenerator) {
                nettyBody = new NettyReactiveStreamsBody(((ReactiveStreamsBodyGenerator)ReactiveStreamsBodyGenerator.class.cast(request.getBodyGenerator())).getPublisher());
            } else if (request.getBodyGenerator() != null) {
                nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.config);
            }
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add("Authorization", (Object)authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set("Proxy-Authorization", (Object)proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request, boolean forceConnect, ProxyServer proxyServer, Realm realm, Realm proxyRealm) {
        String connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultFullHttpRequest httpRequest;
        Uri uri = request.getUri();
        HttpMethod method = forceConnect ? HttpMethod.CONNECT : HttpMethod.valueOf((String)request.getMethod());
        boolean connect = method == HttpMethod.CONNECT;
        HttpVersion httpVersion = connect && proxyServer.isForceHttp10() ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody body = this.body(request, connect);
        if (body instanceof NettyDirectBody) {
            ByteBuf buf = ((NettyDirectBody)NettyDirectBody.class.cast(body)).byteBuf();
            httpRequest = new DefaultFullHttpRequest(httpVersion, method, requestUri, buf);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, null);
        } else if (body == null) {
            httpRequest = new DefaultFullHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, body);
        }
        HttpHeaders headers = httpRequest.headers();
        if (connect) {
            headers.set("Proxy-Authorization", (Iterable)request.getHeaders().getAll("Proxy-Authorization"));
        } else {
            headers.set(request.getHeaders());
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                headers.set("Cookie", (Object)CookieEncoder.encode(request.getCookies()));
            }
            if (this.config.isCompressionEnforced() && !headers.contains("Accept-Encoding")) {
                headers.set("Accept-Encoding", (Object)GZIP_DEFLATE);
            }
        }
        if (body != null) {
            if (body.getContentLength() < 0L) {
                headers.set("Transfer-Encoding", (Object)"chunked");
            } else {
                headers.set("Content-Length", (Object)body.getContentLength());
            }
            if (body.getContentType() != null) {
                headers.set("Content-Type", (Object)body.getContentType());
            }
        }
        if (!connect && uri.isWebSocket()) {
            headers.set("Upgrade", (Object)"WebSocket").set("Connection", (Object)"Upgrade").set("Origin", (Object)("http://" + uri.getHost() + ":" + uri.getExplicitPort())).set("Sec-WebSocket-Key", (Object)WebSocketUtils.getKey()).set("Sec-WebSocket-Version", (Object)"13");
        } else if (!headers.contains("Connection") && (connectionHeaderValue = this.connectionHeader(this.config.isKeepAlive(), httpVersion)) != null) {
            headers.set("Connection", (Object)connectionHeaderValue);
        }
        if (!headers.contains("Host")) {
            headers.set("Host", (Object)HttpUtils.hostHeader(request, uri));
        }
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader(realm));
        this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader(proxyRealm));
        if (!headers.contains("Accept")) {
            headers.set("Accept", (Object)"*/*");
        }
        if (!headers.contains("User-Agent") && this.config.getUserAgent() != null) {
            headers.set("User-Agent", (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }

    private String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return HttpUtils.getAuthority(uri);
        }
        if (proxyServer != null) {
            return uri.toUrl();
        }
        String path = HttpUtils.getNonEmptyPath(uri);
        if (MiscUtils.isNonEmpty(uri.getQuery())) {
            return path + "?" + uri.getQuery();
        }
        return path;
    }

    private String connectionHeader(boolean keepAlive, HttpVersion httpVersion) {
        if (httpVersion.isKeepAliveDefault()) {
            return keepAlive ? null : "close";
        }
        return keepAlive ? "keep-alive" : null;
    }
}

