/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.Realm;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;

public class ProxyServer {
    private final String host;
    private final int port;
    private final int securedPort;
    private final Realm realm;
    private final List<String> nonProxyHosts;
    private final boolean forceHttp10;

    public ProxyServer(String host, int port, int securedPort, Realm realm, List<String> nonProxyHosts, boolean forceHttp10) {
        this.host = host;
        this.port = port;
        this.securedPort = securedPort;
        this.realm = realm;
        this.nonProxyHosts = nonProxyHosts;
        this.forceHttp10 = forceHttp10;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSecuredPort() {
        return this.securedPort;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public boolean isForceHttp10() {
        return this.forceHttp10;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public boolean isIgnoredForHost(String hostname) {
        Assertions.assertNotNull(hostname, "hostname");
        if (MiscUtils.isNonEmpty(this.nonProxyHosts)) {
            for (String nonProxyHost : this.nonProxyHosts) {
                if (!this.matchNonProxyHost(hostname, nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchNonProxyHost(String targetHost, String nonProxyHost) {
        if (nonProxyHost.length() > 1) {
            if (nonProxyHost.charAt(0) == '*') {
                return targetHost.regionMatches(true, targetHost.length() - nonProxyHost.length() + 1, nonProxyHost, 1, nonProxyHost.length() - 1);
            }
            if (nonProxyHost.charAt(nonProxyHost.length() - 1) == '*') {
                return targetHost.regionMatches(true, 0, nonProxyHost, 0, nonProxyHost.length() - 1);
            }
        }
        return nonProxyHost.equalsIgnoreCase(targetHost);
    }

    public static class Builder {
        private String host;
        private int port;
        private int securedPort;
        private Realm realm;
        private List<String> nonProxyHosts;
        private boolean forceHttp10;

        public Builder(String host, int port) {
            this.host = host;
            this.port = port;
            this.securedPort = port;
        }

        public Builder setSecuredPort(int securedPort) {
            this.securedPort = securedPort;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder setNonProxyHost(String nonProxyHost) {
            if (this.nonProxyHosts == null) {
                this.nonProxyHosts = new ArrayList<String>(1);
            }
            this.nonProxyHosts.add(nonProxyHost);
            return this;
        }

        public Builder setNonProxyHosts(List<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        public Builder setForceHttp10(boolean forceHttp10) {
            this.forceHttp10 = forceHttp10;
            return this;
        }

        public ProxyServer build() {
            List<String> nonProxyHosts = this.nonProxyHosts != null ? Collections.unmodifiableList(this.nonProxyHosts) : Collections.emptyList();
            return new ProxyServer(this.host, this.port, this.securedPort, this.realm, nonProxyHosts, this.forceHttp10);
        }
    }
}

