/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.resolver.DefaultNameResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.DefaultRequest;
import org.asynchttpclient.Param;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.EnsuresNonNull;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.UriEncoder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestBuilderBase<T extends RequestBuilderBase<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestBuilderBase.class);
    private static final Uri DEFAULT_REQUEST_URL = Uri.create("http://localhost");
    public static final NameResolver<InetAddress> DEFAULT_NAME_RESOLVER = new DefaultNameResolver((EventExecutor)ImmediateEventExecutor.INSTANCE);
    protected UriEncoder uriEncoder;
    @Nullable
    protected List<Param> queryParams;
    @Nullable
    protected SignatureCalculator signatureCalculator;
    protected String method;
    @Nullable
    protected Uri uri;
    @Nullable
    protected InetAddress address;
    @Nullable
    protected InetAddress localAddress;
    protected HttpHeaders headers;
    @Nullable
    protected ArrayList<Cookie> cookies;
    protected byte @Nullable [] byteData;
    @Nullable
    protected List<byte[]> compositeByteData;
    @Nullable
    protected String stringData;
    @Nullable
    protected ByteBuffer byteBufferData;
    @Nullable
    protected InputStream streamData;
    @Nullable
    protected BodyGenerator bodyGenerator;
    @Nullable
    protected List<Param> formParams;
    @Nullable
    protected List<Part> bodyParts;
    @Nullable
    protected String virtualHost;
    @Nullable
    protected ProxyServer proxyServer;
    @Nullable
    protected Realm realm;
    @Nullable
    protected File file;
    @Nullable
    protected Boolean followRedirect;
    @Nullable
    protected Duration requestTimeout;
    @Nullable
    protected Duration readTimeout;
    protected long rangeOffset;
    @Nullable
    protected Charset charset;
    protected ChannelPoolPartitioning channelPoolPartitioning = ChannelPoolPartitioning.PerHostChannelPoolPartitioning.INSTANCE;
    protected NameResolver<InetAddress> nameResolver = DEFAULT_NAME_RESOLVER;

    protected RequestBuilderBase(String method, boolean disableUrlEncoding) {
        this(method, disableUrlEncoding, true);
    }

    protected RequestBuilderBase(String method, boolean disableUrlEncoding, boolean validateHeaders) {
        this.method = method;
        this.uriEncoder = UriEncoder.uriEncoder(disableUrlEncoding);
        this.headers = new DefaultHttpHeaders(validateHeaders);
    }

    protected RequestBuilderBase(Request prototype) {
        this(prototype, false, false);
    }

    protected RequestBuilderBase(Request prototype, boolean disableUrlEncoding, boolean validateHeaders) {
        this.method = prototype.getMethod();
        this.uriEncoder = UriEncoder.uriEncoder(disableUrlEncoding);
        this.uri = prototype.getUri();
        this.address = prototype.getAddress();
        this.localAddress = prototype.getLocalAddress();
        this.headers = new DefaultHttpHeaders(validateHeaders);
        this.headers.add(prototype.getHeaders());
        if (MiscUtils.isNonEmpty(prototype.getCookies())) {
            this.cookies = new ArrayList<Cookie>(prototype.getCookies());
        }
        this.byteData = prototype.getByteData();
        this.compositeByteData = prototype.getCompositeByteData();
        this.stringData = prototype.getStringData();
        this.byteBufferData = prototype.getByteBufferData();
        this.streamData = prototype.getStreamData();
        this.bodyGenerator = prototype.getBodyGenerator();
        if (MiscUtils.isNonEmpty(prototype.getFormParams())) {
            this.formParams = new ArrayList<Param>(prototype.getFormParams());
        }
        if (MiscUtils.isNonEmpty(prototype.getBodyParts())) {
            this.bodyParts = new ArrayList<Part>(prototype.getBodyParts());
        }
        this.virtualHost = prototype.getVirtualHost();
        this.proxyServer = prototype.getProxyServer();
        this.realm = prototype.getRealm();
        this.file = prototype.getFile();
        this.followRedirect = prototype.getFollowRedirect();
        this.requestTimeout = prototype.getRequestTimeout();
        this.readTimeout = prototype.getReadTimeout();
        this.rangeOffset = prototype.getRangeOffset();
        this.charset = prototype.getCharset();
        this.channelPoolPartitioning = prototype.getChannelPoolPartitioning();
        this.nameResolver = prototype.getNameResolver();
    }

    private T asDerivedType() {
        return (T)this;
    }

    public T setUrl(String url) {
        return this.setUri(Uri.create(url));
    }

    public T setUri(Uri uri) {
        this.uri = uri;
        return this.asDerivedType();
    }

    public T setAddress(InetAddress address) {
        this.address = address;
        return this.asDerivedType();
    }

    public T setLocalAddress(InetAddress address) {
        this.localAddress = address;
        return this.asDerivedType();
    }

    public T setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this.asDerivedType();
    }

    public T clearHeaders() {
        this.headers.clear();
        return this.asDerivedType();
    }

    public T setHeader(CharSequence name, String value) {
        return this.setHeader(name, (Object)value);
    }

    public T setHeader(CharSequence name, Object value) {
        this.headers.set(name, value);
        return this.asDerivedType();
    }

    public T setHeader(CharSequence name, Iterable<?> values) {
        this.headers.set(name, values);
        return this.asDerivedType();
    }

    public T addHeader(CharSequence name, String value) {
        return this.addHeader(name, (Object)value);
    }

    public T addHeader(CharSequence name, Object value) {
        if (value == null) {
            LOGGER.warn("Value was null, set to \"\"");
            value = "";
        }
        this.headers.add(name, value);
        return this.asDerivedType();
    }

    public T addHeader(CharSequence name, Iterable<?> values) {
        this.headers.add(name, values);
        return this.asDerivedType();
    }

    public T setHeaders(HttpHeaders headers) {
        if (headers == null) {
            this.headers.clear();
        } else {
            this.headers = headers;
        }
        return this.asDerivedType();
    }

    public T setHeaders(Map<? extends CharSequence, ? extends Iterable<?>> headers) {
        this.clearHeaders();
        if (headers != null) {
            headers.forEach((name, values) -> this.headers.add(name, values));
        }
        return this.asDerivedType();
    }

    public T setSingleHeaders(Map<? extends CharSequence, ?> headers) {
        this.clearHeaders();
        if (headers != null) {
            headers.forEach((name, value) -> this.headers.add(name, value));
        }
        return this.asDerivedType();
    }

    @EnsuresNonNull(value={"cookies"})
    private void lazyInitCookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList(3);
        }
    }

    public T setCookies(Collection<Cookie> cookies) {
        this.cookies = new ArrayList<Cookie>(cookies);
        return this.asDerivedType();
    }

    public T addCookie(Cookie cookie) {
        this.lazyInitCookies();
        this.cookies.add(cookie);
        return this.asDerivedType();
    }

    public T addOrReplaceCookie(Cookie cookie) {
        String cookieKey = cookie.name();
        boolean replace = false;
        int index = 0;
        this.lazyInitCookies();
        for (Cookie c : this.cookies) {
            if (c.name().equals(cookieKey)) {
                replace = true;
                break;
            }
            ++index;
        }
        if (replace) {
            this.cookies.set(index, cookie);
        } else {
            this.cookies.add(cookie);
        }
        return this.asDerivedType();
    }

    public void resetCookies() {
        if (this.cookies != null) {
            this.cookies.clear();
        }
    }

    public void resetQuery() {
        this.queryParams = null;
        if (this.uri != null) {
            this.uri = this.uri.withNewQuery(null);
        }
    }

    public void resetFormParams() {
        this.formParams = null;
    }

    public void resetNonMultipartData() {
        this.byteData = null;
        this.compositeByteData = null;
        this.byteBufferData = null;
        this.stringData = null;
        this.streamData = null;
        this.bodyGenerator = null;
    }

    public void resetMultipartData() {
        this.bodyParts = null;
    }

    public T setBody(File file) {
        this.file = file;
        return this.asDerivedType();
    }

    private void resetBody() {
        this.resetFormParams();
        this.resetNonMultipartData();
        this.resetMultipartData();
    }

    public T setBody(byte[] data) {
        this.resetBody();
        this.byteData = data;
        return this.asDerivedType();
    }

    public T setBody(List<byte[]> data) {
        this.resetBody();
        this.compositeByteData = data;
        return this.asDerivedType();
    }

    public T setBody(String data) {
        this.resetBody();
        this.stringData = data;
        return this.asDerivedType();
    }

    public T setBody(ByteBuffer data) {
        this.resetBody();
        this.byteBufferData = data;
        return this.asDerivedType();
    }

    public T setBody(InputStream stream) {
        this.resetBody();
        this.streamData = stream;
        return this.asDerivedType();
    }

    public T setBody(BodyGenerator bodyGenerator) {
        this.bodyGenerator = bodyGenerator;
        return this.asDerivedType();
    }

    @EnsuresNonNull(value={"queryParams"})
    public T addQueryParam(String name, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<Param>(1);
        }
        this.queryParams.add(new Param(name, value));
        return this.asDerivedType();
    }

    @EnsuresNonNull(value={"queryParams"})
    public T addQueryParams(List<Param> params) {
        if (this.queryParams == null) {
            this.queryParams = params;
        } else {
            this.queryParams.addAll(params);
        }
        return this.asDerivedType();
    }

    public T setQueryParams(Map<String, List<String>> map) {
        return this.setQueryParams(Param.map2ParamList(map));
    }

    public T setQueryParams(@Nullable List<Param> params) {
        if (this.uri != null && MiscUtils.isNonEmpty(this.uri.getQuery())) {
            this.uri = this.uri.withNewQuery(null);
        }
        this.queryParams = params;
        return this.asDerivedType();
    }

    @EnsuresNonNull(value={"formParams"})
    public T addFormParam(String name, String value) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        if (this.formParams == null) {
            this.formParams = new ArrayList<Param>(1);
        }
        this.formParams.add(new Param(name, value));
        return this.asDerivedType();
    }

    public T setFormParams(Map<String, List<String>> map) {
        return this.setFormParams(Param.map2ParamList(map));
    }

    public T setFormParams(@Nullable List<Param> params) {
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.formParams = params;
        return this.asDerivedType();
    }

    @EnsuresNonNull(value={"bodyParts"})
    public T addBodyPart(Part bodyPart) {
        this.resetFormParams();
        this.resetNonMultipartData();
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<Part>();
        }
        this.bodyParts.add(bodyPart);
        return this.asDerivedType();
    }

    @EnsuresNonNull(value={"bodyParts"})
    public T setBodyParts(List<Part> bodyParts) {
        this.bodyParts = new ArrayList<Part>(bodyParts);
        return this.asDerivedType();
    }

    public T setProxyServer(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
        return this.asDerivedType();
    }

    public T setProxyServer(ProxyServer.Builder proxyServerBuilder) {
        this.proxyServer = proxyServerBuilder.build();
        return this.asDerivedType();
    }

    public T setRealm(Realm.Builder realm) {
        this.realm = realm.build();
        return this.asDerivedType();
    }

    public T setRealm(Realm realm) {
        this.realm = realm;
        return this.asDerivedType();
    }

    public T setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this.asDerivedType();
    }

    public T setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this.asDerivedType();
    }

    public T setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this.asDerivedType();
    }

    public T setRangeOffset(long rangeOffset) {
        this.rangeOffset = rangeOffset;
        return this.asDerivedType();
    }

    public T setMethod(String method) {
        this.method = method;
        return this.asDerivedType();
    }

    public T setCharset(Charset charset) {
        this.charset = charset;
        return this.asDerivedType();
    }

    public T setChannelPoolPartitioning(ChannelPoolPartitioning channelPoolPartitioning) {
        this.channelPoolPartitioning = channelPoolPartitioning;
        return this.asDerivedType();
    }

    public T setNameResolver(NameResolver<InetAddress> nameResolver) {
        this.nameResolver = nameResolver;
        return this.asDerivedType();
    }

    public T setSignatureCalculator(@Nullable SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this.asDerivedType();
    }

    private RequestBuilderBase<?> executeSignatureCalculator() {
        if (this.signatureCalculator == null) {
            return this;
        }
        RequestBuilder rb = new RequestBuilder(this.method);
        if (this.formParams != null) {
            rb.setFormParams(this.formParams);
        }
        if (this.headers != null) {
            rb.headers.add(this.headers);
        }
        if (this.cookies != null) {
            rb.setCookies(this.cookies);
        }
        if (this.bodyParts != null) {
            rb.setBodyParts(this.bodyParts);
        }
        rb.uriEncoder = this.uriEncoder;
        rb.queryParams = this.queryParams;
        rb.uri = this.uri;
        rb.address = this.address;
        rb.localAddress = this.localAddress;
        rb.byteData = this.byteData;
        rb.compositeByteData = this.compositeByteData;
        rb.stringData = this.stringData;
        rb.byteBufferData = this.byteBufferData;
        rb.streamData = this.streamData;
        rb.bodyGenerator = this.bodyGenerator;
        rb.virtualHost = this.virtualHost;
        rb.proxyServer = this.proxyServer;
        rb.realm = this.realm;
        rb.file = this.file;
        rb.followRedirect = this.followRedirect;
        rb.requestTimeout = this.requestTimeout;
        rb.rangeOffset = this.rangeOffset;
        rb.charset = this.charset;
        rb.channelPoolPartitioning = this.channelPoolPartitioning;
        rb.nameResolver = this.nameResolver;
        Request unsignedRequest = rb.build();
        this.signatureCalculator.calculateAndAddSignature(unsignedRequest, rb);
        return rb;
    }

    @EnsuresNonNull(value={"charset"})
    private void updateCharset() {
        String contentTypeHeader = this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Charset contentTypeCharset = HttpUtils.extractContentTypeCharsetAttribute(contentTypeHeader);
        this.charset = MiscUtils.withDefault(contentTypeCharset, MiscUtils.withDefault(this.charset, StandardCharsets.UTF_8));
        if (contentTypeHeader != null && contentTypeHeader.regionMatches(true, 0, "text/", 0, 5) && contentTypeCharset == null) {
            this.headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(contentTypeHeader + "; charset=" + this.charset.name()));
        }
    }

    private Uri computeUri() {
        Uri tempUri = this.uri;
        if (tempUri == null) {
            LOGGER.debug("setUrl hasn't been invoked. Using {}", (Object)DEFAULT_REQUEST_URL);
            tempUri = DEFAULT_REQUEST_URL;
        } else {
            Uri.validateSupportedScheme(tempUri);
        }
        return this.uriEncoder.encode(tempUri, this.queryParams);
    }

    public Request build() {
        this.updateCharset();
        RequestBuilderBase<?> rb = this.executeSignatureCalculator();
        Uri finalUri = rb.computeUri();
        ArrayList<Cookie> cookiesCopy = rb.cookies == null ? Collections.emptyList() : new ArrayList<Cookie>(rb.cookies);
        ArrayList<Param> formParamsCopy = rb.formParams == null ? Collections.emptyList() : new ArrayList<Param>(rb.formParams);
        ArrayList<Part> bodyPartsCopy = rb.bodyParts == null ? Collections.emptyList() : new ArrayList<Part>(rb.bodyParts);
        return new DefaultRequest(rb.method, finalUri, rb.address, rb.localAddress, rb.headers, cookiesCopy, rb.byteData, rb.compositeByteData, rb.stringData, rb.byteBufferData, rb.streamData, rb.bodyGenerator, formParamsCopy, bodyPartsCopy, rb.virtualHost, rb.proxyServer, rb.realm, rb.file, rb.followRedirect, rb.requestTimeout, rb.readTimeout, rb.rangeOffset, rb.charset, rb.channelPoolPartitioning, rb.nameResolver);
    }
}

