/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.api.JResponseAsResponse;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.atmosphere.annotation.Asynchronous;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Cluster;
import org.atmosphere.annotation.Publish;
import org.atmosphere.annotation.Resume;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Subscribe;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.jersey.SuspendResponse;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFilter
implements ResourceFilterFactory {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereFilter.class);
    private static final String INSTALLATION_ERROR = "The Atmosphere Framework is not installed properly and unexpected result may occurs.";
    public static final String SUSPENDED_RESOURCE = AtmosphereFilter.class.getName() + ".suspendedResource";
    public static final String RESUME_UUID = AtmosphereFilter.class.getName() + ".uuid";
    public static final String RESUME_CANDIDATES = AtmosphereFilter.class.getName() + ".resumeCandidates";
    public static final String INJECTED_BROADCASTER = AtmosphereFilter.class.getName() + "injectedBroadcaster";
    @Context
    protected HttpServletRequest servletReq;
    @Context
    private UriInfo uriInfo;
    private boolean useResumeAnnotation = false;
    private final ConcurrentHashMap<String, AtmosphereResource> resumeCandidates = new ConcurrentHashMap();

    public List<ResourceFilter> create(AbstractMethod am) {
        Filter f;
        LinkedList<ResourceFilter> list = new LinkedList<ResourceFilter>();
        for (Annotation annotation : am.getAnnotations()) {
            logger.trace("AtmosphereFilter processing annotation: {}", (Object)annotation);
        }
        if (am.getMethod() == null) {
            return null;
        }
        if (SuspendResponse.class.isAssignableFrom(am.getMethod().getReturnType())) {
            list.addLast(new Filter(Action.SUSPEND_RESPONSE));
            return list;
        }
        if (am.isAnnotationPresent(Broadcast.class)) {
            int delay = ((Broadcast)am.getAnnotation(Broadcast.class)).delay();
            Class[] broadcastFilter = ((Broadcast)am.getAnnotation(Broadcast.class)).value();
            f = ((Broadcast)am.getAnnotation(Broadcast.class)).resumeOnBroadcast() ? new Filter(Action.RESUME_ON_BROADCAST, delay, 0, Suspend.SCOPE.APPLICATION, true, broadcastFilter, null, ((Broadcast)am.getAnnotation(Broadcast.class)).writeEntity()) : new Filter(Action.BROADCAST, delay, 0, Suspend.SCOPE.APPLICATION, true, broadcastFilter, null, ((Broadcast)am.getAnnotation(Broadcast.class)).writeEntity());
            list.addLast(f);
            if (am.isAnnotationPresent(Cluster.class)) {
                for (Class c : broadcastFilter = ((Cluster)am.getAnnotation(Cluster.class)).value()) {
                    try {
                        ClusterBroadcastFilter cbf = (ClusterBroadcastFilter)c.newInstance();
                        InjectorProvider.getInjector().inject((Object)cbf);
                        cbf.setUri(((Cluster)am.getAnnotation(Cluster.class)).name());
                        f.addCluster(cbf);
                    }
                    catch (Throwable t) {
                        logger.warn("Invalid ClusterBroadcastFilter", t);
                    }
                }
            }
        }
        if (am.isAnnotationPresent(Asynchronous.class)) {
            int suspendTimeout = ((Asynchronous)am.getAnnotation(Asynchronous.class)).period();
            Class[] broadcastFilter = ((Asynchronous)am.getAnnotation(Asynchronous.class)).broadcastFilter();
            boolean wait = ((Asynchronous)am.getAnnotation(Asynchronous.class)).waitForResource();
            f = new Filter(Action.ASYNCHRONOUS, suspendTimeout, wait ? -1 : 0, null, false, broadcastFilter, ((Asynchronous)am.getAnnotation(Asynchronous.class)).header(), ((Asynchronous)am.getAnnotation(Asynchronous.class)).writeEntity());
            f.setListeners(((Asynchronous)am.getAnnotation(Asynchronous.class)).eventListeners());
            list.addFirst(f);
        }
        if (am.isAnnotationPresent(Suspend.class)) {
            long suspendTimeout = ((Suspend)am.getAnnotation(Suspend.class)).period();
            TimeUnit tu = ((Suspend)am.getAnnotation(Suspend.class)).timeUnit();
            suspendTimeout = this.translateTimeUnit(suspendTimeout, tu);
            Suspend.SCOPE scope = ((Suspend)am.getAnnotation(Suspend.class)).scope();
            boolean outputComments = ((Suspend)am.getAnnotation(Suspend.class)).outputComments();
            f = ((Suspend)am.getAnnotation(Suspend.class)).resumeOnBroadcast() ? new Filter(Action.SUSPEND_RESUME, suspendTimeout, 0, scope, outputComments, null, null, true, ((Suspend)am.getAnnotation(Suspend.class)).contentType()) : new Filter(Action.SUSPEND, suspendTimeout, 0, scope, outputComments, null, null, true, ((Suspend)am.getAnnotation(Suspend.class)).contentType());
            f.setListeners(((Suspend)am.getAnnotation(Suspend.class)).listeners());
            list.addFirst(f);
        }
        if (am.isAnnotationPresent(Subscribe.class)) {
            f = new Filter(Action.SUBSCRIBE, 30000L, -1, Suspend.SCOPE.APPLICATION, false, null, ((Subscribe)am.getAnnotation(Subscribe.class)).value(), ((Subscribe)am.getAnnotation(Subscribe.class)).writeEntity());
            f.setListeners(((Subscribe)am.getAnnotation(Subscribe.class)).listeners());
            list.addFirst(f);
        }
        if (am.isAnnotationPresent(Publish.class)) {
            f = new Filter(Action.PUBLISH, -1L, -1, Suspend.SCOPE.APPLICATION, false, null, ((Publish)am.getAnnotation(Publish.class)).value(), true);
            list.addFirst(f);
        }
        if (am.isAnnotationPresent(Resume.class)) {
            this.useResumeAnnotation = true;
            int suspendTimeout = ((Resume)am.getAnnotation(Resume.class)).value();
            list.addFirst(new Filter(Action.RESUME, suspendTimeout));
        }
        if (am.isAnnotationPresent(Schedule.class)) {
            int period = ((Schedule)am.getAnnotation(Schedule.class)).period();
            int waitFor = ((Schedule)am.getAnnotation(Schedule.class)).waitFor();
            if (((Schedule)am.getAnnotation(Schedule.class)).resumeOnBroadcast()) {
                list.addFirst(new Filter(Action.SCHEDULE_RESUME, period, waitFor));
            } else {
                list.addFirst(new Filter(Action.SCHEDULE, period, waitFor));
            }
        }
        if (list.size() == 0) {
            f = new Filter(Action.NONE);
            list.addFirst(f);
        }
        return list;
    }

    protected long translateTimeUnit(long period, TimeUnit tu) {
        if (period == -1L) {
            return period;
        }
        switch (tu) {
            case SECONDS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.SECONDS);
            }
            case MINUTES: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.MINUTES);
            }
            case HOURS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.HOURS);
            }
            case DAYS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.DAYS);
            }
            case MILLISECONDS: {
                return period;
            }
            case MICROSECONDS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.MICROSECONDS);
            }
            case NANOSECONDS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.NANOSECONDS);
            }
        }
        return period;
    }

    public class Filter
    implements ResourceFilter,
    ContainerResponseFilter {
        private final Action action;
        private final long timeout;
        private final int waitFor;
        private final Suspend.SCOPE scope;
        private final Class<BroadcastFilter>[] filters;
        private Class<? extends AtmosphereResourceEventListener>[] listeners = null;
        private final boolean outputComments;
        private final ArrayList<ClusterBroadcastFilter> clusters = new ArrayList();
        private final String topic;
        private final boolean writeEntity;
        private final String defaultContentType;

        protected Filter(Action action) {
            this(action, -1L);
        }

        protected Filter(Action action, long timeout) {
            this(action, timeout, 0);
        }

        protected Filter(Action action, long timeout, int waitFor) {
            this(action, timeout, waitFor, Suspend.SCOPE.APPLICATION);
        }

        protected Filter(Action action, long timeout, int waitFor, Suspend.SCOPE scope) {
            this(action, timeout, waitFor, scope, true);
        }

        public Filter(Action action, long timeout, int waitFor, Suspend.SCOPE scope, boolean outputComments) {
            this(action, timeout, waitFor, scope, outputComments, null, null, true);
        }

        protected Filter(Action action, long timeout, int waitFor, Suspend.SCOPE scope, boolean outputComments, Class<BroadcastFilter>[] filters, String topic, boolean writeEntity) {
            this(action, timeout, waitFor, scope, outputComments, filters, topic, writeEntity, null);
        }

        protected Filter(Action action, long timeout, int waitFor, Suspend.SCOPE scope, boolean outputComments, Class<BroadcastFilter>[] filters, String topic, boolean writeEntity, String contentType) {
            this.action = action;
            this.timeout = timeout;
            this.scope = scope;
            this.outputComments = outputComments;
            this.waitFor = waitFor;
            this.filters = filters;
            this.topic = topic;
            this.writeEntity = writeEntity;
            this.defaultContentType = contentType != null ? (contentType.equals("") ? null : contentType) : null;
        }

        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        boolean resumeOnBroadcast(boolean resumeOnBroadcast) {
            String transport = AtmosphereFilter.this.servletReq.getHeader("X-Atmosphere-Transport");
            if (transport != null && (transport.equals("jsonp") || transport.equals("long-polling"))) {
                return true;
            }
            return resumeOnBroadcast;
        }

        boolean outputJunk(AtmosphereResource r, boolean outputJunk) {
            if (outputJunk && !r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING) && !r.transport().equals((Object)AtmosphereResource.TRANSPORT.UNDEFINED)) {
                return false;
            }
            return outputJunk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            ContainerResponseWriter w;
            if (response.getMappedThrowable() != null) {
                logger.debug("Unexpected exception", response.getMappedThrowable());
                return response;
            }
            if (this.action == Action.NONE) {
                return response;
            }
            AtmosphereConfig config = (AtmosphereConfig)AtmosphereFilter.this.servletReq.getAttribute(FrameworkConfig.ATMOSPHERE_CONFIG);
            if (config == null) {
                logger.error(AtmosphereFilter.INSTALLATION_ERROR);
                throw new WebApplicationException((Throwable)new IllegalStateException(AtmosphereFilter.INSTALLATION_ERROR));
            }
            String p = config.getInitParameter("org.atmosphere.jersey.containerResponseWriterClass");
            if (p != null) {
                try {
                    w = (ContainerResponseWriter)Thread.currentThread().getContextClassLoader().loadClass(p).newInstance();
                    logger.trace("Installing ContainerResponseWriter {}", (Object)p);
                }
                catch (Throwable e) {
                    logger.error("Error loading ContainerResponseWriter {}", (Object)p, (Object)e);
                }
            }
            if ((w = (ContainerResponseWriter)AtmosphereFilter.this.servletReq.getAttribute("org.atmosphere.jersey.containerResponseWriterInstance")) != null) {
                response.setContainerResponseWriter(w);
            }
            AtmosphereResource r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            if (Boolean.parseBoolean(config.getInitParameter("org.atmosphere.jersey.supportLocationHeader"))) {
                AtmosphereFilter.this.useResumeAnnotation = true;
            }
            if (response.getStatus() == 204) {
                response.setStatus(200);
            }
            switch (this.action) {
                case ASYNCHRONOUS: {
                    String transport = this.getHeaderOrQueryValue("X-Atmosphere-Transport");
                    String broadcasterName = this.uuid(r);
                    if (!this.topic.equalsIgnoreCase("X-Atmosphere-tracking-id")) {
                        broadcasterName = this.getHeaderOrQueryValue(this.topic);
                    }
                    if (transport == null) {
                        transport = "long-polling";
                    }
                    if (broadcasterName == null) {
                        StringBuffer s = new StringBuffer();
                        Enumeration e = AtmosphereFilter.this.servletReq.getHeaderNames();
                        while (e.hasMoreElements()) {
                            String t = (String)e.nextElement();
                            s.append(t).append("=").append(AtmosphereFilter.this.servletReq.getHeader(t)).append("\n");
                        }
                        logger.error("\nQueryString:\n{}\n\nHeaders:\n{}", (Object)AtmosphereFilter.this.servletReq.getQueryString(), (Object)s.toString());
                        throw new WebApplicationException((Throwable)new IllegalStateException("Must specify transport using header value " + transport + " and uuid " + broadcasterName));
                    }
                    String subProtocol = (String)AtmosphereFilter.this.servletReq.getAttribute("websocket-subprotocol");
                    final boolean waitForResource = this.waitFor == -1;
                    final Broadcaster bcaster = BroadcasterFactory.getDefault().lookup((Object)broadcasterName, true);
                    if (!transport.startsWith("polling") && subProtocol == null) {
                        boolean outputJunk = transport.equalsIgnoreCase("streaming");
                        boolean resumeOnBroadcast = this.resumeOnBroadcast(false);
                        if (this.listeners != null) {
                            for (Class<? extends AtmosphereResourceEventListener> listener : this.listeners) {
                                try {
                                    AtmosphereResourceEventListener el = listener.newInstance();
                                    InjectorProvider.getInjector().inject((Object)el);
                                    r.addEventListener(el);
                                }
                                catch (Throwable t) {
                                    throw new WebApplicationException((Throwable)new IllegalStateException("Invalid AtmosphereResourceEventListener " + listener));
                                }
                            }
                        }
                        final Object entity = response.getEntity();
                        r.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onSuspend(AtmosphereResourceEvent event) {
                                try {
                                    if (entity != null) {
                                        if (waitForResource) {
                                            bcaster.awaitAndBroadcast(entity, 30L, TimeUnit.SECONDS);
                                        } else {
                                            bcaster.broadcast(entity);
                                        }
                                    }
                                }
                                finally {
                                    event.getResource().removeEventListener((AtmosphereResourceEventListener)this);
                                }
                            }
                        });
                        if (resumeOnBroadcast) {
                            AtmosphereFilter.this.servletReq.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)new Boolean(true));
                        }
                        r.setBroadcaster(bcaster);
                        this.executeSuspend(r, this.timeout, outputJunk, resumeOnBroadcast, null, request, response, this.writeEntity);
                        return response;
                    }
                    Object entity = response.getEntity();
                    if (waitForResource) {
                        bcaster.awaitAndBroadcast(entity, 30L, TimeUnit.SECONDS);
                    } else {
                        bcaster.broadcast(entity);
                    }
                    if (subProtocol == null && this.writeEntity) {
                        try {
                            if (Callable.class.isAssignableFrom(entity.getClass())) {
                                entity = ((Callable)Callable.class.cast(entity)).call();
                            }
                            ContainerResponse resumeOnBroadcast = response;
                            synchronized (resumeOnBroadcast) {
                                response.setEntity(entity);
                                response.write();
                                return response;
                            }
                        }
                        catch (Throwable t) {
                            logger.debug("Error running Callable", t);
                            response.setEntity(null);
                        }
                        return response;
                    }
                    response.setEntity(null);
                    return response;
                }
                case SUSPEND_RESPONSE: {
                    Broadcaster bc;
                    SuspendResponse s = (SuspendResponse)((Object)SuspendResponse.class.cast(((JResponseAsResponse)JResponseAsResponse.class.cast(response.getResponse())).getJResponse()));
                    boolean outputJunk = this.outputJunk(r, s.outputComments());
                    boolean resumeOnBroadcast = this.resumeOnBroadcast(s.resumeOnBroadcast());
                    for (AtmosphereResourceEventListener el : s.listeners()) {
                        r.addEventListener(el);
                    }
                    if (s.getEntity() == null && outputJunk) {
                        response.setEntity((Object)"");
                    }
                    if ((bc = s.broadcaster()) == null && s.scope() != Suspend.SCOPE.REQUEST) {
                        bc = (Broadcaster)AtmosphereFilter.this.servletReq.getAttribute(INJECTED_BROADCASTER);
                    }
                    this.suspend(resumeOnBroadcast, outputJunk, AtmosphereFilter.this.translateTimeUnit(s.period().value(), s.period().timeUnit()), request, response, bc, r, s.scope(), s.writeEntity());
                    return response;
                }
                case SUBSCRIBE: 
                case SUSPEND: 
                case SUSPEND_RESUME: {
                    boolean outputJunk = this.outputJunk(r, this.outputComments);
                    boolean resumeOnBroadcast = this.resumeOnBroadcast(this.action == Action.SUSPEND_RESUME);
                    if (this.listeners != null) {
                        for (Class<? extends AtmosphereResourceEventListener> listener : this.listeners) {
                            try {
                                AtmosphereResourceEventListener el = listener.newInstance();
                                InjectorProvider.getInjector().inject((Object)el);
                                r.addEventListener(el);
                            }
                            catch (Throwable t) {
                                throw new WebApplicationException((Throwable)new IllegalStateException("Invalid AtmosphereResourceEventListener " + listener, t));
                            }
                        }
                    }
                    Broadcaster broadcaster = (Broadcaster)AtmosphereFilter.this.servletReq.getAttribute(INJECTED_BROADCASTER);
                    if (this.action == Action.SUBSCRIBE) {
                        Class<?> c = null;
                        try {
                            c = Class.forName((String)AtmosphereFilter.this.servletReq.getAttribute(ApplicationConfig.BROADCASTER_CLASS));
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        broadcaster = BroadcasterFactory.getDefault().lookup(c, (Object)this.topic, true);
                    }
                    this.suspend(resumeOnBroadcast, outputJunk, this.timeout, request, response, broadcaster, r, this.scope, this.writeEntity);
                    return response;
                }
                case RESUME: {
                    boolean sessionSupported;
                    if (response.getEntity() != null) {
                        try {
                            ContainerResponse c = response;
                            synchronized (c) {
                                response.write();
                            }
                        }
                        catch (IOException ex) {
                            throw new WebApplicationException((Throwable)ex);
                        }
                    }
                    if (sessionSupported = ((Boolean)AtmosphereFilter.this.servletReq.getAttribute(FrameworkConfig.SUPPORT_SESSION)).booleanValue()) {
                        r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getSession().getAttribute(SUSPENDED_RESOURCE);
                    } else {
                        String path = response.getContainerRequest().getPath();
                        r = (AtmosphereResource)AtmosphereFilter.this.resumeCandidates.remove(path.substring(path.lastIndexOf("/") + 1));
                    }
                    if (r == null) throw new WebApplicationException((Throwable)new IllegalStateException("Unable to retrieve suspended Response. Either session-support is not enabled in atmosphere.xml or thepath used to resume is invalid."));
                    this.resume(r);
                    return response;
                }
                case BROADCAST: 
                case PUBLISH: 
                case RESUME_ON_BROADCAST: {
                    ContainerResponse c;
                    AtmosphereResource ar = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(SUSPENDED_RESOURCE);
                    if (ar != null) {
                        r = ar;
                    }
                    if (this.action == Action.PUBLISH) {
                        c = null;
                        try {
                            c = Class.forName((String)AtmosphereFilter.this.servletReq.getAttribute(ApplicationConfig.BROADCASTER_CLASS));
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException(e.getMessage());
                        }
                        r.setBroadcaster(BroadcasterFactory.getDefault().lookup((Class)c, (Object)this.topic, true));
                    }
                    this.broadcast(response, r, this.timeout);
                    if (this.writeEntity) return response;
                    c = response;
                    synchronized (c) {
                        response.setEntity(null);
                        return response;
                    }
                }
                case SCHEDULE: 
                case SCHEDULE_RESUME: {
                    Object o = response.getEntity();
                    Broadcaster b = r.getBroadcaster();
                    if (response.getEntity() instanceof Broadcastable) {
                        b = ((Broadcastable)response.getEntity()).getBroadcaster();
                        o = ((Broadcastable)response.getEntity()).getMessage();
                        response.setEntity(((Broadcastable)response.getEntity()).getResponseMessage());
                    }
                    if (response.getEntity() != null) {
                        try {
                            ContainerResponse containerResponse = response;
                            synchronized (containerResponse) {
                                response.write();
                            }
                        }
                        catch (IOException ex) {
                            throw new WebApplicationException((Throwable)ex);
                        }
                    }
                    if (this.action == Action.SCHEDULE_RESUME) {
                        this.configureResumeOnBroadcast(b);
                    }
                    b.scheduleFixedBroadcast(o, (long)this.waitFor, this.timeout, TimeUnit.SECONDS);
                }
            }
            return response;
        }

        String uuid(AtmosphereResource r) {
            String s = (String)r.getRequest().getAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID);
            if (s != null) {
                return s;
            }
            s = r.getRequest().getHeader("X-Atmosphere-tracking-id");
            if (s != null && s != "0") {
                return s;
            }
            return r.uuid();
        }

        String getHeaderOrQueryValue(String name) {
            String qs;
            String value = AtmosphereFilter.this.servletReq.getHeader(name);
            if (value == null && (value = AtmosphereFilter.this.servletReq.getParameter(name)) == null && (value = AtmosphereFilter.this.servletReq.getParameter(name.toLowerCase())) == null && (qs = AtmosphereFilter.this.servletReq.getQueryString()) != null && qs.indexOf(name) != -1) {
                String[] s;
                for (String a : s = qs.split("&")) {
                    String[] query;
                    if (!a.startsWith(name) && !a.startsWith(name.toLowerCase()) || (query = a.split("=")).length != 2) continue;
                    return query[1];
                }
            }
            return value;
        }

        Response.ResponseBuilder configureHeaders(Response.ResponseBuilder b) throws IOException {
            boolean webSocketSupported;
            boolean bl = webSocketSupported = AtmosphereFilter.this.servletReq.getAttribute(WebSocket.WEBSOCKET_SUSPEND) != null;
            if (AtmosphereFilter.this.servletReq.getHeaders("Connection") != null && AtmosphereFilter.this.servletReq.getHeaders("Connection").hasMoreElements()) {
                String[] e;
                for (String upgrade : e = ((String)AtmosphereFilter.this.servletReq.getHeaders("Connection").nextElement()).toString().split(",")) {
                    if (upgrade == null || !upgrade.equalsIgnoreCase("Upgrade") || webSocketSupported) continue;
                    b = b.header("X-Atmosphere-error", (Object)"Websocket protocol not supported");
                }
            }
            boolean injectCacheHeaders = (Boolean)AtmosphereFilter.this.servletReq.getAttribute(ApplicationConfig.NO_CACHE_HEADERS);
            boolean enableAccessControl = (Boolean)AtmosphereFilter.this.servletReq.getAttribute(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
            if (injectCacheHeaders) {
                b = b.header("Expires", (Object)"-1");
                b = b.header("Cache-Control", (Object)"no-store, no-cache, must-revalidate");
                b = b.header("Pragma", (Object)"no-cache");
            }
            if (enableAccessControl) {
                b = b.header("Access-Control-Allow-Origin", (Object)(AtmosphereFilter.this.servletReq.getHeader("Origin") == null ? "*" : AtmosphereFilter.this.servletReq.getHeader("Origin")));
                b = b.header("Access-Control-Allow-Credentials", (Object)"true");
            }
            return b;
        }

        void configureResumeOnBroadcast(Broadcaster b) {
            Iterator i = b.getAtmosphereResources().iterator();
            while (i.hasNext()) {
                AtmosphereRequest r = ((AtmosphereResource)i.next()).getRequest();
                r.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)true);
            }
        }

        void configureFilter(Broadcaster bc) {
            if (bc == null) {
                throw new WebApplicationException((Throwable)new IllegalStateException("Broadcaster cannot be null"));
            }
            BroadcasterConfig c = bc.getBroadcasterConfig();
            if (c.hasFilters()) {
                return;
            }
            for (ClusterBroadcastFilter cbf : this.clusters) {
                cbf.setBroadcaster(bc);
                c.addFilter((BroadcastFilter)cbf);
            }
            BroadcastFilter f = null;
            if (this.filters != null) {
                for (Class<BroadcastFilter> filter : this.filters) {
                    try {
                        f = filter.newInstance();
                        InjectorProvider.getInjector().inject((Object)f);
                    }
                    catch (Throwable t) {
                        logger.warn("Invalid @BroadcastFilter: " + filter, t);
                    }
                    c.addFilter(f);
                }
            }
        }

        private void setListeners(Class<? extends AtmosphereResourceEventListener>[] listeners) {
            this.listeners = listeners;
        }

        void broadcast(ContainerResponse r, AtmosphereResource ar, long delay) {
            Object o = r.getEntity();
            Broadcaster b = ar.getBroadcaster();
            Object msg = o;
            String returnMsg = null;
            if (o instanceof Broadcastable) {
                if (((Broadcastable)o).getBroadcaster() != null) {
                    b = ((Broadcastable)o).getBroadcaster();
                }
                msg = ((Broadcastable)o).getMessage();
                returnMsg = ((Broadcastable)o).getResponseMessage().toString();
            }
            if (this.action == Action.RESUME_ON_BROADCAST) {
                this.configureResumeOnBroadcast(b);
            }
            if (o != null) {
                this.addFilter(b);
                try {
                    r.setEntity(msg);
                    if (msg == null) {
                        return;
                    }
                    if (delay == -1L) {
                        Object t = b.broadcast(msg).get();
                        if (o instanceof Broadcastable) {
                            r.setEntity((Object)returnMsg);
                        }
                    } else if (delay == 0L) {
                        b.delayBroadcast(msg);
                    } else {
                        b.delayBroadcast(msg, delay, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException ex) {
                    logger.error("broadcast interrupted", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    logger.error("execution exception during broadcast", (Throwable)ex);
                }
            }
        }

        void addFilter(Broadcaster bc) {
            this.configureFilter(bc);
        }

        void resume(AtmosphereResource resource) {
            resource.resume();
        }

        void addCluster(ClusterBroadcastFilter f) {
            this.clusters.add(f);
        }

        void suspend(boolean resumeOnBroadcast, boolean comments, long timeout, ContainerRequest request, ContainerResponse response, Broadcaster bc, AtmosphereResource r, Suspend.SCOPE localScope, boolean flushEntity) {
            if (response.getStatus() == 204) {
                response.setStatus(200);
            }
            BroadcasterFactory broadcasterFactory = (BroadcasterFactory)AtmosphereFilter.this.servletReq.getAttribute(ApplicationConfig.BROADCASTER_FACTORY);
            boolean sessionSupported = (Boolean)AtmosphereFilter.this.servletReq.getAttribute(FrameworkConfig.SUPPORT_SESSION);
            URI location = null;
            if (AtmosphereFilter.this.useResumeAnnotation && !sessionSupported && !resumeOnBroadcast && response.getHttpHeaders().getFirst((Object)"Location") == null) {
                String uuid = UUID.randomUUID().toString();
                location = AtmosphereFilter.this.uriInfo.getAbsolutePathBuilder().path(uuid).build(new Object[]{""});
                AtmosphereFilter.this.resumeCandidates.put(uuid, r);
                AtmosphereFilter.this.servletReq.setAttribute(RESUME_UUID, (Object)uuid);
                AtmosphereFilter.this.servletReq.setAttribute(RESUME_CANDIDATES, (Object)AtmosphereFilter.this.resumeCandidates);
            }
            if (bc == null && localScope != Suspend.SCOPE.REQUEST) {
                bc = r.getBroadcaster();
            }
            if (sessionSupported && localScope != Suspend.SCOPE.REQUEST && AtmosphereFilter.this.servletReq.getSession().getAttribute(SUSPENDED_RESOURCE) != null) {
                AtmosphereResource cached = (AtmosphereResource)AtmosphereFilter.this.servletReq.getSession().getAttribute(SUSPENDED_RESOURCE);
                bc = cached.getBroadcaster();
                try {
                    bc.removeAtmosphereResource(cached);
                }
                catch (IllegalStateException ex) {
                    logger.trace(ex.getMessage(), (Throwable)ex);
                }
            }
            if (response.getEntity() instanceof Broadcastable) {
                Broadcastable b = (Broadcastable)response.getEntity();
                bc = b.getBroadcaster();
                response.setEntity(b.getResponseMessage());
            }
            if (localScope == Suspend.SCOPE.REQUEST && bc == null) {
                if (bc == null) {
                    try {
                        String id = AtmosphereFilter.this.servletReq.getHeader("X-Atmosphere-tracking-id");
                        if (id == null) {
                            id = UUID.randomUUID().toString();
                        }
                        bc = broadcasterFactory.get((Object)id);
                        bc.setScope(Broadcaster.SCOPE.REQUEST);
                    }
                    catch (Exception ex) {
                        logger.error("failed to instantiate broadcaster with factory: " + broadcasterFactory, (Throwable)ex);
                    }
                } else {
                    bc.setScope(Broadcaster.SCOPE.REQUEST);
                }
            }
            r.setBroadcaster(bc);
            if (resumeOnBroadcast) {
                AtmosphereFilter.this.servletReq.setAttribute("org.atmosphere.resumeOnBroadcast", (Object)new Boolean(true));
            }
            this.executeSuspend(r, timeout, comments, resumeOnBroadcast, location, request, response, flushEntity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeSuspend(AtmosphereResource r, long timeout, boolean comments, boolean resumeOnBroadcast, URI location, ContainerRequest request, ContainerResponse response, boolean flushEntity) {
            AtmosphereFilter.this.servletReq.setAttribute("org.atmosphere.jersey.containerResponse", (Object)response);
            boolean sessionSupported = (Boolean)AtmosphereFilter.this.servletReq.getAttribute(FrameworkConfig.SUPPORT_SESSION);
            this.configureFilter(r.getBroadcaster());
            if (sessionSupported) {
                AtmosphereFilter.this.servletReq.getSession().setAttribute(SUSPENDED_RESOURCE, (Object)r);
                AtmosphereFilter.this.servletReq.getSession().setAttribute("org.atmosphere.jersey.containerResponse", (Object)response);
            }
            AtmosphereFilter.this.servletReq.setAttribute(SUSPENDED_RESOURCE, (Object)r);
            try {
                String ct;
                MediaType contentType = response.getMediaType();
                if (contentType == null && response.getEntity() != null) {
                    LinkedList<MediaType> l = new LinkedList<MediaType>();
                    l.add(request.getAcceptableMediaType(new LinkedList()));
                    contentType = response.getMessageBodyWorkers().getMessageBodyWriterMediaType(response.getEntity().getClass(), response.getEntityType(), response.getAnnotations(), l);
                    if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                        contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                    }
                }
                Object entity = response.getEntity();
                Response.ResponseBuilder b = Response.ok();
                b = this.configureHeaders(b);
                AtmosphereConfig config = (AtmosphereConfig)AtmosphereFilter.this.servletReq.getAttribute(FrameworkConfig.ATMOSPHERE_CONFIG);
                String defaultCT = config.getInitParameter(ApplicationConfig.DEFAULT_CONTENT_TYPE);
                if (defaultCT == null) {
                    defaultCT = "text/plain; charset=ISO-8859-1";
                }
                String string = ct = contentType == null ? defaultCT : contentType.toString();
                if (this.defaultContentType != null) {
                    ct = this.defaultContentType;
                }
                if (entity != null) {
                    b = b.header("Content-Type", (Object)ct);
                }
                AtmosphereFilter.this.servletReq.setAttribute(FrameworkConfig.EXPECTED_CONTENT_TYPE, (Object)ct);
                boolean eclipse362468 = false;
                String serverInfo = r.getAtmosphereConfig().getServletContext().getServerInfo();
                if (serverInfo.indexOf("jetty") != -1) {
                    try {
                        String[] jettyVersion = serverInfo.substring(6).split("\\.");
                        eclipse362468 = Integer.valueOf(jettyVersion[0]) == 8 && Integer.valueOf(jettyVersion[1]) == 0 && Integer.valueOf(jettyVersion[2]) > 1 || Integer.valueOf(jettyVersion[0]) == 7 && Integer.valueOf(jettyVersion[1]) == 5 && Integer.valueOf(jettyVersion[2]) == 4;
                    }
                    catch (Throwable t) {
                        logger.warn("Unable to parse server name {}", (Object)serverInfo);
                    }
                    if (comments && eclipse362468) {
                        logger.debug("Padding response is disabled to workaround https://bugs.eclipse.org/bugs/show_bug.cgi?id=362468");
                    }
                }
                if (!eclipse362468 && comments && !resumeOnBroadcast) {
                    String padding = (String)AtmosphereFilter.this.servletReq.getAttribute(ApplicationConfig.STREAMING_PADDING_MODE);
                    String paddingData = AtmosphereResourceImpl.createStreamingPadding((String)padding);
                    if (location != null) {
                        b = b.header("Location", (Object)location);
                        location = null;
                    }
                    ContainerResponse containerResponse = response;
                    synchronized (containerResponse) {
                        response.setResponse(b.entity((Object)paddingData).build());
                        response.write();
                    }
                }
                if (entity != null && flushEntity) {
                    try {
                        if (Callable.class.isAssignableFrom(entity.getClass())) {
                            entity = ((Callable)Callable.class.cast(entity)).call();
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Error executing callable {}", entity);
                        entity = null;
                    }
                    if (location != null) {
                        b = b.header("Location", (Object)location);
                    }
                    ContainerResponse containerResponse = response;
                    synchronized (containerResponse) {
                        response.setResponse(b.entity(entity).build());
                        response.write();
                    }
                }
                response.setEntity(null);
                r.suspend(timeout, false);
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex);
            }
        }
    }

    protected static enum Action {
        SUSPEND,
        RESUME,
        BROADCAST,
        SUSPEND_RESUME,
        SCHEDULE_RESUME,
        RESUME_ON_BROADCAST,
        NONE,
        SCHEDULE,
        SUSPEND_RESPONSE,
        SUBSCRIBE,
        PUBLISH,
        ASYNCHRONOUS;

    }
}

