/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.AbstractRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.commandhandling.distributed.UnresolvedRoutingKeyPolicy;
import org.axonframework.common.BuilderUtils;

public class MetaDataRoutingStrategy
extends AbstractRoutingStrategy {
    private final String metaDataKey;

    public static Builder builder() {
        return new Builder();
    }

    protected MetaDataRoutingStrategy(Builder builder) {
        super(builder.fallbackRoutingStrategy);
        builder.validate();
        this.metaDataKey = builder.metaDataKey;
    }

    @Deprecated
    public MetaDataRoutingStrategy(String metaDataKey) {
        this(metaDataKey, UnresolvedRoutingKeyPolicy.ERROR);
    }

    @Deprecated
    public MetaDataRoutingStrategy(String metaDataKey, UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy) {
        super(unresolvedRoutingKeyPolicy);
        this.metaDataKey = metaDataKey;
    }

    @Override
    protected String doResolveRoutingKey(CommandMessage<?> command) {
        Object value = command.getMetaData().get(this.metaDataKey);
        return value == null ? null : value.toString();
    }

    public static class Builder {
        private String metaDataKey;
        private RoutingStrategy fallbackRoutingStrategy = UnresolvedRoutingKeyPolicy.RANDOM_KEY;

        public Builder fallbackRoutingStrategy(RoutingStrategy fallbackRoutingStrategy) {
            BuilderUtils.assertNonNull(fallbackRoutingStrategy, "Fallback RoutingStrategy may not be null");
            this.fallbackRoutingStrategy = fallbackRoutingStrategy;
            return this;
        }

        public Builder metaDataKey(String metaDataKey) {
            BuilderUtils.assertNonEmpty(metaDataKey, "A metaDataKey may not be null or empty");
            this.metaDataKey = metaDataKey;
            return this;
        }

        public MetaDataRoutingStrategy build() {
            return new MetaDataRoutingStrategy(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty(this.metaDataKey, "The metaDataKey is a hard requirement and should be provided");
        }
    }
}

