/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.messaging.Message;
import org.axonframework.modelling.command.AggregateMember;
import org.axonframework.modelling.command.ForwardingMode;
import org.axonframework.modelling.command.inspection.EntityModel;

public class ForwardMatchingInstances<T extends Message<?>>
implements ForwardingMode<T> {
    private static final String EMPTY_STRING = "";
    private String routingKey;
    private EntityModel childEntity;

    @Override
    public void initialize(@Nonnull Member member, @Nonnull EntityModel childEntity) {
        this.childEntity = childEntity;
        this.routingKey = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)((AnnotatedElement)((Object)member)), AggregateMember.class).map(map -> (String)map.get("routingKey")).filter(key -> !Objects.equals(key, EMPTY_STRING)).orElse(childEntity.routingKey());
    }

    @Override
    public <E> Stream<E> filterCandidates(@Nonnull T message, @Nonnull Stream<E> candidates) {
        Property routingProperty = PropertyAccessStrategy.getProperty((Class)message.getPayloadType(), (String)this.routingKey);
        if (routingProperty == null) {
            return Stream.empty();
        }
        Object routingValue = routingProperty.getValue(message.getPayload());
        return candidates.filter(candidate -> this.matchesInstance(candidate, routingValue));
    }

    private <E> boolean matchesInstance(E candidate, Object routingValue) {
        Object identifier = this.childEntity.getIdentifier(candidate);
        return Objects.equals(routingValue, identifier);
    }
}

