/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.config;

import java.util.List;
import java.util.Map;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;

public class GetConfig {
    private static final ConfigRegistry configRegistry = ConfigRegistry.getInstance();
    private static final String LOOKUP_ERROR_REASON = "{ballerina/config}LookupError";
    private static final BMapType mapType = new BMapType(BTypes.typeAnydata);
    private static final BArrayType arrayType = new BArrayType(BTypes.typeAnydata);

    public static Object get(String configKey, String type) {
        try {
            switch (type) {
                case "STRING": {
                    return configRegistry.getAsString(configKey);
                }
                case "INT": {
                    return configRegistry.getAsInt(configKey);
                }
                case "FLOAT": {
                    return configRegistry.getAsFloat(configKey);
                }
                case "BOOLEAN": {
                    return configRegistry.getAsBoolean(configKey);
                }
                case "MAP": {
                    return GetConfig.buildMapValue(configRegistry.getAsMap(configKey));
                }
                case "ARRAY": {
                    return GetConfig.buildArrayValue(configRegistry.getAsArray(configKey));
                }
            }
            throw new IllegalStateException("invalid value type: " + type);
        }
        catch (IllegalArgumentException e) {
            throw BallerinaErrors.createError((String)LOOKUP_ERROR_REASON, (String)e.getMessage());
        }
    }

    private static MapValue buildMapValue(Map<String, Object> section) {
        MapValueImpl map = new MapValueImpl((BType)mapType);
        for (Map.Entry<String, Object> entry : section.entrySet()) {
            map.put((Object)entry.getKey(), GetConfig.getConvertedValue(entry.getValue()));
        }
        return map;
    }

    private static BArray buildArrayValue(List value) {
        Object[] convertedValues = new Object[value.size()];
        for (Object entry : value) {
            convertedValues[value.indexOf(entry)] = GetConfig.getConvertedValue(entry);
        }
        return BValueCreator.createArrayValue((Object[])convertedValues, (BArrayType)arrayType);
    }

    private static Object getConvertedValue(Object obj) {
        if (obj instanceof String || obj instanceof Long || obj instanceof Double || obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof Map) {
            return GetConfig.buildMapValue((Map)obj);
        }
        if (obj instanceof List) {
            return GetConfig.buildArrayValue((List)obj);
        }
        return String.valueOf(obj);
    }
}

