/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config;

import com.moandjiezana.toml.Toml;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bcl.parser.BConfig;

public class ConfigProcessor {
    private static final String ENV_VAR_FORMAT = "[a-zA-Z_]+[a-zA-Z0-9_]*";
    private static final String ENCRYPTED_FIELD_REGEX = "@encrypted:\\{(.*)\\}";

    public static BConfig processConfiguration(Map<String, String> runtimeParams, String userProvidedConfigFile, Path ballerinaConfDefaultPath) throws IOException {
        String configFilePath = ConfigProcessor.getConfigFile(userProvidedConfigFile, ballerinaConfDefaultPath);
        BConfig configEntries = new BConfig();
        if (configFilePath != null) {
            configEntries = ConfigProcessor.parseConfigFile(configFilePath);
            ConfigProcessor.lookUpVariables(configEntries.getConfigurations());
        }
        if (runtimeParams != null && !runtimeParams.isEmpty()) {
            BConfig parsedRuntimeParams = ConfigProcessor.parseRuntimeParams(runtimeParams);
            configEntries.addConfigurations(parsedRuntimeParams.getConfigurations());
            configEntries.setHasEncryptedValues(configEntries.hasEncryptedValues() | parsedRuntimeParams.hasEncryptedValues());
        }
        return configEntries;
    }

    private static void flatTomlMap(String currentPath, Object obj, Map<String, Object> map) {
        if (obj instanceof String) {
            String strObj = (String)obj;
            map.put(currentPath, strObj);
        } else if (obj instanceof Long) {
            Long longObj = (Long)obj;
            map.put(currentPath, longObj);
        } else if (obj instanceof Double) {
            Double doubleObj = (Double)obj;
            map.put(currentPath, doubleObj);
        } else if (obj instanceof List) {
            List listObj = (List)obj;
            map.put(currentPath, listObj);
        } else if (obj instanceof Boolean) {
            Boolean booleanObj = (Boolean)obj;
            map.put(currentPath, booleanObj);
        } else if (obj instanceof Map) {
            Map m = (Map)obj;
            String pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            for (Map.Entry entry : m.entrySet()) {
                ConfigProcessor.flatTomlMap(pathPrefix + (String)entry.getKey(), entry.getValue(), map);
            }
        }
    }

    private static void lookUpVariables(Map<String, Object> configFileEntries) {
        StringBuilder errMsgBuilder = new StringBuilder();
        configFileEntries.forEach((key, val) -> {
            if (val instanceof Map) {
                ConfigProcessor.lookUpVariables((Map)val);
            } else {
                String envVarVal = ConfigProcessor.getEnvVarValue(key);
                if (envVarVal != null) {
                    if (val instanceof String) {
                        configFileEntries.put((String)key, envVarVal);
                    } else if (val instanceof Long) {
                        try {
                            configFileEntries.put((String)key, Long.parseLong(envVarVal));
                        }
                        catch (NumberFormatException e) {
                            ConfigProcessor.addErrorMsg(errMsgBuilder, "received invalid int value from environment for", key, envVarVal);
                        }
                    } else if (val instanceof Double) {
                        try {
                            configFileEntries.put((String)key, Double.parseDouble(envVarVal));
                        }
                        catch (NumberFormatException e) {
                            ConfigProcessor.addErrorMsg(errMsgBuilder, "received invalid float value from environment for", key, envVarVal);
                        }
                    } else if (val instanceof Boolean) {
                        configFileEntries.put((String)key, Boolean.parseBoolean(envVarVal));
                    }
                }
            }
        });
        if (errMsgBuilder.length() > 0) {
            errMsgBuilder.deleteCharAt(errMsgBuilder.length() - 1);
            throw new IllegalArgumentException(errMsgBuilder.toString());
        }
    }

    private static String getEnvVarValue(String key) {
        String envVarName = ConfigProcessor.convertToEnvVarFormat(key);
        if (envVarName.matches(ENV_VAR_FORMAT)) {
            return System.getenv(envVarName);
        }
        return null;
    }

    private static String convertToEnvVarFormat(String var) {
        return var.replace('.', '_');
    }

    private static String getConfigFile(String fileLocation, Path defaultLocation) {
        Path userProvidedPath;
        Path path = userProvidedPath = fileLocation != null ? Paths.get(fileLocation, new String[0]) : null;
        if (userProvidedPath != null) {
            if (!Files.exists(userProvidedPath, new LinkOption[0])) {
                throw new RuntimeException("configuration file not found: " + fileLocation);
            }
            return userProvidedPath.toString();
        }
        if (defaultLocation == null || !Files.exists(defaultLocation, new LinkOption[0])) {
            return null;
        }
        return defaultLocation.toString();
    }

    private static BConfig parseConfigFile(String path) throws IOException {
        FileInputStream inputstream = new FileInputStream(path);
        Toml configToml = new Toml().read((InputStream)inputstream);
        BConfig configEntries = new BConfig();
        Map configTomlMap = configToml.toMap();
        HashMap<String, Object> configTomlMapFlat = new HashMap<String, Object>();
        ConfigProcessor.flatTomlMap("", configTomlMap, configTomlMapFlat);
        configEntries.addConfigurations(configTomlMapFlat);
        configEntries.setHasEncryptedValues(ConfigProcessor.containsEncryptedValues(configTomlMapFlat));
        return configEntries;
    }

    private static Boolean containsEncryptedValues(Map<String, Object> configTomlMap) {
        for (Object value : configTomlMap.values()) {
            if (!(value instanceof String) || !value.toString().matches(ENCRYPTED_FIELD_REGEX)) continue;
            return true;
        }
        return false;
    }

    private static BConfig parseRuntimeParams(Map<String, String> runtimeParams) {
        HashMap<String, Object> runtimeParamsMap = new HashMap<String, Object>();
        BConfig runtimeConfigEntries = new BConfig();
        for (Map.Entry<String, String> entry : runtimeParams.entrySet()) {
            runtimeParamsMap.put(entry.getKey(), entry.getValue());
        }
        runtimeConfigEntries.addConfigurations(runtimeParamsMap);
        runtimeConfigEntries.setHasEncryptedValues(ConfigProcessor.containsEncryptedValues(runtimeParamsMap));
        return runtimeConfigEntries;
    }

    private static void addErrorMsg(StringBuilder errMsgBuilder, String msg, String key, String val) {
        errMsgBuilder.append("error: ");
        errMsgBuilder.append(msg);
        errMsgBuilder.append(" '");
        errMsgBuilder.append(key);
        errMsgBuilder.append("': ");
        errMsgBuilder.append(val);
        errMsgBuilder.append('\n');
    }
}

