/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.util.observability.ObserveUtils;
import org.ballerinalang.util.program.BLangVMUtils;

public class BLangCallableUnitCallback
implements CallableUnitCallback {
    private Strand strand;
    private Context nativeCallCtx;
    private int retReg;
    private BType retType;

    public BLangCallableUnitCallback(Context nativeCallCtx, Strand strand, int retReg, BType retType) {
        this.strand = strand;
        this.nativeCallCtx = nativeCallCtx;
        this.retReg = retReg;
        this.retType = retType;
    }

    @Override
    public void notifySuccess() {
        if (this.strand.fp > 0) {
            ObserveUtils.stopCallableObservation(this.strand);
            if (BVM.checkIsType(this.nativeCallCtx.getReturnValue(), BTypes.typeError)) {
                this.strand.currentFrame.handleChannelError((BRefType)this.nativeCallCtx.getReturnValue(), this.strand.peekFrame((int)1).wdChannels);
            }
            this.strand.popFrame();
            StackFrame sf = this.strand.currentFrame;
            BLangVMUtils.populateWorkerDataWithValues(sf, this.retReg, this.nativeCallCtx.getReturnValue(), this.retType);
            BVMScheduler.schedule(this.strand);
            return;
        }
        if (BVM.checkIsType(this.nativeCallCtx.getReturnValue(), BTypes.typeError)) {
            this.strand.currentFrame.handleChannelError((BRefType)this.nativeCallCtx.getReturnValue(), this.strand.respCallback.parentChannels);
        }
        this.strand.respCallback.signal();
    }

    @Override
    public void notifyFailure(BError error) {
        if (this.strand.fp > 0) {
            ObserveUtils.stopCallableObservation(this.strand);
            this.strand.currentFrame.handleChannelPanic(error, this.strand.peekFrame((int)1).wdChannels);
            this.strand.popFrame();
            this.strand.setError(error);
            BVM.handleError(this.strand);
            BVMScheduler.schedule(this.strand);
            return;
        }
        this.strand.currentFrame.handleChannelPanic(error, this.strand.respCallback.parentChannels);
        this.strand.respCallback.setError(error);
        this.strand.respCallback.signal();
    }
}

