/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BObjectType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.ObjectTypeInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BLangVMStructs {
    public static BMap<String, BValue> createBStruct(StructureTypeInfo structInfo, Object ... values) {
        BStructureType structType = structInfo.getType();
        BMap<String, BValue> bStruct = new BMap<String, BValue>(structType);
        Map<String, BField> structFields = structType.getFields();
        int valCount = 0;
        for (BField field : structFields.values()) {
            Object value = values.length >= valCount + 1 ? BLangVMStructs.getBValue(field.fieldType, values[valCount]) : field.fieldType.getEmptyValue();
            bStruct.put(field.fieldName, (BValue)value);
            ++valCount;
        }
        return bStruct;
    }

    public static BMap<String, BValue> createObject(ObjectTypeInfo objectInfo, BValue ... values) {
        BObjectType structType = objectInfo.getType();
        BMap<String, BValue> bStruct = new BMap<String, BValue>(structType);
        BValue[] vals = new BValue[values.length + 1];
        vals[0] = bStruct;
        System.arraycopy(values, 0, vals, 1, values.length);
        BVMExecutor.executeFunction(objectInfo.initializer.getPackageInfo().getProgramFile(), objectInfo.initializer, vals);
        return bStruct;
    }

    private static BValue getBValue(BType type, Object value) {
        switch (type.getTag()) {
            case 1: {
                if (value instanceof Integer) {
                    return new BInteger(((Integer)value).longValue());
                }
                if (value instanceof Long) {
                    return new BInteger((Long)value);
                }
                if (!(value instanceof BInteger)) break;
                return (BInteger)value;
            }
            case 2: {
                if (value instanceof Byte || value instanceof Integer || value instanceof Long) {
                    long longValue = ((Number)value).longValue();
                    if (!BVM.isByteLiteral(longValue)) {
                        throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'int' value '" + value + "' cannot be converted to 'byte'");
                    }
                    return new BByte(longValue);
                }
                if (!(value instanceof BByte)) break;
                return (BByte)value;
            }
            case 3: {
                if (value == null) break;
                if (value instanceof Float) {
                    return new BFloat(((Float)value).floatValue());
                }
                if (value instanceof Double) {
                    return new BFloat((Double)value);
                }
                if (!(value instanceof BFloat)) break;
                return (BFloat)value;
            }
            case 4: {
                if (value == null) break;
                if (value instanceof String) {
                    return new BDecimal(new BigDecimal((String)value, MathContext.DECIMAL128));
                }
                if (value instanceof BigDecimal) {
                    return new BDecimal((BigDecimal)value);
                }
                if (!(value instanceof BDecimal)) break;
                return (BDecimal)value;
            }
            case 5: {
                if (value == null) break;
                if (value instanceof String) {
                    return new BString((String)value);
                }
                if (!(value instanceof BString)) break;
                return (BString)value;
            }
            case 6: {
                if (value == null) break;
                if (value instanceof Boolean) {
                    return new BBoolean((Boolean)value);
                }
                if (!(value instanceof BBoolean)) break;
                return (BBoolean)value;
            }
            default: {
                if (value == null || !(value instanceof BRefType)) break;
                return (BRefType)value;
            }
        }
        return null;
    }
}

