/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.bre.BLangCallableUnitCallback;
import org.ballerinalang.bre.NativeCallContext;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.SafeStrandCallback;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.bvm.VarLock;
import org.ballerinalang.bre.bvm.WaitCallbackHandler;
import org.ballerinalang.bre.bvm.WorkerDataChannel;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.channels.ChannelManager;
import org.ballerinalang.channels.ChannelRegistry;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BAttachedFunction;
import org.ballerinalang.model.types.BErrorType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BFiniteType;
import org.ballerinalang.model.types.BFunctionType;
import org.ballerinalang.model.types.BFutureType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BObjectType;
import org.ballerinalang.model.types.BRecordType;
import org.ballerinalang.model.types.BServiceType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.util.DecimalValueKind;
import org.ballerinalang.model.util.Flags;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.util.ListUtils;
import org.ballerinalang.model.util.StringUtils;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BCallableFuture;
import org.ballerinalang.model.values.BClosure;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BFuture;
import org.ballerinalang.model.values.BIntRange;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStream;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLQName;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.util.BLangConstants;
import org.ballerinalang.util.FunctionFlags;
import org.ballerinalang.util.Transactions;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ErrorTableEntry;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.ObjectTypeInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructFieldInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.codegen.TypeDefInfo;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.attributes.DefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.BlobCPEntry;
import org.ballerinalang.util.codegen.cpentries.FloatCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionCallCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.IntegerCPEntry;
import org.ballerinalang.util.codegen.cpentries.MapCPEntry;
import org.ballerinalang.util.codegen.cpentries.StringCPEntry;
import org.ballerinalang.util.codegen.cpentries.StructureRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.TypeRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.UTF8CPEntry;
import org.ballerinalang.util.debugger.DebugContext;
import org.ballerinalang.util.debugger.Debugger;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BLangFreezeException;
import org.ballerinalang.util.exceptions.BLangMapStoreException;
import org.ballerinalang.util.exceptions.BLangNullReferenceException;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;
import org.ballerinalang.util.observability.ObserveUtils;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.TransactionLocalContext;
import org.ballerinalang.util.transactions.TransactionResourceManager;
import org.ballerinalang.util.transactions.TransactionUtils;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public class BVM {
    static void execute(Strand strand) {
        boolean debugEnabled = strand.programFile.getDebugger().isDebugEnabled();
        StackFrame sf = strand.currentFrame;
        while (sf.ip >= 0) {
            if (strand.aborted) {
                BVM.handleFutureTermination(strand);
                return;
            }
            if (debugEnabled && BVM.debug(strand)) {
                return;
            }
            Instruction instruction = sf.code[sf.ip];
            int opcode = instruction.getOpcode();
            int[] operands = instruction.getOperands();
            ++sf.ip;
            switch (opcode) {
                case 1: {
                    int cpIndex = operands[0];
                    int i = operands[1];
                    sf.longRegs[i] = ((IntegerCPEntry)sf.constPool[cpIndex]).getValue();
                    break;
                }
                case 2: {
                    int cpIndex = operands[0];
                    int i = operands[1];
                    sf.doubleRegs[i] = ((FloatCPEntry)sf.constPool[cpIndex]).getValue();
                    break;
                }
                case 20: {
                    int cpIndex = operands[0];
                    int i = operands[1];
                    String decimalVal = ((UTF8CPEntry)sf.constPool[cpIndex]).getValue();
                    sf.refRegs[i] = new BDecimal(decimalVal);
                    break;
                }
                case 3: {
                    int cpIndex = operands[0];
                    int i = operands[1];
                    sf.stringRegs[i] = ((StringCPEntry)sf.constPool[cpIndex]).getValue();
                    break;
                }
                case 4: {
                    int i = operands[0];
                    sf.longRegs[i] = 0L;
                    break;
                }
                case 5: {
                    int i = operands[0];
                    sf.longRegs[i] = 1L;
                    break;
                }
                case 6: {
                    int i = operands[0];
                    sf.longRegs[i] = 2L;
                    break;
                }
                case 7: {
                    int i = operands[0];
                    sf.longRegs[i] = 3L;
                    break;
                }
                case 8: {
                    int i = operands[0];
                    sf.longRegs[i] = 4L;
                    break;
                }
                case 9: {
                    int i = operands[0];
                    sf.longRegs[i] = 5L;
                    break;
                }
                case 10: {
                    int i = operands[0];
                    sf.doubleRegs[i] = 0.0;
                    break;
                }
                case 11: {
                    int i = operands[0];
                    sf.doubleRegs[i] = 1.0;
                    break;
                }
                case 12: {
                    int i = operands[0];
                    sf.doubleRegs[i] = 2.0;
                    break;
                }
                case 13: {
                    int i = operands[0];
                    sf.doubleRegs[i] = 3.0;
                    break;
                }
                case 14: {
                    int i = operands[0];
                    sf.doubleRegs[i] = 4.0;
                    break;
                }
                case 15: {
                    int i = operands[0];
                    sf.doubleRegs[i] = 5.0;
                    break;
                }
                case 16: {
                    int i = operands[0];
                    sf.intRegs[i] = 0;
                    break;
                }
                case 17: {
                    int i = operands[0];
                    sf.intRegs[i] = 1;
                    break;
                }
                case 18: {
                    int i = operands[0];
                    sf.refRegs[i] = null;
                    break;
                }
                case 211: {
                    int cpIndex = operands[0];
                    int i = operands[1];
                    sf.refRegs[i] = new BValueArray(((BlobCPEntry)sf.constPool[cpIndex]).getValue());
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 41: 
                case 42: {
                    BVM.execLoadOpcodes(strand, sf, opcode, operands);
                    break;
                }
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 61: 
                case 62: {
                    BVM.execStoreOpcodes(strand, sf, opcode, operands);
                    break;
                }
                case 51: 
                case 52: 
                case 58: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 210: 
                case 212: 
                case 235: 
                case 237: 
                case 238: {
                    BVM.execBinaryOpCodes(strand, sf, opcode, operands);
                    break;
                }
                case 236: {
                    int cpIndex = operands[0];
                    int j = operands[1];
                    TypeRefCPEntry typeEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                    sf.refRegs[j] = new BTypeDescValue(typeEntry.getType());
                    break;
                }
                case 117: {
                    if (strand.fp > 0) {
                        ObserveUtils.stopCallableObservation(strand);
                        strand.popFrame();
                        break;
                    }
                    sf.ip = -1;
                    strand.respCallback.signal();
                    break;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: {
                    BVM.execCmpAndBranchOpcodes(strand, sf, opcode, operands);
                    break;
                }
                case 206: {
                    BVM.execIntegerRangeOpcodes(sf, operands);
                    break;
                }
                case 118: {
                    Instruction.InstructionTrRetry trRetry = (Instruction.InstructionTrRetry)instruction;
                    BVM.retryTransaction(strand, trRetry.blockId, trRetry.abortEndIp, trRetry.trStatusReg);
                    break;
                }
                case 119: {
                    Instruction.InstructionCALL callIns = (Instruction.InstructionCALL)instruction;
                    strand = BVM.invokeCallable(strand, callIns.functionInfo, callIns.argRegs, callIns.retRegs[0], callIns.flags);
                    if (strand != null) break;
                    return;
                }
                case 120: {
                    Instruction.InstructionVCALL vcallIns = (Instruction.InstructionVCALL)instruction;
                    strand = BVM.invokeVirtualFunction(strand, sf, vcallIns.receiverRegIndex, vcallIns.functionInfo, vcallIns.argRegs, vcallIns.retRegs[0], vcallIns.flags);
                    if (strand != null) break;
                    return;
                }
                case 180: {
                    Instruction.InstructionTrBegin trBegin = (Instruction.InstructionTrBegin)instruction;
                    BVM.beginTransaction(strand, trBegin.transactionType, trBegin.blockId, trBegin.retryCountReg, trBegin.committedFuncIndex, trBegin.abortedFuncIndex);
                    break;
                }
                case 181: {
                    Instruction.InstructionTrEnd trEnd = (Instruction.InstructionTrEnd)instruction;
                    BVM.endTransaction(strand, trEnd.blockId, trEnd.endType, trEnd.statusRegIndex, trEnd.errorRegIndex);
                    break;
                }
                case 182: {
                    Instruction.InstructionWRKSendReceive wrkSendIns = (Instruction.InstructionWRKSendReceive)instruction;
                    BVM.handleWorkerSend(strand, wrkSendIns.dataChannelInfo, wrkSendIns.type, wrkSendIns.reg, wrkSendIns.channelInSameStrand);
                    break;
                }
                case 183: {
                    Instruction.InstructionWRKSendReceive wrkReceiveIns = (Instruction.InstructionWRKSendReceive)instruction;
                    if (BVM.handleWorkerReceive(strand, wrkReceiveIns.dataChannelInfo, wrkReceiveIns.type, wrkReceiveIns.reg, wrkReceiveIns.channelInSameStrand)) break;
                    return;
                }
                case 39: {
                    Instruction.InstructionCHNReceive chnReceiveIns = (Instruction.InstructionCHNReceive)instruction;
                    if (BVM.handleCHNReceive(strand, chnReceiveIns.channelName, chnReceiveIns.receiverType, chnReceiveIns.receiverReg, chnReceiveIns.keyType, chnReceiveIns.keyReg)) break;
                    return;
                }
                case 40: {
                    Instruction.InstructionCHNSend chnSendIns = (Instruction.InstructionCHNSend)instruction;
                    BVM.handleCHNSend(strand, chnSendIns.channelName, chnSendIns.dataType, chnSendIns.dataReg, chnSendIns.keyType, chnSendIns.keyReg);
                    break;
                }
                case 198: {
                    Instruction.InstructionFlush flushIns = (Instruction.InstructionFlush)instruction;
                    if (WaitCallbackHandler.handleFlush(strand, flushIns.retReg, flushIns.channels)) break;
                    return;
                }
                case 184: {
                    Instruction.InstructionWRKSyncSend syncSendIns = (Instruction.InstructionWRKSyncSend)instruction;
                    if (BVM.handleWorkerSyncSend(strand, syncSendIns.dataChannelInfo, syncSendIns.type, syncSendIns.reg, syncSendIns.retReg, syncSendIns.isSameStrand)) break;
                    return;
                }
                case 60: {
                    int i = operands[0];
                    if (i >= 0) {
                        BError error = (BError)sf.refRegs[i];
                        if (error == null) {
                            BVM.handleNullRefError(strand);
                            break;
                        }
                        strand.setError(error);
                    }
                    BVM.handleError(strand);
                    break;
                }
                case 59: {
                    BVM.createNewError(operands, strand, sf);
                    break;
                }
                case 121: {
                    int i = operands[0];
                    if (sf.refRegs[i] == null) {
                        BVM.handleNullRefError(strand);
                        break;
                    }
                    int cpIndex = operands[1];
                    FunctionCallCPEntry funcCallCPEntry = (FunctionCallCPEntry)sf.constPool[cpIndex];
                    FunctionInfo functionInfo = ((BFunctionPointer)sf.refRegs[i]).value();
                    if ((strand = BVM.invokeCallable(strand, (BFunctionPointer)sf.refRegs[i], funcCallCPEntry, functionInfo, sf, funcCallCPEntry.getFlags())) != null) break;
                    return;
                }
                case 122: {
                    BFunctionPointer functionPointer;
                    int i = operands[0];
                    int j = operands[1];
                    int k = operands[2];
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)sf.constPool[i];
                    TypeRefCPEntry typeEntry = (TypeRefCPEntry)sf.constPool[k];
                    sf.refRegs[j] = functionPointer = new BFunctionPointer(funcRefCPEntry.getFunctionInfo(), typeEntry.getType());
                    BVM.findAndAddAdditionalVarRegIndexesInFuncPointerLoad(sf, operands, functionPointer);
                    break;
                }
                case 123: {
                    BFunctionPointer fPointer;
                    int i = operands[0];
                    int j = operands[1];
                    int k = operands[2];
                    int m = operands[5];
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)sf.constPool[i];
                    TypeRefCPEntry typeEntry = (TypeRefCPEntry)sf.constPool[k];
                    BMap structVal = (BMap)sf.refRegs[m];
                    if (structVal == null) {
                        BVM.handleNullRefError(strand);
                        break;
                    }
                    ObjectTypeInfo structInfo = (ObjectTypeInfo)((BStructureType)structVal.getType()).getTypeInfo();
                    FunctionInfo attachedFuncInfo = structInfo.funcInfoEntries.get(funcRefCPEntry.getFunctionInfo().getName());
                    sf.refRegs[j] = fPointer = new BFunctionPointer(attachedFuncInfo, typeEntry.getType());
                    BVM.findAndAddAdditionalVarRegIndexesInVirtualFuncPointerLoad(sf, operands, fPointer);
                    break;
                }
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    BVM.execTypeCastOpcodes(strand, sf, opcode, operands);
                    break;
                }
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 170: 
                case 186: 
                case 187: 
                case 207: 
                case 208: 
                case 209: 
                case 221: {
                    BVM.execTypeConversionOpcodes(strand, sf, opcode, operands);
                    break;
                }
                case 193: {
                    int i = operands[0];
                    int j = operands[2];
                    sf.refRegs[i] = new BValueArray(BTypes.typeInt, (int)sf.longRegs[j]);
                    break;
                }
                case 192: {
                    int i = operands[0];
                    int j = operands[2];
                    sf.refRegs[i] = new BValueArray(BTypes.typeByte, (int)sf.longRegs[j]);
                    break;
                }
                case 194: {
                    int i = operands[0];
                    int j = operands[2];
                    sf.refRegs[i] = new BValueArray(BTypes.typeFloat, (int)sf.longRegs[j]);
                    break;
                }
                case 195: {
                    int i = operands[0];
                    int j = operands[2];
                    sf.refRegs[i] = new BValueArray(BTypes.typeString, (int)sf.longRegs[j]);
                    break;
                }
                case 196: {
                    int i = operands[0];
                    int j = operands[2];
                    sf.refRegs[i] = new BValueArray(BTypes.typeBoolean, (int)sf.longRegs[j]);
                    break;
                }
                case 197: {
                    int i = operands[0];
                    int cpIndex = operands[1];
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                    sf.refRegs[i] = new BValueArray(typeRefCPEntry.getType());
                    break;
                }
                case 200: {
                    BVM.createNewStruct(operands, sf);
                    break;
                }
                case 201: {
                    int i = operands[0];
                    int cpIndex = operands[1];
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                    sf.refRegs[i] = new BMap(typeRefCPEntry.getType());
                    break;
                }
                case 202: {
                    int i = operands[0];
                    int cpIndex = operands[1];
                    int j = operands[2];
                    int k = operands[3];
                    int l = operands[4];
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                    BValueArray indexColumns = (BValueArray)sf.refRegs[j];
                    BValueArray keyColumns = (BValueArray)sf.refRegs[k];
                    BValueArray dataRows = (BValueArray)sf.refRegs[l];
                    try {
                        sf.refRegs[i] = new BTable(typeRefCPEntry.getType(), indexColumns, keyColumns, dataRows);
                    }
                    catch (BallerinaException e) {
                        strand.setError(BLangVMErrors.createError(strand, e.getMessage()));
                        BVM.handleError(strand);
                    }
                    break;
                }
                case 203: {
                    BStream stream;
                    int i = operands[0];
                    int cpIndex = operands[1];
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                    StringCPEntry name = (StringCPEntry)sf.constPool[operands[2]];
                    sf.refRegs[i] = stream = new BStream(typeRefCPEntry.getType(), name.getValue());
                    break;
                }
                case 213: {
                    int callersRetRegIndex;
                    StackFrame pf;
                    int j = operands[0];
                    if (strand.fp > 0) {
                        pf = strand.peekFrame(1);
                        callersRetRegIndex = sf.retReg;
                        pf.longRegs[callersRetRegIndex] = sf.longRegs[j];
                        break;
                    }
                    strand.respCallback.setIntReturn(sf.longRegs[j]);
                    break;
                }
                case 214: {
                    int callersRetRegIndex;
                    StackFrame pf;
                    int j = operands[0];
                    if (strand.fp > 0) {
                        pf = strand.peekFrame(1);
                        callersRetRegIndex = sf.retReg;
                        pf.doubleRegs[callersRetRegIndex] = sf.doubleRegs[j];
                        break;
                    }
                    strand.respCallback.setFloatReturn(sf.doubleRegs[j]);
                    break;
                }
                case 215: {
                    int callersRetRegIndex;
                    StackFrame pf;
                    int j = operands[0];
                    if (strand.fp > 0) {
                        pf = strand.peekFrame(1);
                        callersRetRegIndex = sf.retReg;
                        pf.stringRegs[callersRetRegIndex] = sf.stringRegs[j];
                        break;
                    }
                    strand.respCallback.setStringReturn(sf.stringRegs[j]);
                    break;
                }
                case 216: {
                    int callersRetRegIndex;
                    StackFrame pf;
                    int j = operands[0];
                    if (strand.fp > 0) {
                        pf = strand.peekFrame(1);
                        callersRetRegIndex = sf.retReg;
                        pf.intRegs[callersRetRegIndex] = sf.intRegs[j];
                        break;
                    }
                    strand.respCallback.setBooleanReturn(sf.intRegs[j]);
                    break;
                }
                case 217: 
                case 218: {
                    int callersRetRegIndex;
                    StackFrame pf;
                    int j = operands[0];
                    if (strand.fp > 0) {
                        pf = strand.peekFrame(1);
                        callersRetRegIndex = sf.retReg;
                        pf.refRegs[callersRetRegIndex] = sf.refRegs[j];
                    } else {
                        strand.respCallback.setRefReturn(sf.refRegs[j]);
                    }
                    if (!BVM.checkIsType(sf.refRegs[j], BTypes.typeError)) break;
                    sf.errorRetReg = j;
                    break;
                }
                case 219: {
                    if (strand.fp > 0) {
                        ObserveUtils.stopCallableObservation(strand);
                        if (sf.errorRetReg > -1) {
                            sf.handleChannelError(sf.refRegs[sf.errorRetReg], strand.peekFrame((int)1).wdChannels);
                        }
                        strand.popFrame();
                        break;
                    }
                    if (sf.errorRetReg > -1) {
                        sf.handleChannelError(sf.refRegs[sf.errorRetReg], strand.respCallback.parentChannels);
                    }
                    sf.ip = -1;
                    strand.respCallback.signal();
                    return;
                }
                case 220: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: {
                    BVM.execXMLOpcodes(strand, sf, opcode, operands);
                    break;
                }
                case 205: {
                    BVM.execIteratorOperation(strand, sf, instruction);
                    break;
                }
                case 178: {
                    Instruction.InstructionLock instructionLock = (Instruction.InstructionLock)instruction;
                    if (BVM.handleVariableLock(strand, instructionLock.types, instructionLock.pkgRefs, instructionLock.varRegs, instructionLock.fieldRegs, instructionLock.varCount, instructionLock.uuid)) break;
                    return;
                }
                case 179: {
                    Instruction.InstructionUnLock instructionUnLock = (Instruction.InstructionUnLock)instruction;
                    BVM.handleVariableUnlock(strand, instructionUnLock.types, instructionUnLock.pkgRefs, instructionUnLock.varRegs, instructionUnLock.varCount, instructionUnLock.uuid, instructionUnLock.hasFieldVar);
                    break;
                }
                case 185: {
                    if (BVM.execWait(strand, operands)) break;
                    return;
                }
                case 199: {
                    if (BVM.execWaitForAll(strand, operands)) break;
                    return;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            sf = strand.currentFrame;
        }
    }

    private static void handleFutureTermination(Strand strand) {
        BError error = BLangVMErrors.createCancelledFutureError(strand);
        strand.setError(error);
        ((SafeStrandCallback)strand.respCallback).setErrorForCancelledFuture(error);
        strand.currentFrame.ip = -1;
        BVM.panicStackFrame(strand);
        BVM.signalTransactionError(strand, StackFrame.TransactionParticipantType.REMOTE_PARTICIPANT);
        strand.respCallback.signal();
    }

    private static void panicStackFrame(Strand strand) {
        if (strand.fp < 0) {
            return;
        }
        StackFrame poppedFrame = strand.popFrame();
        ObserveUtils.stopObservation(poppedFrame.observerContext);
        poppedFrame.handleChannelPanic(strand.getError(), poppedFrame.wdChannels);
        BVM.signalTransactionError(strand, poppedFrame.trxParticipant);
        BVM.panicStackFrame(strand);
    }

    private static boolean handleWorkerSyncSend(Strand strand, WorkerDataChannelInfo dataChannelInfo, BType type, int reg, int retReg, boolean isSameStrand) {
        BRefType val = BVM.extractValue(strand.currentFrame, type, reg);
        WorkerDataChannel dataChannel = BVM.getWorkerChannel(strand, dataChannelInfo.getChannelName(), isSameStrand);
        return dataChannel.syncSendData(val, strand, retReg);
    }

    private static Strand invokeCallable(Strand strand, CallableUnitInfo callableUnitInfo, int[] argRegs, int retReg, int flags) {
        StackFrame df = new StackFrame(callableUnitInfo.getPackageInfo(), callableUnitInfo, callableUnitInfo.getDefaultWorkerInfo().getCodeAttributeInfo(), retReg, flags, callableUnitInfo.workerSendInChannels);
        BVM.copyArgValues(strand.currentFrame, df, argRegs, callableUnitInfo.getParamTypes());
        if (!FunctionFlags.isAsync((int)df.invocationFlags)) {
            try {
                strand.pushFrame(df);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                --strand.fp;
                strand.setError(BLangVMErrors.createError(strand, BallerinaErrorReasons.STACK_OVERFLOW_ERROR, "stack overflow"));
                BVM.handleError(strand);
                return strand;
            }
            ObserveUtils.startCallableObservation(strand, df.invocationFlags);
            if (callableUnitInfo.isNative()) {
                return BVM.invokeNativeCallable(callableUnitInfo, strand, df, retReg, df.invocationFlags);
            }
            return strand;
        }
        SafeStrandCallback strandCallback = new SafeStrandCallback(callableUnitInfo.getRetParamTypes()[0], strand.currentFrame.wdChannels, callableUnitInfo.workerSendInChannels);
        Strand calleeStrand = new Strand(strand.programFile, callableUnitInfo.getName(), strand.globalProps, strandCallback);
        calleeStrand.pushFrame(df);
        ObserveUtils.startCallableObservation(calleeStrand, strand.respCallback.getObserverContext());
        if (callableUnitInfo.isNative()) {
            NativeCallContext nativeCtx = new NativeCallContext(calleeStrand, callableUnitInfo, df);
            NativeCallableUnit nativeCallable = callableUnitInfo.getNativeCallableUnit();
            if (nativeCallable.isBlocking()) {
                BVMScheduler.scheduleNative(nativeCallable, nativeCtx, null);
            } else {
                BLangCallableUnitCallback callableUnitCallback = new BLangCallableUnitCallback(nativeCtx, calleeStrand, retReg, callableUnitInfo.getRetParamTypes()[0]);
                BVMScheduler.executeNative(nativeCallable, nativeCtx, callableUnitCallback);
            }
        } else {
            BVMScheduler.schedule(calleeStrand);
        }
        strand.currentFrame.refRegs[retReg] = new BCallableFuture(callableUnitInfo.getName(), calleeStrand);
        return strand;
    }

    private static Strand invokeNativeCallable(CallableUnitInfo callableUnitInfo, Strand strand, StackFrame sf, int retReg, int flags) {
        BType retType = callableUnitInfo.getRetParamTypes()[0];
        NativeCallContext ctx = new NativeCallContext(strand, callableUnitInfo, sf);
        NativeCallableUnit nativeCallable = callableUnitInfo.getNativeCallableUnit();
        try {
            if (nativeCallable.isBlocking()) {
                nativeCallable.execute(ctx, null);
                if (strand.fp > 0) {
                    ObserveUtils.stopCallableObservation(strand);
                    if (BVM.checkIsType(ctx.getReturnValue(), BTypes.typeError)) {
                        strand.currentFrame.handleChannelError((BRefType)ctx.getReturnValue(), strand.peekFrame((int)1).wdChannels);
                    }
                    strand.popFrame();
                    StackFrame retFrame = strand.currentFrame;
                    BLangVMUtils.populateWorkerDataWithValues(retFrame, retReg, ctx.getReturnValue(), retType);
                    return strand;
                }
                if (BVM.checkIsType(ctx.getReturnValue(), BTypes.typeError)) {
                    strand.currentFrame.handleChannelError((BRefType)ctx.getReturnValue(), strand.respCallback.parentChannels);
                }
                strand.respCallback.signal();
                return null;
            }
            BLangCallableUnitCallback callback = new BLangCallableUnitCallback(ctx, strand, retReg, retType);
            nativeCallable.execute(ctx, callback);
            return null;
        }
        catch (BLangNullReferenceException e) {
            strand.setError(BLangVMErrors.createNullRefException(strand));
        }
        catch (BallerinaException e) {
            strand.setError(BLangVMErrors.createError(strand, e.getMessage(), e.getDetail()));
        }
        catch (Throwable e) {
            strand.setError(BLangVMErrors.createError(strand, e.getMessage()));
        }
        ObserveUtils.stopCallableObservation(strand);
        if (strand.fp > 0) {
            strand.currentFrame.handleChannelPanic(strand.getError(), strand.peekFrame((int)1).wdChannels);
            strand.popFrame();
        } else {
            strand.currentFrame.handleChannelPanic(strand.getError(), strand.respCallback.parentChannels);
            strand.popFrame();
        }
        BVM.handleError(strand);
        return strand;
    }

    private static void copyArgValues(StackFrame caller, StackFrame callee, int[] argRegs, BType[] paramTypes) {
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        block6: for (int i = 0; i < argRegs.length; ++i) {
            BType paramType = paramTypes[i];
            int argReg = argRegs[i];
            switch (paramType.getTag()) {
                case 1: 
                case 2: {
                    callee.longRegs[++longRegIndex] = caller.longRegs[argReg];
                    continue block6;
                }
                case 3: {
                    callee.doubleRegs[++doubleRegIndex] = caller.doubleRegs[argReg];
                    continue block6;
                }
                case 5: {
                    callee.stringRegs[++stringRegIndex] = caller.stringRegs[argReg];
                    continue block6;
                }
                case 6: {
                    callee.intRegs[++booleanRegIndex] = caller.intRegs[argReg];
                    continue block6;
                }
                default: {
                    callee.refRegs[++refRegIndex] = caller.refRegs[argReg];
                }
            }
        }
    }

    private static void createNewError(int[] operands, Strand strand, StackFrame sf) {
        int i = operands[0];
        int j = operands[1];
        int k = operands[2];
        int l = operands[3];
        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[i];
        sf.refRegs[l] = BLangVMErrors.createError(strand, true, (BErrorType)typeRefCPEntry.getType(), sf.stringRegs[j], (BMap<String, BValue>)((BMap)sf.refRegs[k]));
    }

    private static void handleCHNSend(Strand ctx, String channelName, BType dataType, int dataReg, BType keyType, int keyReg) {
        BRefType dataVal;
        ChannelRegistry.PendingContext pendingCtx;
        BRefType keyVal = null;
        if (keyType != null) {
            keyVal = BVM.extractValue(ctx.currentFrame, keyType, keyReg);
        }
        if ((pendingCtx = ChannelManager.channelSenderAction(channelName, keyVal, dataVal = BVM.extractValue(ctx.currentFrame, dataType, dataReg), keyType, dataType)) != null) {
            BVM.copyArgValueForWorkerReceive(pendingCtx.context.currentFrame, pendingCtx.regIndex, dataType, dataVal);
            BVMScheduler.schedule(pendingCtx.context);
        }
    }

    private static boolean handleCHNReceive(Strand ctx, String channelName, BType receiverType, int receiverReg, BType keyType, int keyIndex) {
        BValue value;
        BRefType keyVal = null;
        if (keyType != null) {
            keyVal = BVM.extractValue(ctx.currentFrame, keyType, keyIndex);
        }
        if ((value = ChannelManager.channelReceiverAction(channelName, keyVal, keyType, ctx, receiverReg, receiverType)) != null) {
            BVM.copyArgValueForWorkerReceive(ctx.currentFrame, receiverReg, receiverType, (BRefType)value);
            return true;
        }
        return false;
    }

    private static Strand invokeCallable(Strand ctx, BFunctionPointer fp, FunctionCallCPEntry funcCallCPEntry, FunctionInfo functionInfo, StackFrame sf, int flags) {
        List<BClosure> closureVars = fp.getClosureVars();
        int[] argRegs = funcCallCPEntry.getArgRegs();
        if (closureVars.isEmpty()) {
            return BVM.invokeCallable(ctx, functionInfo, argRegs, funcCallCPEntry.getRetRegs()[0], flags);
        }
        int[] newArgRegs = new int[argRegs.length + closureVars.size()];
        System.arraycopy(argRegs, 0, newArgRegs, closureVars.size(), argRegs.length);
        int argRegIndex = 0;
        int refIndex = BVM.expandRefRegs(sf, fp);
        for (BClosure closure : closureVars) {
            sf.refRegs[refIndex] = (BRefType)closure.value();
            newArgRegs[argRegIndex++] = refIndex++;
        }
        return BVM.invokeCallable(ctx, functionInfo, newArgRegs, funcCallCPEntry.getRetRegs()[0], flags);
    }

    private static int expandRefRegs(StackFrame sf, BFunctionPointer fp) {
        int refIndex = 0;
        if (fp.getAdditionalIndexCount(BTypes.typeAny.getTag()) > 0) {
            if (sf.refRegs == null) {
                sf.refRegs = new BRefType[0];
            }
            BRefType[] newRefRegs = new BRefType[sf.refRegs.length + fp.getAdditionalIndexCount(BTypes.typeAny.getTag())];
            System.arraycopy(sf.refRegs, 0, newRefRegs, 0, sf.refRegs.length);
            refIndex = sf.refRegs.length;
            sf.refRegs = newRefRegs;
        }
        return refIndex;
    }

    private static void findAndAddAdditionalVarRegIndexesInFuncPointerLoad(StackFrame sf, int[] operands, BFunctionPointer fp) {
        int h = operands[3];
        if (h == 0) {
            return;
        }
        for (int i = 0; i < h; ++i) {
            int operandIndex = i + 4;
            int index = operands[operandIndex];
            fp.addClosureVar(new BClosure(sf.refRegs[index], BTypes.typeAny), 17);
        }
    }

    private static void findAndAddAdditionalVarRegIndexesInVirtualFuncPointerLoad(StackFrame sf, int[] operands, BFunctionPointer fp) {
        int h = operands[3];
        if (h == 0) {
            return;
        }
        for (int i = 0; i < h; ++i) {
            int operandIndex = i + 4;
            int type = operands[operandIndex];
            int index = operands[++operandIndex];
            switch (type) {
                case 1: {
                    fp.addClosureVar(new BClosure(new BInteger(sf.longRegs[index]), BTypes.typeInt), 1);
                    break;
                }
                case 2: {
                    fp.addClosureVar(new BClosure(new BByte(sf.longRegs[index]), BTypes.typeByte), 1);
                    break;
                }
                case 3: {
                    fp.addClosureVar(new BClosure(new BFloat(sf.doubleRegs[index]), BTypes.typeFloat), 3);
                    break;
                }
                case 4: {
                    fp.addClosureVar(new BClosure(sf.refRegs[index], BTypes.typeDecimal), 4);
                    break;
                }
                case 6: {
                    fp.addClosureVar(new BClosure(new BBoolean(sf.intRegs[index] == 1), BTypes.typeBoolean), 6);
                    break;
                }
                case 5: {
                    fp.addClosureVar(new BClosure(new BString(sf.stringRegs[index]), BTypes.typeString), 5);
                    break;
                }
                default: {
                    fp.addClosureVar(new BClosure(sf.refRegs[index], BTypes.typeAny), 17);
                }
            }
            ++i;
        }
    }

    private static void execCmpAndBranchOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 100: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] > sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 101: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] > sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 102: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.intRegs[k] = BVM.checkDecimalGreaterThan(lhsValue, rhsValue) ? 1 : 0;
                break;
            }
            case 103: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] >= sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 104: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] >= sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 105: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.intRegs[k] = BVM.checkDecimalGreaterThanOrEqual(lhsValue, rhsValue) ? 1 : 0;
                break;
            }
            case 106: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] < sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 107: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] < sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 108: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.intRegs[k] = BVM.checkDecimalGreaterThan(rhsValue, lhsValue) ? 1 : 0;
                break;
            }
            case 109: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] <= sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 110: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] <= sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 111: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.intRegs[k] = BVM.checkDecimalGreaterThanOrEqual(rhsValue, lhsValue) ? 1 : 0;
                break;
            }
            case 112: {
                int i = operands[0];
                int j = operands[1];
                if (sf.refRegs[i] == null) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 113: {
                int i = operands[0];
                int j = operands[1];
                if (sf.refRegs[i] != null) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 114: {
                int i = operands[0];
                int j = operands[1];
                if (sf.intRegs[i] != 1) break;
                sf.ip = j;
                break;
            }
            case 115: {
                int i = operands[0];
                int j = operands[1];
                if (sf.intRegs[i] != 0) break;
                sf.ip = j;
                break;
            }
            case 116: {
                int i;
                sf.ip = i = operands[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execIntegerRangeOpcodes(StackFrame sf, int[] operands) {
        int i = operands[0];
        int j = operands[1];
        int k = operands[2];
        sf.refRegs[k] = new BValueArray(LongStream.rangeClosed(sf.longRegs[i], sf.longRegs[j]).toArray());
    }

    private static void execLoadOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 22: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.longRegs[i] = sf.longRegs[lvIndex];
                break;
            }
            case 23: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.doubleRegs[i] = sf.doubleRegs[lvIndex];
                break;
            }
            case 24: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.stringRegs[i] = sf.stringRegs[lvIndex];
                break;
            }
            case 25: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.intRegs[i] = sf.intRegs[lvIndex];
                break;
            }
            case 26: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.refRegs[i] = sf.refRegs[lvIndex];
                break;
            }
            case 28: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    sf.longRegs[k] = bValueArray.getInt(sf.longRegs[j]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 27: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    sf.longRegs[k] = Byte.toUnsignedLong(bValueArray.getByte(sf.longRegs[j]));
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 29: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    sf.doubleRegs[k] = bValueArray.getFloat(sf.longRegs[j]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 30: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    sf.stringRegs[k] = bValueArray.getString(sf.longRegs[j]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 31: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    sf.intRegs[k] = bValueArray.getBoolean(sf.longRegs[j]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 32: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BNewArray bNewArray = Optional.of((BNewArray)sf.refRegs[i]).get();
                try {
                    sf.refRegs[k] = ListUtils.execListGetOperation(bNewArray, sf.longRegs[j]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 33: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                try {
                    sf.refRegs[k] = JSONUtils.getArrayElement(sf.refRegs[i], sf.longRegs[j]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 34: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                sf.longRegs[j] = ctx.programFile.globalMemArea.getIntField(pkgIndex, i);
                break;
            }
            case 35: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                sf.doubleRegs[j] = ctx.programFile.globalMemArea.getFloatField(pkgIndex, i);
                break;
            }
            case 36: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                sf.stringRegs[j] = ctx.programFile.globalMemArea.getStringField(pkgIndex, i);
                break;
            }
            case 37: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                sf.intRegs[j] = ctx.programFile.globalMemArea.getBooleanField(pkgIndex, i);
                break;
            }
            case 38: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                sf.refRegs[j] = ctx.programFile.globalMemArea.getRefField(pkgIndex, i);
                break;
            }
            case 41: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BMap bMap = (BMap)sf.refRegs[i];
                if (bMap == null) {
                    BVM.handleNullRefError(ctx);
                    break;
                }
                IntegerCPEntry exceptCPEntry = (IntegerCPEntry)sf.constPool[operands[3]];
                boolean except = exceptCPEntry.getValue() == 1L;
                try {
                    sf.refRegs[k] = (BRefType)bMap.get(sf.stringRegs[j], except);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 42: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.refRegs[k] = JSONUtils.getElement(sf.refRegs[i], sf.stringRegs[j]);
                break;
            }
            case 21: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                PackageInfo packageInfoEntry = ctx.programFile.getPackageInfoEntries()[pkgIndex];
                sf.refRegs[j] = ((MapCPEntry)packageInfoEntry.getConstPoolEntries()[i]).getBMap();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execStoreOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 45: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    bValueArray.add(sf.longRegs[j], sf.longRegs[k]);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 44: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    bValueArray.add(sf.longRegs[j], (byte)sf.longRegs[k]);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 46: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    bValueArray.add(sf.longRegs[j], sf.doubleRegs[k]);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 47: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    bValueArray.add(sf.longRegs[j], sf.stringRegs[k]);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 48: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BValueArray bValueArray = Optional.of((BValueArray)sf.refRegs[i]).get();
                try {
                    bValueArray.add(sf.longRegs[j], sf.intRegs[k]);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 49: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BNewArray list = Optional.of((BNewArray)sf.refRegs[i]).get();
                long index = sf.longRegs[j];
                BRefType<?> refReg = sf.refRegs[k];
                BType elementType = null;
                if (list.getType().getTag() == 19) {
                    elementType = ((BArrayType)list.getType()).getElementType();
                } else {
                    BTupleType tupleType = (BTupleType)list.getType();
                    if (BVM.isTupleIndexWithinRange(tupleType, index)) {
                        elementType = tupleType.getTupleTypes().get((int)index);
                    }
                }
                if (elementType != null && !BVM.checkIsType(refReg, elementType)) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_TYPE, elementType, refReg != null ? refReg.getType() : BTypes.typeNull)));
                    BVM.handleError(ctx);
                    break;
                }
                try {
                    ListUtils.execListAddOperation(list, index, refReg);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 50: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                try {
                    JSONUtils.setArrayElement(sf.refRegs[i], sf.longRegs[j], sf.refRegs[k]);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 53: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                ctx.programFile.globalMemArea.setIntField(pkgIndex, j, sf.longRegs[i]);
                break;
            }
            case 54: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                ctx.programFile.globalMemArea.setFloatField(pkgIndex, j, sf.doubleRegs[i]);
                break;
            }
            case 55: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                ctx.programFile.globalMemArea.setStringField(pkgIndex, j, sf.stringRegs[i]);
                break;
            }
            case 56: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                ctx.programFile.globalMemArea.setBooleanField(pkgIndex, j, sf.intRegs[i]);
                break;
            }
            case 57: {
                int pkgIndex = operands[0];
                int i = operands[1];
                int j = operands[2];
                ctx.programFile.globalMemArea.setRefField(pkgIndex, j, sf.refRegs[i]);
                break;
            }
            case 61: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BMap bMap = (BMap)sf.refRegs[i];
                if (bMap == null) {
                    BVM.handleNullRefError(ctx);
                    break;
                }
                try {
                    BVM.handleMapStore(ctx, bMap, sf.stringRegs[j], sf.refRegs[k]);
                }
                catch (BLangMapStoreException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 62: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                try {
                    JSONUtils.setElement(sf.refRegs[i], sf.stringRegs[j], sf.refRegs[k]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                catch (BLangFreezeException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
                    BVM.handleError(ctx);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static boolean isTupleIndexWithinRange(BTupleType tuple, long index) {
        return index >= 0L && index < (long)tuple.getTupleTypes().size();
    }

    private static void execBinaryOpCodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 63: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] + sf.longRegs[j];
                break;
            }
            case 64: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] + sf.doubleRegs[j];
                break;
            }
            case 65: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.stringRegs[k] = sf.stringRegs[i] + sf.stringRegs[j];
                break;
            }
            case 66: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.refRegs[k] = lhsValue.add(rhsValue);
                break;
            }
            case 69: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML lhsXMLVal = (BXML)sf.refRegs[i];
                BXML rhsXMLVal = (BXML)sf.refRegs[j];
                sf.refRegs[k] = XMLUtils.concatenate(lhsXMLVal, rhsXMLVal);
                break;
            }
            case 70: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] - sf.longRegs[j];
                break;
            }
            case 71: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] - sf.doubleRegs[j];
                break;
            }
            case 72: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.refRegs[k] = lhsValue.subtract(rhsValue);
                break;
            }
            case 73: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] * sf.longRegs[j];
                break;
            }
            case 74: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] * sf.doubleRegs[j];
                break;
            }
            case 75: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.refRegs[k] = lhsValue.multiply(rhsValue);
                break;
            }
            case 76: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.longRegs[j] == 0L) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.DIVISION_BY_ZERO_ERROR, " / by zero"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[k] = sf.longRegs[i] / sf.longRegs[j];
                break;
            }
            case 77: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] / sf.doubleRegs[j];
                break;
            }
            case 78: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.refRegs[k] = lhsValue.divide(rhsValue);
                break;
            }
            case 79: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.longRegs[j] == 0L) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.DIVISION_BY_ZERO_ERROR, " / by zero"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[k] = sf.longRegs[i] % sf.longRegs[j];
                break;
            }
            case 80: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] % sf.doubleRegs[j];
                break;
            }
            case 81: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.refRegs[k] = lhsValue.remainder(rhsValue);
                break;
            }
            case 82: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = -sf.longRegs[i];
                break;
            }
            case 83: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = -sf.doubleRegs[i];
                break;
            }
            case 84: {
                int i = operands[0];
                int j = operands[1];
                BigDecimal value = ((BDecimal)sf.refRegs[i]).decimalValue();
                sf.refRegs[j] = new BDecimal(value.negate());
                break;
            }
            case 85: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = sf.intRegs[i] == 0 ? 1 : 0;
                break;
            }
            case 86: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] == sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 87: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] == sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 88: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = StringUtils.isEqual(sf.stringRegs[i], sf.stringRegs[j]) ? 1 : 0;
                break;
            }
            case 89: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.intRegs[i] == sf.intRegs[j] ? 1 : 0;
                break;
            }
            case 90: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.intRegs[k] = BVM.isDecimalRealNumber(lhsValue) && BVM.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0 ? 1 : 0;
                break;
            }
            case 91: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.refRegs[i] == null) {
                    sf.intRegs[k] = sf.refRegs[j] == null ? 1 : 0;
                    break;
                }
                sf.intRegs[k] = BVM.isEqual(sf.refRegs[i], sf.refRegs[j], new ArrayList<ValuePair>()) ? 1 : 0;
                break;
            }
            case 92: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = BVM.isReferenceEqual(sf.refRegs[i], sf.refRegs[j]) ? 1 : 0;
                break;
            }
            case 237: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.refRegs[i] == null || sf.refRegs[j] == null) {
                    BVM.handleNullRefError(ctx);
                    break;
                }
                sf.intRegs[k] = sf.refRegs[i].equals(sf.refRegs[j]) ? 1 : 0;
                break;
            }
            case 93: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] != sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 94: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] != sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 95: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = !StringUtils.isEqual(sf.stringRegs[i], sf.stringRegs[j]) ? 1 : 0;
                break;
            }
            case 96: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.intRegs[i] != sf.intRegs[j] ? 1 : 0;
                break;
            }
            case 97: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BDecimal lhsValue = (BDecimal)sf.refRegs[i];
                BDecimal rhsValue = (BDecimal)sf.refRegs[j];
                sf.intRegs[k] = !BVM.isDecimalRealNumber(lhsValue) || !BVM.isDecimalRealNumber(rhsValue) || lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) != 0 ? 1 : 0;
                break;
            }
            case 98: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.refRegs[i] == null) {
                    sf.intRegs[k] = sf.refRegs[j] != null ? 1 : 0;
                    break;
                }
                sf.intRegs[k] = !BVM.isEqual(sf.refRegs[i], sf.refRegs[j], new ArrayList<ValuePair>()) ? 1 : 0;
                break;
            }
            case 99: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = BVM.isReferenceInequal(sf.refRegs[i], sf.refRegs[j]) ? 1 : 0;
                break;
            }
            case 238: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.refRegs[i] == null || sf.refRegs[j] == null) {
                    BVM.handleNullRefError(ctx);
                    break;
                }
                sf.intRegs[k] = !sf.refRegs[i].equals(sf.refRegs[j]) ? 1 : 0;
                break;
            }
            case 51: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] & sf.longRegs[j];
                break;
            }
            case 52: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] | sf.longRegs[j];
                break;
            }
            case 210: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] ^ sf.longRegs[j];
                break;
            }
            case 151: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = Byte.toUnsignedLong((byte)(sf.longRegs[i] << (int)sf.longRegs[j]));
                break;
            }
            case 152: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = Byte.toUnsignedLong((byte)((byte)sf.longRegs[i] >> (int)sf.longRegs[j]));
                break;
            }
            case 154: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] >> (int)sf.longRegs[j];
                break;
            }
            case 153: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] << (int)sf.longRegs[j];
                break;
            }
            case 212: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] >>> (int)sf.longRegs[j];
                break;
            }
            case 235: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[j];
                sf.intRegs[k] = BVM.checkIsType(sf.refRegs[i], typeRefCPEntry.getType()) ? 1 : 0;
                break;
            }
            case 58: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[j];
                sf.intRegs[k] = BVM.checkIsLikeType(sf.refRegs[i], typeRefCPEntry.getType()) ? 1 : 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execXMLOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 223: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = Optional.of((BXML)sf.refRegs[i]).get();
                BXMLQName xmlQName = Optional.of((BXMLQName)sf.refRegs[j]).get();
                try {
                    xmlVal.setAttribute(xmlQName.getLocalName(), xmlQName.getUri(), xmlQName.getPrefix(), sf.stringRegs[k]);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.XML_OPERATION_ERROR, e.getMessage()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 222: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = Optional.of((BXML)sf.refRegs[i]).get();
                BXMLQName xmlQName = Optional.of((BXMLQName)sf.refRegs[j]).get();
                sf.stringRegs[k] = xmlVal.getAttribute(xmlQName.getLocalName(), xmlQName.getUri(), xmlQName.getPrefix());
                break;
            }
            case 220: {
                int i = operands[0];
                int j = operands[1];
                BXML xmlVal = (BXML)sf.refRegs[i];
                sf.refRegs[j] = xmlVal.getAttributesMap();
                break;
            }
            case 224: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                String qNameStr = sf.stringRegs[i];
                int parenEndIndex = qNameStr.indexOf(125);
                if (qNameStr.startsWith("{") && parenEndIndex > 0) {
                    sf.stringRegs[j] = qNameStr.substring(parenEndIndex + 1, qNameStr.length());
                    sf.stringRegs[k] = qNameStr.substring(1, parenEndIndex);
                    break;
                }
                sf.stringRegs[j] = qNameStr;
                sf.stringRegs[k] = BLangConstants.STRING_NULL_VALUE;
                break;
            }
            case 225: {
                int localNameIndex = operands[0];
                int uriIndex = operands[1];
                int prefixIndex = operands[2];
                int i = operands[3];
                String localname = sf.stringRegs[localNameIndex];
                localname = StringEscapeUtils.escapeXml11((String)localname);
                String prefix = sf.stringRegs[prefixIndex];
                prefix = StringEscapeUtils.escapeXml11((String)prefix);
                sf.refRegs[i] = new BXMLQName(localname, sf.stringRegs[uriIndex], prefix);
                break;
            }
            case 231: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = Optional.of((BXML)sf.refRegs[i]).get();
                long index = sf.longRegs[j];
                try {
                    sf.refRegs[k] = xmlVal.getItem(index);
                }
                catch (BallerinaException e) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.XML_OPERATION_ERROR, e.getMessage()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 232: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = Optional.of((BXML)sf.refRegs[i]).get();
                String qname = sf.stringRegs[j];
                sf.refRegs[k] = xmlVal.children(qname);
                break;
            }
            case 233: {
                int i = operands[0];
                int j = operands[1];
                BXML xmlVal = Optional.of((BXML)sf.refRegs[i]).get();
                sf.refRegs[j] = xmlVal.children();
                break;
            }
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 234: {
                BVM.execXMLCreationOpcodes(ctx, sf, opcode, operands);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execTypeCastOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        block0 : switch (opcode) {
            case 159: {
                int i = operands[0];
                int cpIndex = operands[1];
                int j = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                BType expectedType = typeRefCPEntry.getType();
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                if (bRefTypeValue == null) {
                    if (BVM.checkIsType(BTypes.typeNull, expectedType, new ArrayList<TypePair>())) {
                        sf.refRegs[j] = null;
                        break;
                    }
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.TYPE_CAST_ERROR, "()", expectedType)));
                    BVM.handleError(ctx);
                    break;
                }
                if (BVM.checkIsType(bRefTypeValue, expectedType)) {
                    switch (expectedType.getTag()) {
                        case 5: {
                            sf.stringRegs[j] = bRefTypeValue.stringValue();
                            break block0;
                        }
                        case 6: {
                            sf.intRegs[j] = ((BBoolean)bRefTypeValue).booleanValue() ? 1 : 0;
                            break block0;
                        }
                        case 1: {
                            sf.longRegs[j] = ((BInteger)bRefTypeValue).intValue();
                            break block0;
                        }
                        case 3: {
                            sf.doubleRegs[j] = ((BFloat)bRefTypeValue).floatValue();
                            break block0;
                        }
                        case 4: {
                            sf.refRegs[j] = (BDecimal)bRefTypeValue;
                            break block0;
                        }
                        case 2: {
                            sf.longRegs[j] = ((BByte)bRefTypeValue).byteValue();
                            break block0;
                        }
                    }
                    sf.refRegs[j] = bRefTypeValue;
                    break;
                }
                if (BVM.containsNumericType(expectedType)) {
                    BVM.execNumericConversionOrCastOpCode(ctx, sf, expectedType, bRefTypeValue, j, false);
                    break;
                }
                ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.TYPE_CAST_ERROR, bRefTypeValue.getType(), expectedType.getTag() == 10 ? "()" : expectedType)));
                BVM.handleError(ctx);
                break;
            }
            case 155: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BInteger(sf.longRegs[i]);
                break;
            }
            case 172: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BByte(sf.longRegs[i]);
                break;
            }
            case 156: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BFloat(sf.doubleRegs[i]);
                break;
            }
            case 157: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BString(sf.stringRegs[i]);
                break;
            }
            case 158: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BBoolean(sf.intRegs[i] == 1);
                break;
            }
            case 160: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = ((BValueType)((Object)sf.refRegs[i])).intValue();
                break;
            }
            case 171: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = ((BValueType)((Object)sf.refRegs[i])).byteValue();
                break;
            }
            case 161: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = ((BValueType)((Object)sf.refRegs[i])).floatValue();
                break;
            }
            case 162: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.refRegs[i].stringValue();
                break;
            }
            case 163: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = ((BBoolean)sf.refRegs[i]).booleanValue() ? 1 : 0;
                break;
            }
            case 164: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BDecimal(((BValueType)((Object)sf.refRegs[i])).decimalValue());
                break;
            }
            case 165: {
                BVM.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeJSON);
                break;
            }
            case 166: {
                BVM.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeXML);
                break;
            }
            case 167: {
                BVM.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeMap);
                break;
            }
            case 177: {
                BVM.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeDesc);
                break;
            }
            case 169: {
                BVM.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeTable);
                break;
            }
            case 168: {
                BVM.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeStream);
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                int i = operands[0];
                int cpIndex = operands[1];
                int j = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                if (BVM.checkCast(bRefTypeValue, typeRefCPEntry.getType())) {
                    sf.refRegs[j] = bRefTypeValue;
                    break;
                }
                BVM.handleTypeCastError(ctx, sf, j, bRefTypeValue != null ? bRefTypeValue.getType() : BTypes.typeNull, typeRefCPEntry.getType());
                break;
            }
            case 188: {
                int i = operands[0];
                int cpIndex = operands[1];
                int j = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                if (BVM.checkIsType(bRefTypeValue, typeRefCPEntry.getType())) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 190: {
                BVM.convertArrayToJSON(ctx, operands, sf);
                break;
            }
            case 191: {
                BVM.convertJSONToArray(ctx, operands, sf);
                break;
            }
            case 189: {
                int i = operands[0];
                int cpIndex = operands[1];
                int j = operands[2];
                BJSONType targetType = (BJSONType)((TypeRefCPEntry)sf.constPool[cpIndex]).getType();
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                sf.refRegs[j] = JSONUtils.convertUnionTypeToJSON(bRefTypeValue, targetType);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execNumericConversionOrCastOpCode(Strand ctx, StackFrame sf, BType targetType, BRefType bRefTypeValue, int regIndex, boolean isRefTypeTarget) {
        BType sourceType = bRefTypeValue.getType();
        int targetTag = targetType.getTag();
        if (targetTag == 20 && ((BUnionType)targetType).getMemberTypes().stream().filter(BVM::isBasicNumericType).count() > 1L || !BVM.isBasicNumericType(sourceType)) {
            ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.TYPE_CAST_ERROR, sourceType, targetType)));
            BVM.handleError(ctx);
            return;
        }
        try {
            switch (targetTag) {
                case 3: {
                    if (isRefTypeTarget) {
                        sf.refRegs[regIndex] = new BFloat(((BValueType)((Object)bRefTypeValue)).floatValue());
                        break;
                    }
                    sf.doubleRegs[regIndex] = ((BValueType)((Object)bRefTypeValue)).floatValue();
                    break;
                }
                case 4: {
                    sf.refRegs[regIndex] = new BDecimal(((BValueType)((Object)bRefTypeValue)).decimalValue());
                    break;
                }
                case 1: {
                    if (isRefTypeTarget) {
                        sf.refRegs[regIndex] = new BInteger(((BValueType)((Object)bRefTypeValue)).intValue());
                        break;
                    }
                    sf.longRegs[regIndex] = ((BValueType)((Object)bRefTypeValue)).intValue();
                    break;
                }
                case 2: {
                    if (isRefTypeTarget) {
                        sf.refRegs[regIndex] = new BByte(((BValueType)((Object)bRefTypeValue)).byteValue());
                        break;
                    }
                    sf.longRegs[regIndex] = ((BValueType)((Object)bRefTypeValue)).byteValue();
                    break;
                }
                default: {
                    BType targetNumericType = ((BUnionType)targetType).getMemberTypes().stream().filter(BVM::isBasicNumericType).findFirst().get();
                    BVM.execNumericConversionOrCastOpCode(ctx, sf, targetNumericType, bRefTypeValue, regIndex, true);
                    break;
                }
            }
        }
        catch (BallerinaException e) {
            ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
            BVM.handleError(ctx);
        }
    }

    private static void execTypeConversionOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 124: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = sf.longRegs[i];
                break;
            }
            case 125: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = Long.toString(sf.longRegs[i]);
                break;
            }
            case 126: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = sf.longRegs[i] != 0L ? 1 : 0;
                break;
            }
            case 127: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BDecimal(new BigDecimal(sf.longRegs[i], MathContext.DECIMAL128).setScale(1, 6));
                break;
            }
            case 207: {
                int i = operands[0];
                int j = operands[1];
                if (!BVM.isByteLiteral(sf.longRegs[i])) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'int' value '" + sf.longRegs[i] + "' cannot be converted to '" + "byte" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[j] = sf.longRegs[i];
                break;
            }
            case 208: {
                int i = operands[0];
                int j = operands[1];
                double floatVal = sf.doubleRegs[i];
                if (Double.isNaN(floatVal) || Double.isInfinite(floatVal)) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'float' value '" + floatVal + "' cannot be converted to '" + "byte" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                long floatAsIntVal = Math.round(floatVal);
                if (!BVM.isByteLiteral(floatAsIntVal)) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'float' value '" + floatVal + "' cannot be converted to '" + "byte" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[j] = floatAsIntVal;
                break;
            }
            case 209: {
                int i = operands[0];
                int j = operands[1];
                DecimalValueKind valueKind = ((BDecimal)sf.refRegs[i]).valueKind;
                if (valueKind == DecimalValueKind.NOT_A_NUMBER || valueKind == DecimalValueKind.NEGATIVE_INFINITY || valueKind == DecimalValueKind.POSITIVE_INFINITY) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + sf.refRegs[i] + "' cannot be converted to '" + "byte" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                long doubleAsIntVal = Math.round(((BDecimal)sf.refRegs[i]).floatValue());
                if (!BVM.isByteLiteral(doubleAsIntVal)) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + sf.refRegs[i] + "' cannot be converted to '" + "byte" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[j] = doubleAsIntVal;
                break;
            }
            case 128: {
                int i = operands[0];
                int j = operands[1];
                double valueToConvert = sf.doubleRegs[i];
                if (Double.isNaN(valueToConvert) || Double.isInfinite(valueToConvert)) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'float' value '" + valueToConvert + "' cannot be converted to '" + "int" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                if (!BVM.isFloatWithinIntRange(valueToConvert)) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "out of range 'float' value '" + valueToConvert + "' cannot be converted to '" + "int" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[j] = Math.round(valueToConvert);
                break;
            }
            case 129: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = Double.toString(sf.doubleRegs[i]);
                break;
            }
            case 130: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = sf.doubleRegs[i] != 0.0 ? 1 : 0;
                break;
            }
            case 131: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BDecimal(new BigDecimal(sf.doubleRegs[i], MathContext.DECIMAL128));
                break;
            }
            case 132: {
                int i = operands[0];
                int j = operands[1];
                String str = sf.stringRegs[i];
                try {
                    sf.refRegs[j] = new BInteger(Long.parseLong(str));
                }
                catch (NumberFormatException e) {
                    BVM.handleTypeConversionError(ctx, sf, j, "string", "int");
                }
                break;
            }
            case 133: {
                int i = operands[0];
                int j = operands[1];
                String str = sf.stringRegs[i];
                try {
                    sf.refRegs[j] = new BFloat(Double.parseDouble(str));
                }
                catch (NumberFormatException e) {
                    BVM.handleTypeConversionError(ctx, sf, j, "string", "float");
                }
                break;
            }
            case 134: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = Boolean.parseBoolean(sf.stringRegs[i]) ? 1 : 0;
                break;
            }
            case 135: {
                int i = operands[0];
                int j = operands[1];
                String str = sf.stringRegs[i];
                try {
                    sf.refRegs[j] = new BDecimal(new BigDecimal(str, MathContext.DECIMAL128));
                }
                catch (NumberFormatException e) {
                    BVM.handleTypeConversionError(ctx, sf, j, "string", "decimal");
                }
                break;
            }
            case 136: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = sf.intRegs[i];
                break;
            }
            case 137: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = sf.intRegs[i];
                break;
            }
            case 138: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.intRegs[i] == 1 ? "true" : "false";
                break;
            }
            case 139: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = sf.intRegs[i] == 1 ? new BDecimal(BigDecimal.ONE.setScale(1, 6)) : new BDecimal(BigDecimal.ZERO.setScale(1, 6));
                break;
            }
            case 140: {
                int i = operands[0];
                int j = operands[1];
                BDecimal decimal = (BDecimal)sf.refRegs[i];
                DecimalValueKind decValueKind = decimal.valueKind;
                if (decValueKind == DecimalValueKind.NOT_A_NUMBER || decValueKind == DecimalValueKind.NEGATIVE_INFINITY || decValueKind == DecimalValueKind.POSITIVE_INFINITY) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'decimal' value '" + sf.refRegs[i] + "' cannot be converted to '" + "int" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                if (!BVM.isDecimalWithinIntRange(decimal.decimalValue())) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "out of range 'decimal' value '" + decimal + "' cannot be converted to '" + "int" + "'"));
                    BVM.handleError(ctx);
                    break;
                }
                sf.longRegs[j] = Math.round(((BDecimal)sf.refRegs[i]).decimalValue().doubleValue());
                break;
            }
            case 141: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = ((BDecimal)sf.refRegs[i]).floatValue();
                break;
            }
            case 142: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.refRegs[i].stringValue();
                break;
            }
            case 143: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = ((BDecimal)sf.refRegs[i]).decimalValue().compareTo(BigDecimal.ZERO) != 0 ? 1 : 0;
                break;
            }
            case 145: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    BVM.handleTypeConversionError(ctx, sf, j, BTypes.typeNull, BTypes.typeXML);
                    break;
                }
                try {
                    sf.refRegs[j] = XMLUtils.tableToXML((BTable)bRefType);
                }
                catch (Exception e) {
                    sf.refRegs[j] = null;
                    BVM.handleTypeConversionError(ctx, sf, j, "table", "xml");
                }
                break;
            }
            case 144: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    BVM.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.refRegs[j] = JSONUtils.toJSON((BTable)bRefType);
                }
                catch (Exception e) {
                    BVM.handleTypeConversionError(ctx, sf, j, "table", "xml");
                }
                break;
            }
            case 146: {
                BVM.convertStructToMap(ctx, operands, sf);
                break;
            }
            case 147: {
                BVM.convertStructToJSON(ctx, operands, sf);
                break;
            }
            case 186: {
                BVM.convertMapToJSON(ctx, operands, sf);
                break;
            }
            case 187: {
                BVM.convertJSONToMap(ctx, operands, sf);
                break;
            }
            case 148: {
                BVM.convertMapToStruct(ctx, operands, sf);
                break;
            }
            case 149: {
                BVM.convertJSONToStruct(ctx, operands, sf);
                break;
            }
            case 221: {
                throw new UnsupportedOperationException();
            }
            case 150: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.refRegs[i].stringValue();
                break;
            }
            case 170: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    sf.stringRegs[j] = BLangConstants.STRING_NULL_VALUE;
                    break;
                }
                sf.stringRegs[j] = bRefType.stringValue();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static boolean isByteLiteral(long longValue) {
        return longValue >= (long)BLangConstants.BBYTE_MIN_VALUE.intValue() && longValue <= (long)BLangConstants.BBYTE_MAX_VALUE.intValue();
    }

    public static boolean isFloatWithinIntRange(double doubleValue) {
        return doubleValue < 9.223372036854776E18 && doubleValue > -9.223372036854776E18;
    }

    public static boolean isDecimalWithinIntRange(BigDecimal decimalValue) {
        return decimalValue.compareTo(BLangConstants.BINT_MAX_VALUE_BIG_DECIMAL_RANGE_MAX) < 0 && decimalValue.compareTo(BLangConstants.BINT_MIN_VALUE_BIG_DECIMAL_RANGE_MIN) > 0;
    }

    private static boolean isDecimalRealNumber(BDecimal decimalValue) {
        return decimalValue.valueKind == DecimalValueKind.ZERO || decimalValue.valueKind == DecimalValueKind.OTHER;
    }

    private static boolean checkDecimalGreaterThan(BDecimal lhsValue, BDecimal rhsValue) {
        switch (lhsValue.valueKind) {
            case POSITIVE_INFINITY: {
                return BVM.isDecimalRealNumber(rhsValue) || rhsValue.valueKind == DecimalValueKind.NEGATIVE_INFINITY;
            }
            case ZERO: 
            case OTHER: {
                return rhsValue.valueKind == DecimalValueKind.NEGATIVE_INFINITY || BVM.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) > 0;
            }
        }
        return false;
    }

    private static boolean checkDecimalGreaterThanOrEqual(BDecimal lhsValue, BDecimal rhsValue) {
        return BVM.checkDecimalGreaterThan(lhsValue, rhsValue) || BVM.isDecimalRealNumber(lhsValue) && BVM.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0;
    }

    private static void execIteratorOperation(Strand ctx, StackFrame sf, Instruction instruction) {
        Instruction.InstructionIteratorNext nextInstruction = (Instruction.InstructionIteratorNext)instruction;
        BIterator iterator = (BIterator)sf.refRegs[nextInstruction.iteratorIndex];
        try {
            if (!Optional.of(iterator).get().hasNext()) {
                sf.refRegs[nextInstruction.retRegs[0]] = null;
                return;
            }
            BValue value = Optional.of(iterator).get().getNext();
            BMap<String, BValue> newMap = new BMap<String, BValue>(nextInstruction.constraintType);
            newMap.put("value", value);
            sf.refRegs[nextInstruction.retRegs[0]] = newMap;
        }
        catch (BallerinaException e) {
            ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), e.getDetail()));
            BVM.handleError(ctx);
        }
    }

    private static void execXMLCreationOpcodes(Strand ctx, StackFrame sf, int opcode, int[] operands) {
        switch (opcode) {
            case 226: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                int l = operands[3];
                BXMLQName startTagName = (BXMLQName)sf.refRegs[j];
                BXMLQName endTagName = (BXMLQName)sf.refRegs[k];
                try {
                    sf.refRegs[i] = XMLUtils.createXMLElement(startTagName, endTagName, sf.stringRegs[l]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, BallerinaErrorReasons.XML_CREATION_ERROR, e.getMessage()));
                    BVM.handleError(ctx);
                }
                break;
            }
            case 227: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[i] = XMLUtils.createXMLComment(sf.stringRegs[j]);
                break;
            }
            case 228: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[i] = XMLUtils.createXMLText(sf.stringRegs[j]);
                break;
            }
            case 229: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.refRegs[i] = XMLUtils.createXMLProcessingInstruction(sf.stringRegs[j], sf.stringRegs[k]);
                break;
            }
            case 230: {
                int i = operands[0];
                int j = operands[1];
                BXML xmlVal = (BXML)sf.refRegs[i];
                BXML child = (BXML)sf.refRegs[j];
                xmlVal.addChildren(child);
                break;
            }
            case 234: {
                int i = operands[0];
                sf.refRegs[i] = new BXMLSequence();
            }
        }
    }

    private static boolean handleVariableLock(Strand strand, BType[] types, int[] pkgRegs, int[] varRegs, int[] fieldRegs, int varCount, String uuid) {
        boolean lockAcquired = true;
        block7: for (int i = 0; i < varCount && lockAcquired; ++i) {
            BType paramType = types[i];
            int pkgIndex = pkgRegs[i];
            int regIndex = varRegs[i];
            switch (paramType.getTag()) {
                case 1: {
                    lockAcquired = strand.programFile.globalMemArea.lockIntField(strand, pkgIndex, regIndex);
                    continue block7;
                }
                case 2: {
                    lockAcquired = strand.programFile.globalMemArea.lockBooleanField(strand, pkgIndex, regIndex);
                    continue block7;
                }
                case 3: {
                    lockAcquired = strand.programFile.globalMemArea.lockFloatField(strand, pkgIndex, regIndex);
                    continue block7;
                }
                case 5: {
                    lockAcquired = strand.programFile.globalMemArea.lockStringField(strand, pkgIndex, regIndex);
                    continue block7;
                }
                case 6: {
                    lockAcquired = strand.programFile.globalMemArea.lockBooleanField(strand, pkgIndex, regIndex);
                    continue block7;
                }
                default: {
                    lockAcquired = strand.programFile.globalMemArea.lockRefField(strand, pkgIndex, regIndex);
                }
            }
        }
        if (varRegs.length <= varCount) {
            return lockAcquired;
        }
        strand.currentFrame.localProps.putIfAbsent(uuid, new Stack());
        Stack lockStack = (Stack)strand.currentFrame.localProps.get(uuid);
        for (int i = 0; i < varRegs.length - varCount && lockAcquired; ++i) {
            int regIndex = varRegs[varCount + i];
            String field = strand.currentFrame.stringRegs[fieldRegs[i]];
            VarLock lock = ((BMap)strand.currentFrame.refRegs[regIndex]).getFieldLock(field);
            lockAcquired = lock.lock(strand);
            if (!lockAcquired) continue;
            lockStack.push(lock);
        }
        return lockAcquired;
    }

    private static void handleVariableUnlock(Strand strand, BType[] types, int[] pkgRegs, int[] varRegs, int varCount, String uuid, boolean hasFieldVar) {
        if (hasFieldVar) {
            Stack lockStack = (Stack)strand.currentFrame.localProps.get(uuid);
            while (!lockStack.isEmpty()) {
                ((VarLock)lockStack.pop()).unlock();
            }
        }
        block8: for (int i = varCount - 1; i > -1; --i) {
            BType paramType = types[i];
            int pkgIndex = pkgRegs[i];
            int regIndex = varRegs[i];
            switch (paramType.getTag()) {
                case 1: {
                    strand.programFile.globalMemArea.unlockIntField(pkgIndex, regIndex);
                    continue block8;
                }
                case 2: {
                    strand.programFile.globalMemArea.unlockBooleanField(pkgIndex, regIndex);
                    continue block8;
                }
                case 3: {
                    strand.programFile.globalMemArea.unlockFloatField(pkgIndex, regIndex);
                    continue block8;
                }
                case 5: {
                    strand.programFile.globalMemArea.unlockStringField(pkgIndex, regIndex);
                    continue block8;
                }
                case 6: {
                    strand.programFile.globalMemArea.unlockBooleanField(pkgIndex, regIndex);
                    continue block8;
                }
                default: {
                    strand.programFile.globalMemArea.unlockRefField(pkgIndex, regIndex);
                }
            }
        }
    }

    private static boolean debug(Strand ctx) {
        Debugger debugger = ctx.programFile.getDebugger();
        if (!debugger.isClientSessionActive()) {
            return false;
        }
        DebugContext debugContext = ctx.getDebugContext();
        if (debugContext.isStrandPaused()) {
            debugContext.setStrandPaused(false);
            return false;
        }
        if (BVM.isIgnorableInstruction(ctx)) {
            return false;
        }
        LineNumberInfo currentExecLine = debugger.getLineNumber(ctx.currentFrame.callableUnitInfo.getPackageInfo().getPkgPath(), ctx.currentFrame.ip);
        if (currentExecLine.equals(debugContext.getLastLine())) {
            return false;
        }
        if (BVM.debugPointCheck(ctx, currentExecLine, debugger)) {
            return true;
        }
        switch (debugContext.getCurrentCommand()) {
            case RESUME: {
                debugContext.clearContext();
                break;
            }
            case STEP_IN: {
                BVM.debugHit(ctx, currentExecLine, debugger);
                return true;
            }
            case STEP_OVER: {
                if (debugContext.getFramePointer() < ctx.fp) {
                    return false;
                }
                BVM.debugHit(ctx, currentExecLine, debugger);
                return true;
            }
            case STEP_OUT: {
                if (debugContext.getFramePointer() > ctx.fp) {
                    BVM.debugHit(ctx, currentExecLine, debugger);
                    return true;
                }
                return false;
            }
            default: {
                debugger.notifyExit();
                debugger.stopDebugging();
            }
        }
        return false;
    }

    private static boolean isIgnorableInstruction(Strand ctx) {
        int opcode = ctx.currentFrame.code[ctx.currentFrame.ip].getOpcode();
        return opcode == 116;
    }

    private static boolean debugPointCheck(Strand ctx, LineNumberInfo currentExecLine, Debugger debugger) {
        if (!currentExecLine.isDebugPoint()) {
            return false;
        }
        BVM.debugHit(ctx, currentExecLine, debugger);
        return true;
    }

    private static void debugHit(Strand ctx, LineNumberInfo currentExecLine, Debugger debugger) {
        ctx.getDebugContext().updateContext(currentExecLine, ctx.fp);
        debugger.pauseWorker(ctx);
        debugger.notifyDebugHit(ctx, currentExecLine, ctx.getId());
    }

    private static void handleAnyToRefTypeCast(Strand ctx, StackFrame sf, int[] operands, BType targetType) {
        int i = operands[0];
        int j = operands[1];
        BRefType<?> bRefType = sf.refRegs[i];
        if (bRefType == null) {
            sf.refRegs[j] = null;
        } else if (bRefType.getType() == targetType) {
            sf.refRegs[j] = bRefType;
        } else {
            BVM.handleTypeCastError(ctx, sf, j, bRefType.getType(), targetType);
        }
    }

    private static void handleTypeCastError(Strand ctx, StackFrame sf, int errorRegIndex, BType sourceType, BType targetType) {
        BVM.handleTypeCastError(ctx, sf, errorRegIndex, sourceType.toString(), targetType.toString());
    }

    private static void handleTypeCastError(Strand ctx, StackFrame sf, int errorRegIndex, String sourceType, String targetType) {
        BError errorVal;
        sf.refRegs[errorRegIndex] = errorVal = BLangVMErrors.createTypeCastError(ctx, sourceType, targetType);
    }

    private static void handleTypeConversionError(Strand ctx, StackFrame sf, int errorRegIndex, BType sourceType, BType targetType) {
        BVM.handleTypeConversionError(ctx, sf, errorRegIndex, sourceType.toString(), targetType.toString());
    }

    private static void handleTypeConversionError(Strand ctx, StackFrame sf, int errorRegIndex, String sourceTypeName, String targetTypeName) {
        String errorMsg = "'" + sourceTypeName + "' cannot be converted to '" + targetTypeName + "'";
        BVM.handleTypeConversionError(ctx, sf, errorRegIndex, errorMsg);
    }

    private static void handleTypeConversionError(Strand ctx, StackFrame sf, int errorRegIndex, String errorMessage) {
        BError errorVal;
        sf.refRegs[errorRegIndex] = errorVal = BLangVMErrors.createTypeConversionError(ctx, errorMessage);
    }

    private static void createNewIntRange(int[] operands, StackFrame sf) {
        long startValue = sf.longRegs[operands[0]];
        long endValue = sf.longRegs[operands[1]];
        sf.refRegs[operands[2]] = new BIntRange(startValue, endValue);
    }

    private static void createNewStruct(int[] operands, StackFrame sf) {
        int cpIndex = operands[0];
        int i = operands[1];
        StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)sf.constPool[cpIndex];
        StructureTypeInfo structInfo = (StructureTypeInfo)((TypeDefInfo)structureRefCPEntry.getStructureTypeInfo()).typeInfo;
        sf.refRegs[i] = new BMap(structInfo.getType());
    }

    private static void beginTransaction(Strand strand, int transactionType, int transactionBlockIdIndex, int retryCountRegIndex, int committedFuncIndex, int abortedFuncIndex) {
        if (transactionType == Transactions.TransactionType.PARTICIPANT.value) {
            BVM.beginTransactionLocalParticipant(strand, transactionBlockIdIndex, committedFuncIndex, abortedFuncIndex);
            return;
        }
        if (transactionType == Transactions.TransactionType.REMOTE_PARTICIPANT.value) {
            BVM.beginRemoteParticipant(strand, transactionBlockIdIndex, committedFuncIndex, abortedFuncIndex);
            return;
        }
        int retryCount = 3;
        if (retryCountRegIndex != -1 && (retryCount = (int)strand.currentFrame.longRegs[retryCountRegIndex]) < 0) {
            strand.setError(BLangVMErrors.createError(strand, BallerinaErrorReasons.TRANSACTION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RETRY_COUNT, new Object[0])));
            BVM.handleError(strand);
            return;
        }
        if (strand.getLocalTransactionContext() != null) {
            BVM.createAndSetDynamicNestedTrxError(strand);
            BVM.handleError(strand);
            return;
        }
        String transactionBlockId = BVM.getTrxBlockIdFromCP(strand, transactionBlockIdIndex);
        TransactionLocalContext transactionLocalContext = BVM.createAndNotifyGlobalTx(strand, transactionBlockId);
        strand.setLocalTransactionContext(transactionLocalContext);
        transactionLocalContext.beginTransactionBlock(transactionBlockId, retryCount);
    }

    private static void beginRemoteParticipant(Strand strand, int transactionBlockIdIndex, int committedFuncIndex, int abortedFuncIndex) {
        TransactionLocalContext localTransactionContext = strand.getLocalTransactionContext();
        if (localTransactionContext == null) {
            return;
        }
        BFunctionPointer fpCommitted = null;
        if (committedFuncIndex != -1) {
            FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)strand.currentFrame.constPool[committedFuncIndex];
            fpCommitted = new BFunctionPointer(funcRefCPEntry.getFunctionInfo());
        }
        BFunctionPointer fpAborted = null;
        if (abortedFuncIndex != -1) {
            FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)strand.currentFrame.constPool[abortedFuncIndex];
            fpAborted = new BFunctionPointer(funcRefCPEntry.getFunctionInfo());
        }
        String transactionBlockId = BVM.getTrxBlockIdFromCP(strand, transactionBlockIdIndex);
        localTransactionContext.setResourceParticipant(true);
        String globalTransactionId = localTransactionContext.getGlobalTransactionId();
        localTransactionContext.beginTransactionBlock(transactionBlockId, -1);
        TransactionResourceManager.getInstance().registerParticipation(globalTransactionId, transactionBlockId, fpCommitted, fpAborted, strand);
        strand.currentFrame.trxParticipant = StackFrame.TransactionParticipantType.REMOTE_PARTICIPANT;
    }

    private static void createAndSetDynamicNestedTrxError(Strand strand) {
        BError error = BLangVMErrors.createError(strand, BallerinaErrorReasons.TRANSACTION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_DYNAMICALLY_NESTED_TRANSACTION, new Object[0]));
        strand.setError(error);
    }

    private static void beginTransactionLocalParticipant(Strand strand, int transactionBlockIdCpIndex, int committedFuncIndex, int abortedFuncIndex) {
        TransactionLocalContext transactionLocalContext = strand.getLocalTransactionContext();
        if (transactionLocalContext == null) {
            return;
        }
        String transactionBlockId = BVM.getTrxBlockIdFromCP(strand, transactionBlockIdCpIndex);
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        BFunctionPointer fpCommitted = null;
        if (committedFuncIndex != -1) {
            FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)strand.currentFrame.constPool[committedFuncIndex];
            fpCommitted = new BFunctionPointer(funcRefCPEntry.getFunctionInfo());
            transactionResourceManager.registerCommittedFunction(transactionBlockId, fpCommitted);
        }
        BFunctionPointer fpAborted = null;
        if (abortedFuncIndex != -1) {
            FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)strand.currentFrame.constPool[abortedFuncIndex];
            fpAborted = new BFunctionPointer(funcRefCPEntry.getFunctionInfo());
            transactionResourceManager.registerAbortedFunction(transactionBlockId, fpAborted);
        }
        transactionLocalContext.beginTransactionBlock(transactionBlockId, 1);
        transactionResourceManager.registerParticipation(transactionLocalContext.getGlobalTransactionId(), transactionBlockId, fpCommitted, fpAborted, strand);
        strand.currentFrame.trxParticipant = StackFrame.TransactionParticipantType.LOCAL_PARTICIPANT;
    }

    private static String getTrxBlockIdFromCP(Strand strand, int index) {
        StringCPEntry stringCPEntry = (StringCPEntry)strand.currentFrame.constPool[index];
        return stringCPEntry.getValue();
    }

    private static TransactionLocalContext createAndNotifyGlobalTx(Strand ctx, String transactionBlockId) {
        BValue[] txResult = TransactionUtils.notifyTransactionBegin(ctx, null, null, transactionBlockId, "2pc");
        BMap txDataStruct = (BMap)txResult[0];
        String globalTransactionId = txDataStruct.get("transactionId").stringValue();
        String url = txDataStruct.get("registerAtURL").stringValue();
        String protocol = txDataStruct.get("coordinationType").stringValue();
        return TransactionLocalContext.create(globalTransactionId, url, protocol);
    }

    private static TransactionLocalContext createLocalOnlyTransaction() {
        String globalTransactionId = UUID.randomUUID().toString().replaceAll("-", "");
        return TransactionLocalContext.create(globalTransactionId, null, null);
    }

    private static void retryTransaction(Strand strand, int transactionBlockIdCpIndex, int trAbortEndIp, int trEndStatusReg) {
        strand.currentFrame.intRegs[trEndStatusReg] = 0;
        TransactionLocalContext transactionLocalContext = strand.getLocalTransactionContext();
        transactionLocalContext.getAndClearFailure();
        String transactionBlockId = BVM.getTrxBlockIdFromCP(strand, transactionBlockIdCpIndex);
        if (transactionLocalContext.isRetryPossible(strand, transactionBlockId)) {
            if (transactionLocalContext.isRetryAttempt(transactionBlockId)) {
                TransactionLocalContext newLocalTransaction = BVM.createAndNotifyGlobalTx(strand, transactionBlockId);
                int allowedRetryCount = transactionLocalContext.getAllowedRetryCount(transactionBlockId);
                newLocalTransaction.beginTransactionBlock(transactionBlockId, allowedRetryCount - 1);
                strand.setLocalTransactionContext(newLocalTransaction);
            }
            strand.getLocalTransactionContext().incrementCurrentRetryCount(transactionBlockId);
            strand.setError(null);
            return;
        }
        strand.currentFrame.intRegs[trEndStatusReg] = 1;
        strand.currentFrame.ip = trAbortEndIp;
    }

    private static void endTransaction(Strand strand, int transactionBlockIdCpIndex, int endType, int statusRegIndex, int errorRegIndex) {
        TransactionLocalContext localTxInfo = strand.getLocalTransactionContext();
        String txBlockId = BVM.getTrxBlockIdFromCP(strand, transactionBlockIdCpIndex);
        try {
            switch (Transactions.TransactionStatus.getConst((int)endType)) {
                case BLOCK_END: {
                    BVM.transactionBlockEnd(strand, txBlockId, statusRegIndex, localTxInfo, errorRegIndex);
                    break;
                }
                case FAILED: {
                    BVM.transactionFailedEnd(strand, txBlockId, localTxInfo, statusRegIndex);
                    break;
                }
                case ABORTED: {
                    BVM.transactionAbortedEnd(strand, txBlockId, localTxInfo, statusRegIndex, errorRegIndex);
                    break;
                }
                case END: {
                    BVM.transactionEndEnd(strand, txBlockId, localTxInfo);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transaction end endType: " + endType);
                }
            }
        }
        catch (Throwable e) {
            strand.setError(BLangVMErrors.createError(strand, BallerinaErrorReasons.TRANSACTION_ERROR, e.getMessage()));
            BVM.handleError(strand);
        }
    }

    private static void transactionAbortedEnd(Strand strand, String txBlockId, TransactionLocalContext localTxInfo, int statusRegIndex, int errorRegIndex) {
        if (strand.currentFrame.intRegs[statusRegIndex] == 0) {
            BVM.notifyTransactionAbort(strand, txBlockId, localTxInfo);
        }
        BVM.setErrorRethrowReg(strand, statusRegIndex, errorRegIndex);
    }

    private static void setErrorRethrowReg(Strand strand, int statusRegIndex, int errorRegIndex) {
        if (strand.getError() != null) {
            BError cause = strand.getError();
            if (cause != null) {
                strand.setError(cause);
                strand.currentFrame.refRegs[errorRegIndex] = cause;
            }
            strand.currentFrame.intRegs[statusRegIndex] = 1;
            return;
        }
        strand.currentFrame.intRegs[statusRegIndex] = 0;
    }

    private static void transactionEndEnd(Strand strand, String transactionBlockId, TransactionLocalContext transactionLocalContext) {
        boolean isOuterTx = transactionLocalContext.onTransactionEnd(transactionBlockId);
        strand.removeLocalTransactionContext();
    }

    private static void transactionBlockEnd(Strand strand, String transactionBlockId, int statusRegIndex, TransactionLocalContext transactionLocalContext, int errorRegIndex) {
        TransactionLocalContext.TransactionFailure failure = transactionLocalContext.getFailure();
        BError error = null;
        BRefType<?> errorVal = strand.currentFrame.refRegs[errorRegIndex];
        if (errorVal != null && errorVal.getType().getTag() == 27) {
            error = (BError)errorVal;
        }
        if (error != null && strand.getError() == null) {
            strand.setError(error);
            strand.currentFrame.refRegs[errorRegIndex] = null;
        }
        if (failure == null && error == null && strand.getError() == null) {
            strand.currentFrame.intRegs[statusRegIndex] = 0;
            TransactionUtils.CoordinatorCommit coordinatorStatus = BVM.notifyGlobalPrepareAndCommit(strand, transactionBlockId, transactionLocalContext);
            if (!TransactionUtils.CoordinatorCommit.COMMITTED.equals((Object)coordinatorStatus)) {
                strand.currentFrame.intRegs[statusRegIndex] = 1;
            }
        } else {
            boolean notifyCoordinator;
            strand.currentFrame.intRegs[statusRegIndex] = 1;
            if (failure == null) {
                transactionLocalContext.markFailure();
            }
            if (notifyCoordinator = transactionLocalContext.onTransactionFailed(strand, transactionBlockId)) {
                BVM.notifyTransactionAbort(strand, transactionBlockId, transactionLocalContext);
            }
        }
    }

    private static TransactionUtils.CoordinatorCommit notifyGlobalPrepareAndCommit(Strand ctx, String transactionBlockId, TransactionLocalContext transactionLocalContext) {
        return TransactionUtils.notifyTransactionEnd(ctx, transactionLocalContext.getGlobalTransactionId(), transactionBlockId);
    }

    private static void notifyTransactionAbort(Strand strand, String transactionBlockId, TransactionLocalContext transactionLocalContext) {
        TransactionUtils.notifyTransactionAbort(strand, transactionLocalContext.getGlobalTransactionId(), transactionBlockId);
        TransactionResourceManager.getInstance().notifyAbort(transactionLocalContext.getGlobalTransactionId(), transactionBlockId, false);
    }

    private static void transactionFailedEnd(Strand strand, String transactionBlockId, TransactionLocalContext transactionLocalContext, int runOnRetryBlockRegIndex) {
        strand.currentFrame.intRegs[runOnRetryBlockRegIndex] = transactionLocalContext.isRetryPossible(strand, transactionBlockId) ? 1 : 0;
    }

    private static Strand invokeVirtualFunction(Strand ctx, StackFrame sf, int receiver, FunctionInfo virtualFuncInfo, int[] argRegs, int retReg, int flags) {
        BMap structVal = (BMap)sf.refRegs[receiver];
        StructureTypeInfo structInfo = (StructureTypeInfo)((BStructureType)structVal.getType()).getTypeInfo();
        FunctionInfo attachedFuncInfo = structInfo.funcInfoEntries.get(virtualFuncInfo.getName());
        return BVM.invokeCallable(ctx, attachedFuncInfo, argRegs, retReg, flags);
    }

    private static void handleWorkerSend(Strand ctx, WorkerDataChannelInfo workerDataChannelInfo, BType type, int reg, boolean channelInSameStrand) {
        BRefType val = BVM.extractValue(ctx.currentFrame, type, reg);
        WorkerDataChannel dataChannel = BVM.getWorkerChannel(ctx, workerDataChannelInfo.getChannelName(), channelInSameStrand);
        dataChannel.sendData(val);
    }

    private static WorkerDataChannel getWorkerChannel(Strand ctx, String name, boolean channelInSameStrand) {
        if (channelInSameStrand) {
            return ctx.currentFrame.wdChannels.getWorkerDataChannel(name);
        }
        if (ctx.fp > 0) {
            return ctx.peekFrame((int)1).wdChannels.getWorkerDataChannel(name);
        }
        return ctx.respCallback.parentChannels.getWorkerDataChannel(name);
    }

    private static BRefType extractValue(StackFrame data, BType type, int reg) {
        BValueType result;
        switch (type.getTag()) {
            case 1: {
                result = new BInteger(data.longRegs[reg]);
                break;
            }
            case 2: {
                result = new BByte(data.longRegs[reg]);
                break;
            }
            case 3: {
                result = new BFloat(data.doubleRegs[reg]);
                break;
            }
            case 5: {
                result = new BString(data.stringRegs[reg]);
                break;
            }
            case 6: {
                result = new BBoolean(data.intRegs[reg] > 0);
                break;
            }
            default: {
                result = data.refRegs[reg];
            }
        }
        return result;
    }

    private static boolean handleWorkerReceive(Strand ctx, WorkerDataChannelInfo workerDataChannelInfo, BType type, int reg, boolean channelInSameStrand) {
        return BVM.getWorkerChannel(ctx, workerDataChannelInfo.getChannelName(), channelInSameStrand).tryTakeData(ctx, type, reg);
    }

    public static void copyArgValueForWorkerReceive(StackFrame currentSF, int regIndex, BType paramType, BRefType passedInValue) {
        switch (paramType.getTag()) {
            case 1: {
                currentSF.longRegs[regIndex] = ((BInteger)passedInValue).intValue();
                break;
            }
            case 2: {
                currentSF.longRegs[regIndex] = ((BByte)passedInValue).byteValue();
                break;
            }
            case 3: {
                currentSF.doubleRegs[regIndex] = ((BFloat)passedInValue).floatValue();
                break;
            }
            case 5: {
                currentSF.stringRegs[regIndex] = passedInValue.stringValue();
                break;
            }
            case 6: {
                currentSF.intRegs[regIndex] = ((BBoolean)passedInValue).booleanValue() ? 1 : 0;
                break;
            }
            default: {
                currentSF.refRegs[regIndex] = passedInValue;
            }
        }
    }

    private static boolean checkFiniteTypeAssignable(BValue bRefTypeValue, BType lhsType) {
        BFiniteType fType = (BFiniteType)lhsType;
        if (bRefTypeValue == null) {
            return false;
        }
        for (BValue valueSpaceItem : fType.valueSpace) {
            if (valueSpaceItem.getType().getTag() != bRefTypeValue.getType().getTag() || !valueSpaceItem.equals(bRefTypeValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkUnionCast(BValue rhsValue, BType lhsType, List<TypePair> unresolvedTypes) {
        BUnionType unionType = (BUnionType)lhsType;
        for (BType memberType : unionType.getMemberTypes()) {
            if (!BVM.checkCast(rhsValue, memberType, unresolvedTypes)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCast(BValue rhsValue, BType lhsType) {
        return BVM.checkCast(rhsValue, lhsType, new ArrayList<TypePair>());
    }

    private static boolean checkCast(BValue rhsValue, BType lhsType, List<TypePair> unresolvedTypes) {
        BType rhsType;
        BType bType = rhsType = rhsValue == null ? BTypes.typeNull : rhsValue.getType();
        if (BVM.isSameOrAnyType(rhsType, lhsType)) {
            return true;
        }
        if (rhsType.getTag() == 1 && lhsType.getTag() == 2) {
            return BVM.isByteLiteral(((BInteger)rhsValue).intValue());
        }
        if (lhsType.getTag() == 20) {
            return BVM.checkUnionCast(rhsValue, lhsType, unresolvedTypes);
        }
        if (BVM.getElementType(rhsType).getTag() == 7) {
            return BVM.checkJSONCast(rhsValue, rhsType, lhsType);
        }
        if (lhsType.getTag() == 19 && rhsValue instanceof BNewArray) {
            BType sourceType = rhsValue.getType();
            if (sourceType.getTag() == 19) {
                if (((BArrayType)sourceType).getState() == BArrayState.CLOSED_SEALED && ((BArrayType)lhsType).getState() == BArrayState.CLOSED_SEALED && ((BArrayType)sourceType).getSize() != ((BArrayType)lhsType).getSize()) {
                    return false;
                }
                sourceType = ((BArrayType)rhsValue.getType()).getElementType();
            }
            return BVM.checkArrayCast(sourceType, ((BArrayType)lhsType).getElementType(), unresolvedTypes);
        }
        if (rhsType.getTag() == 29 && lhsType.getTag() == 29) {
            return BVM.checkTupleCast(rhsValue, lhsType, unresolvedTypes);
        }
        if (lhsType.getTag() == 32) {
            return BVM.checkFiniteTypeAssignable(rhsValue, lhsType);
        }
        return BVM.checkCastByType(rhsType, lhsType, unresolvedTypes);
    }

    private static boolean isSameOrAnyType(BType rhsType, BType lhsType) {
        return lhsType.getTag() == 17 && rhsType.getTag() != 27 || rhsType.equals(lhsType);
    }

    private static boolean checkCastByType(BType rhsType, BType lhsType, List<TypePair> unresolvedTypes) {
        if (rhsType.getTag() == 1 && (lhsType.getTag() == 3 || lhsType.getTag() == 4)) {
            return true;
        }
        if (rhsType.getTag() == 3 && lhsType.getTag() == 4) {
            return true;
        }
        if (rhsType.getTag() == 2 && lhsType.getTag() == 1) {
            return true;
        }
        if (lhsType.getTag() == 7) {
            switch (rhsType.getTag()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    return true;
                }
                case 15: {
                    return BVM.checkCastByType(((BMapType)rhsType).getConstrainedType(), lhsType, unresolvedTypes);
                }
                case 19: {
                    return BVM.checkCastByType(((BArrayType)rhsType).getElementType(), lhsType, unresolvedTypes);
                }
            }
            return false;
        }
        if (rhsType.getTag() == 33 && lhsType.getTag() == 33) {
            return BVM.checkObjectEquivalency((BStructureType)rhsType, (BStructureType)lhsType, unresolvedTypes);
        }
        if (rhsType.getTag() == 12 && lhsType.getTag() == 12) {
            return BVM.checkRecordEquivalency((BRecordType)lhsType, (BRecordType)rhsType, unresolvedTypes);
        }
        if (rhsType.getTag() == 15 && lhsType.getTag() == 15) {
            return BVM.checkMapCast(rhsType, lhsType, unresolvedTypes);
        }
        if (rhsType.getTag() == 9 && lhsType.getTag() == 9) {
            return true;
        }
        if (rhsType.getTag() == 14 && lhsType.getTag() == 14) {
            return BVM.isAssignable(((BStreamType)rhsType).getConstrainedType(), ((BStreamType)lhsType).getConstrainedType(), unresolvedTypes);
        }
        if (rhsType.getTag() == 35 && lhsType.getTag() == 35) {
            return BVM.checkFunctionCast(rhsType, (BFunctionType)lhsType);
        }
        return lhsType.getTag() == 11 && BVM.isAnydata(rhsType);
    }

    private static boolean checkMapCast(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        BMapType sourceMapType = (BMapType)sourceType;
        BMapType targetMapType = (BMapType)targetType;
        if (sourceMapType.equals(targetMapType)) {
            return true;
        }
        if (targetMapType.getConstrainedType().getTag() == 17) {
            return true;
        }
        if (sourceMapType.getConstrainedType().getTag() == 33 && targetMapType.getConstrainedType().getTag() == 33) {
            return BVM.checkObjectEquivalency((BStructureType)sourceMapType.getConstrainedType(), (BStructureType)targetMapType.getConstrainedType(), unresolvedTypes);
        }
        if (sourceMapType.getConstrainedType().getTag() == 12 && targetMapType.getConstrainedType().getTag() == 12) {
            return BVM.checkRecordEquivalency((BRecordType)targetMapType.getConstrainedType(), (BRecordType)sourceMapType.getConstrainedType(), unresolvedTypes);
        }
        return false;
    }

    private static boolean checkArrayCast(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        if (targetType.getTag() == 19 && sourceType.getTag() == 19) {
            BArrayType sourceArrayType = (BArrayType)sourceType;
            BArrayType targetArrayType = (BArrayType)targetType;
            if (targetArrayType.getDimensions() > sourceArrayType.getDimensions()) {
                return false;
            }
            return BVM.checkArrayCast(sourceArrayType.getElementType(), targetArrayType.getElementType(), unresolvedTypes);
        }
        if (targetType.getTag() == 20) {
            return BVM.checkUnionAssignable(sourceType, targetType, unresolvedTypes);
        }
        if (targetType.getTag() == 17) {
            return true;
        }
        return sourceType.equals(targetType);
    }

    private static boolean checkTupleCast(BValue sourceValue, BType targetType, List<TypePair> unresolvedTypes) {
        BValueArray source = (BValueArray)sourceValue;
        BTupleType target = (BTupleType)targetType;
        List<BType> targetTupleTypes = target.getTupleTypes();
        if (source.size() != (long)targetTupleTypes.size()) {
            return false;
        }
        int i = 0;
        while ((long)i < source.size()) {
            if (!BVM.checkCast(source.getBValue(i), targetTupleTypes.get(i), unresolvedTypes)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAnydata(BType type) {
        return BVM.isAnydata(type, new HashSet<BType>());
    }

    private static boolean isAnydata(BType type, Set<BType> unresolvedTypes) {
        if (type.getTag() <= 11) {
            return true;
        }
        switch (type.getTag()) {
            case 15: {
                return BVM.isPureType(((BMapType)type).getConstrainedType(), unresolvedTypes);
            }
            case 12: {
                if (unresolvedTypes.contains(type)) {
                    return true;
                }
                unresolvedTypes.add(type);
                BRecordType recordType = (BRecordType)type;
                List<BType> fieldTypes = recordType.getFields().values().stream().map(BField::getFieldType).collect(Collectors.toList());
                return BVM.isPureType(fieldTypes, unresolvedTypes) && (recordType.sealed || BVM.isPureType(recordType.restFieldType, unresolvedTypes));
            }
            case 20: {
                return BVM.isAnydata(((BUnionType)type).getMemberTypes(), unresolvedTypes);
            }
            case 29: {
                return BVM.isPureType(((BTupleType)type).getTupleTypes(), unresolvedTypes);
            }
            case 19: {
                return BVM.isPureType(((BArrayType)type).getElementType(), unresolvedTypes);
            }
            case 32: {
                Set<BType> valSpaceTypes = ((BFiniteType)type).valueSpace.stream().map(BValue::getType).collect(Collectors.toSet());
                return BVM.isAnydata(valSpaceTypes, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean isAnydata(Collection<BType> types, Set<BType> unresolvedTypes) {
        return types.stream().allMatch(bType -> BVM.isAnydata(bType, unresolvedTypes));
    }

    public static boolean isPureType(BType type) {
        return BVM.isPureType(type, new HashSet<BType>());
    }

    private static boolean isPureType(BType type, Set<BType> unresolvedTypes) {
        if (type.getTag() == 20) {
            return ((BUnionType)type).getMemberTypes().stream().allMatch(memType -> BVM.isPureType(memType, unresolvedTypes));
        }
        return type.getTag() == 27 || BVM.isAnydata(type, unresolvedTypes);
    }

    private static boolean isPureType(Collection<BType> types, Set<BType> unresolvedTypes) {
        return types.stream().allMatch(bType -> BVM.isPureType(bType, unresolvedTypes));
    }

    private static BType getElementType(BType type) {
        if (type.getTag() != 19) {
            return type;
        }
        return BVM.getElementType(((BArrayType)type).getElementType());
    }

    public static boolean checkStructEquivalency(BStructureType rhsType, BStructureType lhsType) {
        return BVM.checkObjectEquivalency(rhsType, lhsType, new ArrayList<TypePair>());
    }

    private static boolean checkObjectEquivalency(BStructureType rhsType, BStructureType lhsType, List<TypePair> unresolvedTypes) {
        int lhsAttachedFunctionCount;
        TypePair pair = new TypePair(rhsType, lhsType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        if (Flags.isFlagOn(lhsType.flags ^ rhsType.flags, 1)) {
            return false;
        }
        if (!Flags.isFlagOn(lhsType.flags, 1) && !rhsType.getPackagePath().equals(lhsType.getPackagePath())) {
            return false;
        }
        int n = lhsAttachedFunctionCount = lhsType.initializer != null ? lhsType.getAttachedFunctions().length - 1 : lhsType.getAttachedFunctions().length;
        if (lhsType.getFields().size() > rhsType.getFields().size() || lhsAttachedFunctionCount > rhsType.getAttachedFunctions().length) {
            return false;
        }
        return !Flags.isFlagOn(lhsType.flags, 1) && rhsType.getPackagePath().equals(lhsType.getPackagePath()) ? BVM.checkPrivateObjectsEquivalency(lhsType, rhsType, unresolvedTypes) : BVM.checkPublicObjectsEquivalency(lhsType, rhsType, unresolvedTypes);
    }

    public static boolean checkRecordEquivalency(BRecordType lhsType, BRecordType rhsType, List<TypePair> unresolvedTypes) {
        if (Flags.isFlagOn(lhsType.flags ^ rhsType.flags, 1)) {
            return false;
        }
        if (!Flags.isFlagOn(lhsType.flags, 1) && !rhsType.getPackagePath().equals(lhsType.getPackagePath())) {
            return false;
        }
        if (lhsType.sealed && !rhsType.sealed) {
            return false;
        }
        if (!rhsType.sealed && !BVM.isAssignable(rhsType.restFieldType, lhsType.restFieldType, unresolvedTypes)) {
            return false;
        }
        return BVM.checkFieldEquivalency(lhsType, rhsType, unresolvedTypes);
    }

    private static boolean checkPrivateObjectsEquivalency(BStructureType lhsType, BStructureType rhsType, List<TypePair> unresolvedTypes) {
        Map<String, BField> rhsFields = rhsType.getFields();
        for (Map.Entry<String, BField> lhsFieldEntry : lhsType.getFields().entrySet()) {
            BField rhsField = rhsFields.get(lhsFieldEntry.getKey());
            if (rhsField != null && BVM.isSameType(rhsField.fieldType, lhsFieldEntry.getValue().fieldType)) continue;
            return false;
        }
        BAttachedFunction[] lhsFuncs = lhsType.getAttachedFunctions();
        BAttachedFunction[] rhsFuncs = rhsType.getAttachedFunctions();
        for (BAttachedFunction lhsFunc : lhsFuncs) {
            BAttachedFunction rhsFunc;
            if (lhsFunc == lhsType.initializer || lhsFunc == lhsType.defaultsValuesInitFunc || (rhsFunc = BVM.getMatchingInvokableType(rhsFuncs, lhsFunc, unresolvedTypes)) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPublicObjectsEquivalency(BStructureType lhsType, BStructureType rhsType, List<TypePair> unresolvedTypes) {
        if (rhsType.getFields().values().stream().anyMatch(field -> !Flags.isFlagOn(field.flags, 1))) {
            return false;
        }
        Map<String, BField> rhsFields = rhsType.getFields();
        for (Map.Entry<String, BField> lhsFieldEntry : lhsType.getFields().entrySet()) {
            BField rhsField = rhsFields.get(lhsFieldEntry.getKey());
            if (rhsField != null && Flags.isFlagOn(lhsFieldEntry.getValue().flags, 1) && BVM.isSameType(rhsField.fieldType, lhsFieldEntry.getValue().fieldType)) continue;
            return false;
        }
        BAttachedFunction[] lhsFuncs = lhsType.getAttachedFunctions();
        BAttachedFunction[] rhsFuncs = rhsType.getAttachedFunctions();
        for (BAttachedFunction lhsFunc : lhsFuncs) {
            if (lhsFunc == lhsType.initializer || lhsFunc == lhsType.defaultsValuesInitFunc) continue;
            if (!Flags.isFlagOn(lhsFunc.flags, 1)) {
                return false;
            }
            BAttachedFunction rhsFunc = BVM.getMatchingInvokableType(rhsFuncs, lhsFunc, unresolvedTypes);
            if (rhsFunc != null && Flags.isFlagOn(rhsFunc.flags, 1)) continue;
            return false;
        }
        for (BAttachedFunction rhsFunc : rhsFuncs) {
            if (Flags.isFlagOn(rhsFunc.flags, 1)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFieldEquivalency(BRecordType lhsType, BRecordType rhsType, List<TypePair> unresolvedTypes) {
        Map<String, BField> rhsFields = rhsType.getFields();
        Set<String> lhsFieldNames = lhsType.getFields().keySet();
        for (BField lhsField : lhsType.getFields().values()) {
            BField rhsField = rhsFields.get(lhsField.fieldName);
            if (!Flags.isFlagOn(lhsField.flags, 8192) && (rhsField == null || Flags.isFlagOn(rhsField.flags, 8192))) {
                return false;
            }
            if (rhsField != null && BVM.isAssignable(rhsField.fieldType, lhsField.fieldType, unresolvedTypes)) continue;
            return false;
        }
        if (lhsType.sealed) {
            return lhsFieldNames.containsAll(rhsFields.keySet());
        }
        return rhsFields.values().stream().filter(field -> !lhsFieldNames.contains(field.fieldName)).allMatch(field -> BVM.isAssignable(field.fieldType, lhsType.restFieldType, unresolvedTypes));
    }

    private static boolean checkFunctionTypeEqualityForObjectType(BFunctionType source, BFunctionType target, List<TypePair> unresolvedTypes) {
        int i;
        if (source.paramTypes.length != target.paramTypes.length || source.retParamTypes.length != target.retParamTypes.length) {
            return false;
        }
        for (i = 0; i < source.paramTypes.length; ++i) {
            if (BVM.isAssignable(source.paramTypes[i], target.paramTypes[i], unresolvedTypes)) continue;
            return false;
        }
        if (source.retParamTypes == null && target.retParamTypes == null) {
            return true;
        }
        if (source.retParamTypes == null || target.retParamTypes == null) {
            return false;
        }
        for (i = 0; i < source.retParamTypes.length; ++i) {
            if (BVM.isAssignable(source.retParamTypes[i], target.retParamTypes[i], unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static BAttachedFunction getMatchingInvokableType(BAttachedFunction[] rhsFuncs, BAttachedFunction lhsFunc, List<TypePair> unresolvedTypes) {
        return Arrays.stream(rhsFuncs).filter(rhsFunc -> lhsFunc.funcName.equals(rhsFunc.funcName)).filter(rhsFunc -> BVM.checkFunctionTypeEqualityForObjectType(rhsFunc.type, lhsFunc.type, unresolvedTypes)).findFirst().orElse(null);
    }

    private static boolean isSameType(BType rhsType, BType lhsType) {
        if (rhsType == lhsType || rhsType.equals(lhsType)) {
            return true;
        }
        if (rhsType.getTag() == lhsType.getTag() && rhsType.getTag() == 19) {
            return BVM.checkArrayEquivalent(rhsType, lhsType);
        }
        if (rhsType.getTag() == 15 && lhsType.getTag() == 15) {
            return lhsType.equals(rhsType);
        }
        return false;
    }

    private static boolean checkArrayEquivalent(BType actualType, BType expType) {
        if (expType.getTag() == 19 && actualType.getTag() == 19) {
            BArrayType lhrArrayType = (BArrayType)expType;
            BArrayType rhsArrayType = (BArrayType)actualType;
            return BVM.checkArrayEquivalent(lhrArrayType.getElementType(), rhsArrayType.getElementType());
        }
        return expType == actualType;
    }

    private static boolean checkJSONCast(BValue json, BType sourceType, BType targetType) {
        switch (targetType.getTag()) {
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                return json != null && json.getType().getTag() == targetType.getTag();
            }
            case 4: {
                return json != null && json.getType().getTag() == 3;
            }
            case 19: {
                if (json == null || json.getType().getTag() != 19) {
                    return false;
                }
                BArrayType arrayType = (BArrayType)targetType;
                BValueArray array = (BValueArray)json;
                int i = 0;
                while ((long)i < array.size()) {
                    BType sourceElementType;
                    BType bType = sourceElementType = sourceType.getTag() == 19 ? ((BArrayType)sourceType).getElementType() : sourceType;
                    if (!BVM.checkJSONCast(array.getRefValue(i), sourceElementType, arrayType.getElementType())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 7: {
                return BVM.getElementType(sourceType).getTag() == 7;
            }
            case 11: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    private static void convertStructToMap(Strand strand, int[] operands, StackFrame sf) {
        int i = operands[0];
        int j = operands[1];
        BMap newMap = new BMap(BTypes.typeMap);
        ((BMap)sf.refRegs[i]).getMap().forEach((key, value) -> newMap.put(key, value == null ? null : ((BValue)value).copy(new HashMap<BValue, BValue>())));
        sf.refRegs[j] = newMap;
    }

    private static void convertStructToJSON(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        BJSONType targetType = (BJSONType)((TypeRefCPEntry)sf.constPool[cpIndex]).getType();
        BMap bStruct = (BMap)sf.refRegs[i];
        try {
            sf.refRegs[j] = JSONUtils.convertMapToJSON(bStruct, targetType);
        }
        catch (Exception e) {
            String errorMsg = "cannot convert '" + bStruct.getType() + "' to type '" + targetType + "': " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void convertArrayToJSON(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int j = operands[1];
        BNewArray bArray = (BNewArray)sf.refRegs[i];
        try {
            sf.refRegs[j] = JSONUtils.convertArrayToJSON(bArray);
        }
        catch (Exception e) {
            String errorMsg = "cannot convert '" + bArray.getType() + "' to type '" + BTypes.typeJSON + "': " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void convertJSONToArray(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        BArrayType targetType = (BArrayType)((TypeRefCPEntry)sf.constPool[cpIndex]).getType();
        BRefType<?> json = sf.refRegs[i];
        if (json == null) {
            BVM.handleTypeConversionError(ctx, sf, j, BTypes.typeNull, targetType);
            return;
        }
        try {
            sf.refRegs[j] = JSONUtils.convertJSON(json, targetType);
        }
        catch (Exception e) {
            String errorMsg = "cannot convert '" + json.getType() + "' to type '" + targetType + "': " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void convertMapToJSON(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        BJSONType targetType = (BJSONType)((TypeRefCPEntry)sf.constPool[cpIndex]).getType();
        BMap bMap = (BMap)sf.refRegs[i];
        try {
            sf.refRegs[j] = JSONUtils.convertMapToJSON(bMap, targetType);
        }
        catch (Exception e) {
            String errorMsg = "cannot convert '" + bMap.getType() + "' to type '" + targetType + "': " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void convertJSONToMap(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        BMapType targetType = (BMapType)((TypeRefCPEntry)sf.constPool[cpIndex]).getType();
        BRefType<?> json = sf.refRegs[i];
        if (json == null) {
            BVM.handleTypeConversionError(ctx, sf, j, BTypes.typeNull, targetType);
            return;
        }
        try {
            sf.refRegs[j] = JSONUtils.jsonToBMap(json, targetType);
        }
        catch (Exception e) {
            String errorMsg = "cannot convert '" + json.getType() + "' to type '" + targetType + "': " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void convertMapToStruct(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
        BStructureType structType = (BStructureType)typeRefCPEntry.getType();
        BMap bMap = (BMap)sf.refRegs[i];
        try {
            sf.refRegs[j] = BVM.convertMapToStruct(ctx, bMap, structType);
        }
        catch (BallerinaException e) {
            sf.refRegs[j] = null;
            String errorMsg = "cannot convert '" + bMap.getType() + "' to type '" + structType + ": " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static BMap<String, BValue> convertMapToStruct(Strand ctx, BMap<String, BValue> bMap, BStructureType structType) {
        bStruct = new BMap<String, BValue>(structType);
        structInfo = (StructureTypeInfo)structType.getTypeInfo();
        for (StructFieldInfo fieldInfo : structInfo.getFieldInfoEntries()) {
            block12: {
                key = fieldInfo.getName();
                fieldType = fieldInfo.getFieldType();
                containsField = bMap.hasKey(key);
                if (containsField) break block12;
                defaultValAttrInfo = (DefaultValueAttributeInfo)BVM.getAttributeInfo(fieldInfo, AttributeInfo.Kind.DEFAULT_VALUE_ATTRIBUTE);
                if (defaultValAttrInfo == null) ** GOTO lbl-1000
                switch (fieldType.getTag()) {
                    case 1: {
                        bStruct.put(key, new BInteger(defaultValAttrInfo.getDefaultValue().getIntValue()));
                        break;
                    }
                    case 2: {
                        bStruct.put(key, new BByte(defaultValAttrInfo.getDefaultValue().getByteValue()));
                        break;
                    }
                    case 3: {
                        bStruct.put(key, new BFloat(defaultValAttrInfo.getDefaultValue().getFloatValue()));
                        break;
                    }
                    case 4: {
                        bStruct.put(key, new BDecimal(defaultValAttrInfo.getDefaultValue().getDecimalValue()));
                        break;
                    }
                    case 5: {
                        bStruct.put(key, new BString(defaultValAttrInfo.getDefaultValue().getStringValue()));
                        break;
                    }
                    case 6: {
                        bStruct.put(key, new BBoolean(defaultValAttrInfo.getDefaultValue().getBooleanValue()));
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        bStruct.put(key, (BValue)fieldType.getZeroValue());
                        break;
                    }
                }
                continue;
            }
            mapVal = bMap.get(key);
            if (mapVal == null && BTypes.isValueType(fieldType)) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_FIELD_TYPE_FOR_CASTING, new Object[]{key, fieldType, null});
            }
            if (mapVal != null && mapVal.getType().getTag() == 15) {
                bStruct.put(key, BVM.convertMap(ctx, (BMap)mapVal, fieldType, key));
                continue;
            }
            if (!BVM.checkCast(mapVal, fieldType, new ArrayList<TypePair>())) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_FIELD_TYPE_FOR_CASTING, new Object[]{key, fieldType, mapVal == null ? null : mapVal.getType()});
            }
            bStruct.put(key, mapVal);
        }
        return bStruct;
    }

    private static BValue convertMap(Strand ctx, BMap<String, BValue> mapValue, BType targetType, String key) {
        switch (targetType.getTag()) {
            case 12: {
                return BVM.convertMapToStruct(ctx, mapValue, (BStructureType)targetType);
            }
            case 7: {
                return JSONUtils.convertMapToJSON(mapValue, (BJSONType)targetType);
            }
            case 20: {
                for (BType memType : ((BUnionType)targetType).getMemberTypes()) {
                    try {
                        return BVM.convertMap(ctx, mapValue, memType, key);
                    }
                    catch (BallerinaException ballerinaException) {
                    }
                }
                break;
            }
            default: {
                if (!BVM.checkCast(mapValue, targetType, new ArrayList<TypePair>())) break;
                return mapValue;
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_FIELD_TYPE_FOR_CASTING, key, targetType, mapValue.getType());
    }

    private static void convertJSONToStruct(Strand ctx, int[] operands, StackFrame sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)sf.constPool[cpIndex];
        BRefType<?> bjson = sf.refRegs[i];
        if (bjson == null) {
            BVM.handleTypeConversionError(ctx, sf, j, bjson != null ? bjson.getType() : BTypes.typeNull, typeRefCPEntry.getType());
            return;
        }
        try {
            sf.refRegs[j] = JSONUtils.convertJSONToStruct(bjson, (BStructureType)typeRefCPEntry.getType());
        }
        catch (Exception e) {
            String errorMsg = "cannot convert 'json' to type '" + typeRefCPEntry.getType() + "': " + e.getMessage();
            BVM.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void handleNullRefError(Strand strand) {
        strand.setError(BLangVMErrors.createNullRefException(strand));
        BVM.handleError(strand);
    }

    public static void handleError(Strand strand) {
        StackFrame sf = strand.currentFrame;
        int ip = sf.ip;
        ErrorTableEntry match = ErrorTableEntry.getMatch(sf.callableUnitInfo.getPackageInfo(), --ip);
        if (match != null) {
            sf.ip = match.ipTarget;
            sf.refRegs[match.regIndex] = strand.getError();
            strand.setError(null);
        } else if (strand.fp > 0) {
            ObserveUtils.stopCallableObservation(strand);
            StackFrame popedFrame = strand.popFrame();
            popedFrame.handleChannelPanic(strand.getError(), strand.currentFrame.wdChannels);
            BVM.signalTransactionError(strand, popedFrame.trxParticipant);
            BVM.handleError(strand);
        } else {
            strand.respCallback.setError(strand.getError());
            strand.currentFrame.handleChannelPanic(strand.getError(), strand.respCallback.parentChannels);
            BVM.signalTransactionError(strand, StackFrame.TransactionParticipantType.REMOTE_PARTICIPANT);
            sf.ip = -1;
            strand.respCallback.signal();
        }
    }

    private static void signalTransactionError(Strand strand, StackFrame.TransactionParticipantType transactionParticipant) {
        TransactionLocalContext transactionLocalContext = strand.getLocalTransactionContext();
        if (transactionLocalContext == null) {
            return;
        }
        boolean resourceParticipant = transactionLocalContext.isResourceParticipant();
        if (resourceParticipant && transactionParticipant == StackFrame.TransactionParticipantType.REMOTE_PARTICIPANT) {
            transactionLocalContext.notifyLocalRemoteParticipantFailure();
        } else if (transactionParticipant == StackFrame.TransactionParticipantType.LOCAL_PARTICIPANT) {
            transactionLocalContext.notifyLocalParticipantFailure();
        } else if (strand.aborted) {
            String blockID = transactionLocalContext.getCurrentTransactionBlockId();
            BVM.notifyTransactionAbort(strand, blockID, transactionLocalContext);
        }
    }

    private static AttributeInfo getAttributeInfo(AttributeInfoPool attrInfoPool, AttributeInfo.Kind attrInfoKind) {
        for (AttributeInfo attributeInfo : attrInfoPool.getAttributeInfoEntries()) {
            if (attributeInfo.getKind() != attrInfoKind) continue;
            return attributeInfo;
        }
        return null;
    }

    private static boolean execWait(Strand strand, int[] operands) {
        int c = operands[0];
        TypeRefCPEntry typeEntry = (TypeRefCPEntry)strand.currentFrame.constPool[operands[1]];
        BType expType = typeEntry.getType();
        int retValReg = operands[2];
        SafeStrandCallback[] callbacks = new SafeStrandCallback[c];
        for (int i = 0; i < c; ++i) {
            int futureReg = operands[i + 3];
            BFuture future = (BFuture)strand.currentFrame.refRegs[futureReg];
            callbacks[i] = (SafeStrandCallback)((Strand)future.value()).respCallback;
        }
        strand.createWaitHandler(c, null);
        return WaitCallbackHandler.handleReturnInWait(strand, expType, retValReg, callbacks);
    }

    private static boolean execWaitForAll(Strand strand, int[] operands) {
        int c = operands[0];
        TypeRefCPEntry typeEntry = (TypeRefCPEntry)strand.currentFrame.constPool[operands[1]];
        BType expType = typeEntry.getType();
        int retValReg = operands[2];
        ArrayList<SafeStrandCallback.WaitMultipleCallback> callbackList = new ArrayList<SafeStrandCallback.WaitMultipleCallback>();
        for (int i = 0; i < c; i += 2) {
            int index = i + 3;
            int keyRegIndex = operands[index];
            int futureReg = operands[index + 1];
            BFuture future = (BFuture)strand.currentFrame.refRegs[futureReg];
            callbackList.add(new SafeStrandCallback.WaitMultipleCallback(keyRegIndex, (SafeStrandCallback)((Strand)future.value()).respCallback));
        }
        strand.createWaitHandler(c, new ArrayList<Integer>(callbackList.stream().map(SafeStrandCallback.WaitMultipleCallback::getKeyRegIndex).collect(Collectors.toList())));
        return WaitCallbackHandler.handleReturnInWaitMultiple(strand, retValReg, callbackList);
    }

    private static void handleMapStore(Strand ctx, BMap<String, BRefType> bMap, String fieldName, BRefType<?> value) {
        BType mapType = bMap.getType();
        BType valuesType = value == null ? BTypes.typeNull : value.getType();
        switch (mapType.getTag()) {
            case 15: {
                if (!BVM.checkIsType(value, ((BMapType)mapType).getConstrainedType())) {
                    BType expType = ((BMapType)mapType).getConstrainedType();
                    throw new BLangMapStoreException(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_MAP_INSERTION, expType, valuesType));
                }
                BVM.insertToMap(ctx, bMap, fieldName, value);
                break;
            }
            case 33: {
                BObjectType objType = (BObjectType)mapType;
                BField objField = objType.getFields().get(fieldName);
                BType objFieldType = objField.getFieldType();
                if (!BVM.checkIsType(value, objFieldType)) {
                    throw new BLangMapStoreException(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_OBJECT_FIELD_ADDITION, fieldName, objFieldType, valuesType));
                }
                BVM.insertToMap(ctx, bMap, fieldName, value);
                break;
            }
            case 12: {
                BType recFieldType;
                BRecordType recType = (BRecordType)mapType;
                BField recField = recType.getFields().get(fieldName);
                if (recField != null) {
                    recFieldType = recField.fieldType;
                } else if (recType.restFieldType != null) {
                    recFieldType = recType.restFieldType;
                } else {
                    throw new BLangMapStoreException(BallerinaErrorReasons.KEY_NOT_FOUND_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ACCESS, fieldName, recType));
                }
                if (!BVM.checkIsType(value, recFieldType)) {
                    throw new BLangMapStoreException(BallerinaErrorReasons.INHERENT_TYPE_VIOLATION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ADDITION, fieldName, recFieldType, valuesType));
                }
                BVM.insertToMap(ctx, bMap, fieldName, value);
            }
        }
    }

    private static void insertToMap(Strand ctx, BMap bMap, String fieldName, BValue value) {
        try {
            bMap.put(fieldName, value);
        }
        catch (BLangFreezeException e) {
            String errMessage = "";
            switch (bMap.getType().getTag()) {
                case 12: {
                    errMessage = "Invalid update of record field: ";
                    break;
                }
                case 15: {
                    errMessage = "Invalid map insertion: ";
                }
            }
            ctx.setError(BLangVMErrors.createError(ctx, e.getMessage(), errMessage + e.getDetail()));
            BVM.handleError(ctx);
        }
    }

    public static boolean isAssignable(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        if (BVM.isSameOrAnyType(sourceType, targetType)) {
            return true;
        }
        if (targetType.getTag() == 20) {
            return BVM.checkUnionAssignable(sourceType, targetType, unresolvedTypes);
        }
        if (targetType.getTag() == 7 && sourceType.getTag() == 7) {
            return true;
        }
        if (targetType.getTag() == 19 && sourceType.getTag() == 19) {
            if (((BArrayType)sourceType).getState() == BArrayState.CLOSED_SEALED && ((BArrayType)targetType).getState() == BArrayState.CLOSED_SEALED && ((BArrayType)sourceType).getSize() != ((BArrayType)targetType).getSize()) {
                return false;
            }
            return BVM.checkArrayCast(((BArrayType)sourceType).getElementType(), ((BArrayType)targetType).getElementType(), unresolvedTypes);
        }
        if (sourceType.getTag() == 29 && targetType.getTag() == 29) {
            return BVM.checkTupleAssignable(sourceType, targetType, unresolvedTypes);
        }
        return BVM.checkCastByType(sourceType, targetType, unresolvedTypes);
    }

    private static boolean checkUnionAssignable(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() == 20) {
            for (BType sourceMemberType : ((BUnionType)sourceType).getMemberTypes()) {
                if (BVM.checkUnionAssignable(sourceMemberType, targetType, unresolvedTypes)) continue;
                return false;
            }
            return true;
        }
        BUnionType targetUnionType = (BUnionType)targetType;
        for (BType memberType : targetUnionType.getMemberTypes()) {
            if (!BVM.isAssignable(sourceType, memberType, unresolvedTypes)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkTupleAssignable(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        List<BType> targetTupleTypes = ((BTupleType)targetType).getTupleTypes();
        List<BType> sourceTupleTypes = ((BTupleType)sourceType).getTupleTypes();
        if (sourceTupleTypes.size() != targetTupleTypes.size()) {
            return false;
        }
        for (int i = 0; i < sourceTupleTypes.size(); ++i) {
            if (BVM.isAssignable(sourceTupleTypes.get(i), targetTupleTypes.get(i), unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFunctionCast(BType sourceType, BFunctionType targetType) {
        int i;
        if (sourceType.getTag() != 35) {
            return false;
        }
        BFunctionType source = (BFunctionType)sourceType;
        if (source.paramTypes.length != targetType.paramTypes.length || source.retParamTypes.length != targetType.retParamTypes.length) {
            return false;
        }
        for (i = 0; i < source.paramTypes.length; ++i) {
            if (BVM.isSameType(source.paramTypes[i], targetType.paramTypes[i])) continue;
            return false;
        }
        for (i = 0; i < source.retParamTypes.length; ++i) {
            if (BVM.isSameType(source.retParamTypes[i], targetType.retParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isDeepStampingRequiredForArray(BType sourceType) {
        BType elementType = ((BArrayType)sourceType).getElementType();
        if (elementType != null) {
            if (BTypes.isValueType(elementType)) {
                return false;
            }
            if (elementType instanceof BArrayType) {
                return BVM.isDeepStampingRequiredForArray(elementType);
            }
            return true;
        }
        return true;
    }

    private static boolean isDeepStampingRequiredForMap(BType sourceType) {
        BType constrainedType = ((BMapType)sourceType).getConstrainedType();
        if (constrainedType != null) {
            if (BTypes.isValueType(constrainedType)) {
                return false;
            }
            if (constrainedType instanceof BMapType) {
                return BVM.isDeepStampingRequiredForMap(constrainedType);
            }
            return true;
        }
        return true;
    }

    public static BType resolveMatchingTypeForUnion(BValue value, BType type) {
        if (value instanceof BValueArray && value.getType().getTag() == 19 && !BVM.isDeepStampingRequiredForArray(((BValueArray)value).getArrayType())) {
            return ((BValueArray)value).getArrayType();
        }
        if (value instanceof BMap && value.getType().getTag() == 15 && !BVM.isDeepStampingRequiredForMap(value.getType())) {
            return value.getType();
        }
        if (BVM.checkIsLikeType(value, BTypes.typeInt)) {
            return BTypes.typeInt;
        }
        if (BVM.checkIsLikeType(value, BTypes.typeFloat)) {
            return BTypes.typeFloat;
        }
        if (BVM.checkIsLikeType(value, BTypes.typeString)) {
            return BTypes.typeString;
        }
        if (BVM.checkIsLikeType(value, BTypes.typeBoolean)) {
            return BTypes.typeBoolean;
        }
        if (BVM.checkIsLikeType(value, BTypes.typeByte)) {
            return BTypes.typeByte;
        }
        BArrayType anydataArrayType = new BArrayType(type);
        if (BVM.checkIsLikeType(value, anydataArrayType)) {
            return anydataArrayType;
        }
        if (BVM.checkIsLikeType(value, BTypes.typeXML)) {
            return BTypes.typeXML;
        }
        BMapType anydataMapType = new BMapType(type);
        if (BVM.checkIsLikeType(value, anydataMapType)) {
            return anydataMapType;
        }
        return null;
    }

    public static boolean checkIsLikeType(BValue sourceValue, BType targetType) {
        return BVM.checkIsLikeType(sourceValue, targetType, new ArrayList<TypeValuePair>());
    }

    public static boolean checkIsLikeType(BValue sourceValue, BType targetType, List<TypeValuePair> unresolvedValues) {
        BType sourceType;
        BType bType = sourceType = sourceValue == null ? BTypes.typeNull : sourceValue.getType();
        if (BVM.checkIsType(sourceType, targetType, new ArrayList<TypePair>())) {
            return true;
        }
        switch (targetType.getTag()) {
            case 12: {
                return BVM.checkIsLikeRecordType(sourceValue, (BRecordType)targetType, unresolvedValues);
            }
            case 7: {
                return BVM.checkIsLikeJSONType(sourceValue, (BJSONType)targetType, unresolvedValues);
            }
            case 15: {
                return BVM.checkIsLikeMapType(sourceValue, (BMapType)targetType, unresolvedValues);
            }
            case 19: {
                return BVM.checkIsLikeArrayType(sourceValue, (BArrayType)targetType, unresolvedValues);
            }
            case 29: {
                return BVM.checkIsLikeTupleType(sourceValue, (BTupleType)targetType, unresolvedValues);
            }
            case 27: {
                return BVM.checkIsLikeErrorType(sourceValue, (BErrorType)targetType, unresolvedValues);
            }
            case 11: {
                return BVM.checkIsLikeAnydataType(sourceValue, unresolvedValues);
            }
            case 32: {
                return BVM.checkFiniteTypeAssignable(sourceValue, targetType);
            }
            case 20: {
                return ((BUnionType)targetType).getMemberTypes().stream().anyMatch(type -> BVM.checkIsLikeType(sourceValue, type, unresolvedValues));
            }
        }
        return false;
    }

    private static boolean checkIsLikeAnydataType(BValue sourceValue, List<TypeValuePair> unresolvedValues) {
        switch (sourceValue.getType().getTag()) {
            case 7: 
            case 12: 
            case 15: {
                return ((BMap)sourceValue).getMap().values().stream().allMatch(value -> BVM.checkIsLikeType((BValue)value, BTypes.typeAnydata, unresolvedValues));
            }
            case 19: {
                BNewArray arr = (BNewArray)sourceValue;
                BArrayType arrayType = (BArrayType)arr.getType();
                switch (arrayType.getElementType().getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                return Arrays.stream(((BValueArray)sourceValue).getValues()).allMatch(value -> BVM.checkIsLikeType(value, BTypes.typeAnydata, unresolvedValues));
            }
            case 29: {
                return Arrays.stream(((BValueArray)sourceValue).getValues()).allMatch(value -> BVM.checkIsLikeType(value, BTypes.typeAnydata, unresolvedValues));
            }
            case 11: {
                return true;
            }
            case 20: 
            case 32: {
                return BVM.checkIsLikeType(sourceValue, BTypes.typeAnydata, unresolvedValues);
            }
        }
        return false;
    }

    private static boolean checkIsLikeTupleType(BValue sourceValue, BTupleType targetType, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof BValueArray)) {
            return false;
        }
        BValueArray source = (BValueArray)sourceValue;
        if (source.size() != (long)targetType.getTupleTypes().size()) {
            return false;
        }
        if (BTypes.isValueType(source.elementType)) {
            int bound = (int)source.size();
            for (int i = 0; i < bound; ++i) {
                if (BVM.checkIsType(source.elementType, targetType.getTupleTypes().get(i), new ArrayList<TypePair>())) continue;
                return false;
            }
            return true;
        }
        int bound = (int)source.size();
        for (int i = 0; i < bound; ++i) {
            if (BVM.checkIsLikeType(source.getRefValue(i), targetType.getTupleTypes().get(i), unresolvedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeArrayType(BValue sourceValue, BArrayType targetType, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof BValueArray)) {
            return false;
        }
        BValueArray source = (BValueArray)sourceValue;
        if (BTypes.isValueType(source.elementType)) {
            return BVM.checkIsType(source.elementType, targetType.getElementType(), new ArrayList<TypePair>());
        }
        BType arrayElementType = targetType.getElementType();
        BRefType<?>[] arrayValues = source.getValues();
        int i = 0;
        while ((long)i < ((BValueArray)sourceValue).size()) {
            if (!BVM.checkIsLikeType(arrayValues[i], arrayElementType, unresolvedValues)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkIsLikeMapType(BValue sourceValue, BMapType targetType, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof BMap)) {
            return false;
        }
        for (BValue mapEntry : ((BMap)sourceValue).values()) {
            if (BVM.checkIsLikeType(mapEntry, targetType.getConstrainedType(), unresolvedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeJSONType(BValue sourceValue, BJSONType targetType, List<TypeValuePair> unresolvedValues) {
        if (sourceValue.getType().getTag() == 19) {
            BValueArray source = (BValueArray)sourceValue;
            if (BTypes.isValueType(source.elementType)) {
                return BVM.checkIsType(source.elementType, targetType, new ArrayList<TypePair>());
            }
            BRefType<?>[] arrayValues = source.getValues();
            int i = 0;
            while ((long)i < ((BValueArray)sourceValue).size()) {
                if (!BVM.checkIsLikeType(arrayValues[i], targetType, unresolvedValues)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (sourceValue.getType().getTag() == 15) {
            for (BValue value : ((BMap)sourceValue).values()) {
                if (BVM.checkIsLikeType(value, targetType, unresolvedValues)) continue;
                return false;
            }
            return true;
        }
        if (sourceValue.getType().getTag() == 12) {
            TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
            if (unresolvedValues.contains(typeValuePair)) {
                return true;
            }
            unresolvedValues.add(typeValuePair);
            for (Object object : ((BMap)sourceValue).getMap().values()) {
                if (BVM.checkIsLikeType((BValue)object, targetType, unresolvedValues)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean checkIsLikeRecordType(BValue sourceValue, BRecordType targetType, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof BMap)) {
            return false;
        }
        TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            return true;
        }
        unresolvedValues.add(typeValuePair);
        HashMap<String, BType> targetTypeField = new HashMap<String, BType>();
        BType restFieldType = targetType.restFieldType;
        for (BField bField : targetType.getFields().values()) {
            targetTypeField.put(bField.getFieldName(), bField.fieldType);
        }
        for (Map.Entry entry : targetTypeField.entrySet()) {
            String fieldName = entry.getKey().toString();
            if (((BMap)sourceValue).getMap().containsKey(fieldName) || Flags.isFlagOn(targetType.getFields().get((Object)fieldName).flags, 8192)) continue;
            return false;
        }
        for (Object object : ((BMap)sourceValue).getMap().entrySet()) {
            Map.Entry valueEntry = (Map.Entry)object;
            String fieldName = valueEntry.getKey().toString();
            if (targetTypeField.containsKey(fieldName)) {
                if (BVM.checkIsLikeType((BValue)valueEntry.getValue(), (BType)targetTypeField.get(fieldName), unresolvedValues)) continue;
                return false;
            }
            if (!targetType.sealed) {
                if (BVM.checkIsLikeType((BValue)valueEntry.getValue(), restFieldType, unresolvedValues)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeErrorType(BValue sourceValue, BErrorType targetType, List<TypeValuePair> unresolvedValues) {
        if (sourceValue == null || sourceValue.getType().getTag() != 27) {
            return false;
        }
        return BVM.checkIsLikeType(new BString(((BError)sourceValue).getReason()), targetType.reasonType, unresolvedValues) && BVM.checkIsLikeType(((BError)sourceValue).getDetails(), targetType.detailType, unresolvedValues);
    }

    public static boolean checkIsType(BValue sourceVal, BType targetType) {
        if (BVM.isMutable(sourceVal)) {
            BType sourceType = sourceVal == null ? BTypes.typeNull : sourceVal.getType();
            return BVM.checkIsType(sourceType, targetType, new ArrayList<TypePair>());
        }
        return BVM.checkIsLikeType(sourceVal, targetType, new ArrayList<TypeValuePair>());
    }

    private static boolean checkIsType(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType == targetType || sourceType.equals(targetType)) {
            return true;
        }
        switch (targetType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                if (sourceType.getTag() == 32) {
                    return ((BFiniteType)sourceType).valueSpace.stream().allMatch(bValue -> BVM.checkIsType(bValue, targetType));
                }
                return sourceType.getTag() == targetType.getTag();
            }
            case 15: {
                return BVM.checkIsMapType(sourceType, (BMapType)targetType, unresolvedTypes);
            }
            case 7: {
                return BVM.checkIsJSONType(sourceType, (BJSONType)targetType, unresolvedTypes);
            }
            case 12: {
                return BVM.checkIsRecordType(sourceType, (BRecordType)targetType, unresolvedTypes);
            }
            case 35: {
                return BVM.checkFunctionCast(sourceType, (BFunctionType)targetType);
            }
            case 19: {
                return BVM.checkIsArrayType(sourceType, (BArrayType)targetType, unresolvedTypes);
            }
            case 29: {
                return BVM.checkIsTupleType(sourceType, (BTupleType)targetType, unresolvedTypes);
            }
            case 20: {
                return BVM.checkIsUnionType(sourceType, (BUnionType)targetType, unresolvedTypes);
            }
            case 9: {
                return BVM.checkIsTableType(sourceType, (BTableType)targetType, unresolvedTypes);
            }
            case 17: {
                return BVM.checkIsAnyType(sourceType);
            }
            case 11: 
            case 33: {
                return targetType instanceof BServiceType ? sourceType.getTag() == targetType.getTag() : BVM.isAssignable(sourceType, targetType, unresolvedTypes);
            }
            case 32: {
                return BVM.checkIsFiniteType(sourceType, (BFiniteType)targetType, unresolvedTypes);
            }
            case 30: {
                return BVM.checkIsFutureType(sourceType, (BFutureType)targetType, unresolvedTypes);
            }
            case 14: {
                return BVM.checkIsStreamType(sourceType, (BStreamType)targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkIsMapType(BType sourceType, BMapType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 15) {
            return false;
        }
        return BVM.checkContraints(((BMapType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkIsJSONType(BType sourceType, BJSONType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return true;
            }
            case 19: {
                return BVM.checkIsType(((BArrayType)sourceType).getElementType(), targetType, unresolvedTypes);
            }
            case 15: {
                return BVM.checkCastByType(((BMapType)sourceType).getConstrainedType(), targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkIsRecordType(BType sourceType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 12) {
            return false;
        }
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BRecordType sourceRecordType = (BRecordType)sourceType;
        if (targetType.sealed && !sourceRecordType.sealed) {
            return false;
        }
        if (!sourceRecordType.sealed && !BVM.checkIsType(sourceRecordType.restFieldType, targetType.restFieldType, unresolvedTypes)) {
            return false;
        }
        Map<String, BField> sourceFields = sourceRecordType.getFields();
        Set<String> targetFieldNames = targetType.getFields().keySet();
        for (BField targetField : targetType.getFields().values()) {
            BField sourceField = sourceFields.get(targetField.getFieldName());
            if (!Flags.isFlagOn(targetField.flags, 8192) && (sourceField == null || Flags.isFlagOn(sourceField.flags, 8192))) {
                return false;
            }
            if (sourceField != null && BVM.checkIsType(sourceField.fieldType, targetField.fieldType, unresolvedTypes)) continue;
            return false;
        }
        if (targetType.sealed) {
            return targetFieldNames.containsAll(sourceFields.keySet());
        }
        return sourceFields.values().stream().filter(field -> !targetFieldNames.contains(field.fieldName)).allMatch(field -> BVM.checkIsType(field.getFieldType(), targetType.restFieldType, unresolvedTypes));
    }

    private static boolean checkIsUnionType(BType sourceType, BUnionType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() == 20) {
            return ((BUnionType)sourceType).getMemberTypes().stream().allMatch(type -> BVM.checkIsType(type, targetType, unresolvedTypes));
        }
        if (sourceType.getTag() == 32) {
            return ((BFiniteType)sourceType).valueSpace.stream().allMatch(bValue -> BVM.checkIsType(bValue, targetType));
        }
        return targetType.getMemberTypes().stream().anyMatch(type -> BVM.checkIsType(sourceType, type, unresolvedTypes));
    }

    private static boolean checkIsTableType(BType sourceType, BTableType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 9) {
            return false;
        }
        return BVM.checkTableConstraints(((BTableType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkIsAnyType(BType sourceType) {
        switch (sourceType.getTag()) {
            case 27: {
                return false;
            }
            case 20: {
                return ((BUnionType)sourceType).getMemberTypes().stream().allMatch(BVM::checkIsAnyType);
            }
        }
        return true;
    }

    private static boolean checkIsArrayType(BType sourceType, BArrayType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 19) {
            return false;
        }
        BArrayType sourceArrayType = (BArrayType)sourceType;
        switch (sourceArrayType.getState()) {
            case UNSEALED: {
                if (targetType.getState() == BArrayState.UNSEALED) break;
                return false;
            }
            case CLOSED_SEALED: {
                if (targetType.getState() != BArrayState.CLOSED_SEALED || sourceArrayType.getSize() == targetType.getSize()) break;
                return false;
            }
        }
        return BVM.checkIsType(sourceArrayType.getElementType(), targetType.getElementType(), unresolvedTypes);
    }

    private static boolean checkIsTupleType(BType sourceType, BTupleType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 29) {
            return false;
        }
        List<BType> sourceTypes = ((BTupleType)sourceType).getTupleTypes();
        List<BType> targetTypes = targetType.getTupleTypes();
        if (sourceTypes.size() != targetTypes.size()) {
            return false;
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            if (BVM.checkIsType(sourceTypes.get(i), targetTypes.get(i), unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsFiniteType(BType sourceType, BFiniteType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 32) {
            return false;
        }
        BFiniteType sourceFiniteType = (BFiniteType)sourceType;
        if (sourceFiniteType.valueSpace.size() != targetType.valueSpace.size()) {
            return false;
        }
        return sourceFiniteType.valueSpace.stream().allMatch(value -> targetType.valueSpace.contains(value));
    }

    private static boolean checkIsFutureType(BType sourceType, BFutureType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 30) {
            return false;
        }
        return BVM.checkContraints(((BFutureType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkIsStreamType(BType sourceType, BStreamType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 14) {
            return false;
        }
        return BVM.checkContraints(((BStreamType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkContraints(BType sourceConstraint, BType targetConstraint, List<TypePair> unresolvedTypes) {
        if (sourceConstraint == null) {
            sourceConstraint = BTypes.typeAny;
        }
        if (targetConstraint == null) {
            targetConstraint = BTypes.typeAny;
        }
        return BVM.checkIsType(sourceConstraint, targetConstraint, unresolvedTypes);
    }

    private static boolean checkTableConstraints(BType sourceConstraint, BType targetConstraint, List<TypePair> unresolvedTypes) {
        if (sourceConstraint == null) {
            if (targetConstraint.getTag() == 12) {
                BRecordType targetConstrRecord = (BRecordType)targetConstraint;
                return !targetConstrRecord.sealed && BVM.checkIsType(targetConstrRecord.restFieldType, BTypes.typePureType, new ArrayList<TypePair>());
            }
            return false;
        }
        return BVM.checkIsType(sourceConstraint, targetConstraint, unresolvedTypes);
    }

    private static boolean isMutable(BValue value) {
        if (value == null) {
            return false;
        }
        if (value.getType().getTag() < 7 || value.getType().getTag() == 32) {
            return false;
        }
        return !value.isFrozen();
    }

    private static boolean isEqual(BValue lhsValue, BValue rhsValue, List<ValuePair> checkedValues) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (null == lhsValue || null == rhsValue) {
            return false;
        }
        int lhsValTypeTag = lhsValue.getType().getTag();
        int rhsValTypeTag = rhsValue.getType().getTag();
        switch (lhsValTypeTag) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return lhsValue.equals(rhsValue);
            }
            case 1: {
                if (rhsValTypeTag == 2) {
                    return ((BInteger)lhsValue).intValue() == ((BByte)rhsValue).intValue();
                }
                return lhsValue.equals(rhsValue);
            }
            case 2: {
                if (rhsValTypeTag == 1) {
                    return ((BByte)lhsValue).intValue() == ((BInteger)rhsValue).intValue();
                }
                return lhsValue.equals(rhsValue);
            }
            case 8: {
                return XMLUtils.isEqual((BXML)lhsValue, (BXML)rhsValue);
            }
            case 9: {
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                return BVM.isMappingType(rhsValTypeTag) && BVM.isEqual((BMap)lhsValue, (BMap)rhsValue, checkedValues);
            }
            case 19: 
            case 29: {
                return BVM.isListType(rhsValTypeTag) && BVM.isEqual((BNewArray)lhsValue, (BNewArray)rhsValue, checkedValues);
            }
            case 27: {
                return rhsValTypeTag == 27 && BVM.isEqual((BError)lhsValue, (BError)rhsValue, checkedValues);
            }
        }
        return false;
    }

    private static boolean isListType(int typeTag) {
        return typeTag == 19 || typeTag == 29;
    }

    private static boolean isMappingType(int typeTag) {
        return typeTag == 15 || typeTag == 12 || typeTag == 7;
    }

    private static boolean isEqual(BNewArray lhsList, BNewArray rhsList, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsList, rhsList);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsList.size() != rhsList.size()) {
            return false;
        }
        int i = 0;
        while ((long)i < lhsList.size()) {
            if (!BVM.isEqual(lhsList.getBValue(i), rhsList.getBValue(i), checkedValues)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqual(BMap lhsMap, BMap rhsMap, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsMap, rhsMap);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsMap.size() != rhsMap.size()) {
            return false;
        }
        if (!lhsMap.getMap().keySet().containsAll(rhsMap.getMap().keySet())) {
            return false;
        }
        for (Map.Entry lhsMapEntry : lhsMap.getMap().entrySet()) {
            if (BVM.isEqual((BValue)lhsMapEntry.getValue(), rhsMap.get(lhsMapEntry.getKey()), checkedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(BError lhsError, BError rhsError, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsError, rhsError);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        return BVM.isEqual(new BString(lhsError.getReason()), new BString(rhsError.getReason()), checkedValues) && BVM.isEqual((BMap)lhsError.getDetails(), (BMap)rhsError.getDetails(), checkedValues);
    }

    private static boolean isReferenceEqual(BValue lhsValue, BValue rhsValue) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (lhsValue == null || rhsValue == null) {
            return false;
        }
        if (BVM.isSimpleBasicType(lhsValue.getType()) && BVM.isSimpleBasicType(rhsValue.getType())) {
            return BVM.isEqual(lhsValue, rhsValue, Collections.emptyList());
        }
        return false;
    }

    private static boolean isReferenceInequal(BValue lhsValue, BValue rhsValue) {
        if (lhsValue == null || rhsValue == null) {
            return lhsValue != rhsValue;
        }
        if (BVM.isSimpleBasicType(lhsValue.getType()) && BVM.isSimpleBasicType(rhsValue.getType())) {
            return !BVM.isEqual(lhsValue, rhsValue, Collections.emptyList());
        }
        return lhsValue != rhsValue;
    }

    private static boolean isSimpleBasicType(BType type) {
        return type.getTag() < 7;
    }

    private static boolean isBasicNumericType(BType type) {
        return type.getTag() < 5;
    }

    private static boolean containsNumericType(BType type) {
        if (type.getTag() == 20) {
            return ((BUnionType)type).getMemberTypes().stream().anyMatch(BVM::containsNumericType);
        }
        return BVM.isBasicNumericType(type);
    }

    public static class TypeValuePair {
        BValue sourceValue;
        BType targetType;

        public TypeValuePair(BValue sourceValue, BType targetType) {
            this.sourceValue = sourceValue;
            this.targetType = targetType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeValuePair)) {
                return false;
            }
            TypeValuePair other = (TypeValuePair)obj;
            return this.sourceValue.equals(other.sourceValue) && this.targetType.equals(other.targetType);
        }
    }

    private static class ValuePair {
        List<BValue> valueList = new ArrayList<BValue>(2);

        ValuePair(BValue valueOne, BValue valueTwo) {
            this.valueList.add(valueOne);
            this.valueList.add(valueTwo);
        }

        public boolean equals(Object otherPair) {
            if (!(otherPair instanceof ValuePair)) {
                return false;
            }
            return ((ValuePair)otherPair).valueList.containsAll(this.valueList) && this.valueList.containsAll(((ValuePair)otherPair).valueList);
        }
    }

    private static class TypePair {
        BType sourceType;
        BType targetType;

        public TypePair(BType sourceType, BType targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair other = (TypePair)obj;
            return this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
        }
    }

    public static class FreezeStatus {
        private State currentState;

        public FreezeStatus(State state) {
            this.currentState = state;
        }

        public void setFrozen() {
            this.currentState = State.FROZEN;
        }

        public void setUnfrozen() {
            this.currentState = State.UNFROZEN;
        }

        public State getState() {
            return this.currentState;
        }

        public boolean isFrozen() {
            return this.currentState == State.FROZEN;
        }

        public static enum State {
            FROZEN,
            MID_FREEZE,
            UNFROZEN;

        }
    }

    public static class HandleErrorException
    extends BallerinaException {
        private static final long serialVersionUID = 1L;
        public WorkerExecutionContext ctx;

        public HandleErrorException(WorkerExecutionContext ctx) {
            this.ctx = ctx;
        }
    }
}

