/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.bvm.StrandCallback;
import org.ballerinalang.bre.bvm.WDChannels;
import org.ballerinalang.bre.bvm.WaitCallbackHandler;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.util.codegen.CallableUnitInfo;

public class SafeStrandCallback
extends StrandCallback {
    private static PrintStream errStream = System.err;
    private CallbackWaitHandler callbackWaitHandler = new CallbackWaitHandler();

    SafeStrandCallback(BType retType, WDChannels parentChannels, CallableUnitInfo.ChannelDetails[] sendIns) {
        super(retType, sendIns, parentChannels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        try {
            this.callbackWaitHandler.dataLock.lock();
            super.signal();
            if (this.callbackWaitHandler.waitingStrands.isEmpty()) {
                return;
            }
            for (WaitingStrandInfo strandInfo : this.callbackWaitHandler.waitingStrands) {
                if (strandInfo.waitingStrand.strandWaitHandler.waitCompleted) continue;
                if (strandInfo.waitForAll) {
                    ArrayList<WaitMultipleCallback> callbackList = new ArrayList<WaitMultipleCallback>();
                    callbackList.add(new WaitMultipleCallback(strandInfo.keyReg, this));
                    if (!WaitCallbackHandler.handleReturnInWaitMultiple(strandInfo.waitingStrand, strandInfo.retReg, callbackList)) continue;
                    BVMScheduler.stateChange(strandInfo.waitingStrand, Strand.State.PAUSED, Strand.State.RUNNABLE);
                    BVMScheduler.schedule(strandInfo.waitingStrand);
                    continue;
                }
                if (!WaitCallbackHandler.handleReturnInWait(strandInfo.waitingStrand, strandInfo.expType, strandInfo.retReg, this)) continue;
                BVMScheduler.stateChange(strandInfo.waitingStrand, Strand.State.PAUSED, Strand.State.RUNNABLE);
                BVMScheduler.schedule(strandInfo.waitingStrand);
            }
        }
        finally {
            this.callbackWaitHandler.dataLock.unlock();
        }
    }

    @Override
    public void setError(BError error) {
        super.setError(error);
        errStream.println("error: " + BLangVMErrors.getPrintableStackTrace(error));
    }

    public void setErrorForCancelledFuture(BError error) {
        super.setError(error);
    }

    void acquireDataLock() {
        this.callbackWaitHandler.dataLock.lock();
    }

    void releaseDataLock() {
        this.callbackWaitHandler.dataLock.unlock();
    }

    void configureWaitHandler(Strand waitingStrand, boolean waitForAll, BType expType, int retReg, int keyReg) {
        WaitingStrandInfo strandInfo = new WaitingStrandInfo(waitingStrand, waitForAll, expType, retReg, keyReg);
        this.callbackWaitHandler.waitingStrands.add(strandInfo);
    }

    public static class WaitingStrandInfo {
        Strand waitingStrand;
        boolean waitForAll;
        BType expType;
        int retReg;
        int keyReg;

        public WaitingStrandInfo(Strand waitingStrand, boolean waitForAll, BType expType, int retReg) {
            this.waitingStrand = waitingStrand;
            this.waitForAll = waitForAll;
            this.expType = expType;
            this.retReg = retReg;
        }

        public WaitingStrandInfo(Strand waitingStrand, boolean waitForAll, BType expType, int retReg, int keyReg) {
            this.waitingStrand = waitingStrand;
            this.waitForAll = waitForAll;
            this.expType = expType;
            this.retReg = retReg;
            this.keyReg = keyReg;
        }
    }

    public static class WaitMultipleCallback {
        private int keyRegIndex;
        private SafeStrandCallback callback;

        public WaitMultipleCallback(int keyRegIndex, SafeStrandCallback callback) {
            this.keyRegIndex = keyRegIndex;
            this.callback = callback;
        }

        public int getKeyRegIndex() {
            return this.keyRegIndex;
        }

        public SafeStrandCallback getCallback() {
            return this.callback;
        }
    }

    public static class CallbackWaitHandler {
        private Lock dataLock = new ReentrantLock();
        List<WaitingStrandInfo> waitingStrands = new LinkedList<WaitingStrandInfo>();
    }
}

