/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BClosure;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.siddhi.core.SiddhiAppRuntime;
import org.ballerinalang.siddhi.core.SiddhiManager;
import org.ballerinalang.siddhi.core.event.Event;
import org.ballerinalang.siddhi.core.stream.output.StreamCallback;
import org.ballerinalang.util.exceptions.BallerinaException;

public class StreamingRuntimeManager {
    private static StreamingRuntimeManager streamingRuntimeManager;
    private SiddhiManager siddhiManager = new SiddhiManager();
    private List<SiddhiAppRuntime> siddhiAppRuntimeList = new ArrayList<SiddhiAppRuntime>();

    private StreamingRuntimeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StreamingRuntimeManager getInstance() {
        if (streamingRuntimeManager != null) {
            return streamingRuntimeManager;
        }
        Class<StreamingRuntimeManager> clazz = StreamingRuntimeManager.class;
        synchronized (StreamingRuntimeManager.class) {
            if (streamingRuntimeManager == null) {
                streamingRuntimeManager = new StreamingRuntimeManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return streamingRuntimeManager;
        }
    }

    public SiddhiAppRuntime createSiddhiAppRuntime(String siddhiApp) {
        SiddhiAppRuntime siddhiAppRuntime = this.siddhiManager.createSiddhiAppRuntime(siddhiApp);
        this.siddhiAppRuntimeList.add(siddhiAppRuntime);
        siddhiAppRuntime.start();
        return siddhiAppRuntime;
    }

    public void addCallback(String streamId, final BFunctionPointer functionPointer, SiddhiAppRuntime siddhiAppRuntime) {
        BType[] parameters = functionPointer.value().getParamTypes();
        final ArrayList<BValue> closureArgs = new ArrayList<BValue>();
        for (BClosure closure : functionPointer.getClosureVars()) {
            closureArgs.add(closure.value());
        }
        final BStructureType structType = (BStructureType)((BArrayType)parameters[parameters.length - 1]).getElementType();
        if (!(parameters[parameters.length - 1] instanceof BArrayType)) {
            throw new BallerinaException("incompatible function: inline function needs to be a function accepting an object array");
        }
        siddhiAppRuntime.addCallback(streamId, new StreamCallback(){

            public void receive(Event[] events) {
                BValueArray outputArray = new BValueArray(new BMapType(structType));
                int j = 0;
                for (Event event : events) {
                    BMap<String, BValueType> output = new BMap<String, BValueType>(structType);
                    Iterator<String> fieldNamesIterator = structType.getFields().keySet().iterator();
                    for (Object field : event.getData()) {
                        if (field instanceof Long || field instanceof Integer) {
                            output.put(fieldNamesIterator.next(), new BInteger(((Number)field).longValue()));
                            continue;
                        }
                        if (field instanceof Double || field instanceof Float) {
                            output.put(fieldNamesIterator.next(), new BFloat(((Number)field).doubleValue()));
                            continue;
                        }
                        if (field instanceof Boolean) {
                            output.put(fieldNamesIterator.next(), new BBoolean((Boolean)field));
                            continue;
                        }
                        if (!(field instanceof String)) continue;
                        output.put(fieldNamesIterator.next(), new BString((String)field));
                    }
                    outputArray.add((long)j, output);
                    ++j;
                }
                ArrayList<BValueArray> argsList = new ArrayList<BValueArray>();
                argsList.addAll(closureArgs);
                argsList.add(outputArray);
                BVMExecutor.executeFunction(functionPointer.value().getPackageInfo().getProgramFile(), functionPointer.value(), argsList.toArray(new BValue[0]));
            }
        });
    }
}

