/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.StructField;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.connector.impl.AnnotatableNode;
import org.ballerinalang.connector.impl.ValueImpl;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;

public class StructImpl
extends AnnotatableNode
implements Struct {
    private BMap<String, BValue> value;
    private BStructureType type;
    private Map<String, StructFieldImpl> structFields = new LinkedHashMap<String, StructFieldImpl>();
    private int[] indexes = new int[]{-1, -1, -1, -1, -1, -1};

    StructImpl(BMap<String, BValue> value) {
        this.value = value;
        this.type = (BStructureType)value.getType();
        this.type.getFields().values().forEach(sf -> {
            StructFieldImpl structField = new StructFieldImpl(sf.fieldName, sf.fieldType.getTag());
            StructImpl.setIndex(structField, this.indexes);
            this.structFields.put(sf.fieldName, structField);
        });
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public String getPackage() {
        return this.type.getPackagePath();
    }

    public StructFieldImpl[] getFields() {
        return this.structFields.values().toArray(new StructFieldImpl[0]);
    }

    @Override
    public long getIntField(String fieldName) {
        return ((BInteger)this.value.get(fieldName)).intValue();
    }

    @Override
    public long getDefaultableIntField(String fieldName) {
        if (this.value.get(fieldName) != null) {
            return this.getIntField(fieldName);
        }
        return 0L;
    }

    @Override
    public double getFloatField(String fieldName) {
        return ((BFloat)this.value.get(fieldName)).floatValue();
    }

    @Override
    public String getStringField(String fieldName) {
        return this.value.get(fieldName).stringValue();
    }

    @Override
    public boolean getBooleanField(String fieldName) {
        return ((BBoolean)this.value.get(fieldName)).booleanValue();
    }

    @Override
    public Struct getStructField(String fieldName) {
        BMap refField = (BMap)this.value.get(fieldName);
        if (refField == null) {
            return null;
        }
        return new StructImpl(refField);
    }

    @Override
    public BMap getServiceField(String fieldName) {
        return (BMap)this.value.get(fieldName);
    }

    @Override
    public Value[] getArrayField(String fieldName) {
        BNewArray refField = (BNewArray)this.value.get(fieldName);
        if (refField == null) {
            return null;
        }
        ArrayList<ValueImpl> list = new ArrayList<ValueImpl>();
        BIterator bIterator = refField.newIterator();
        while (bIterator.hasNext()) {
            list.add(ValueImpl.createValue(bIterator.getNext()));
        }
        return list.toArray(new Value[0]);
    }

    @Override
    public BValue getVMValue() {
        return this.value;
    }

    @Override
    public Map<String, Value> getMapField(String fieldName) {
        BMap refField = (BMap)this.value.get(fieldName);
        if (refField == null) {
            return null;
        }
        LinkedHashMap<String, Value> valueMap = new LinkedHashMap<String, Value>();
        BIterator bIterator = refField.newIterator();
        while (bIterator.hasNext()) {
            BValueArray next = (BValueArray)bIterator.getNext();
            valueMap.put(next.getRefValue(0L).stringValue(), ValueImpl.createValue(next.getRefValue(1L)));
        }
        return valueMap;
    }

    @Override
    public Value getTypeField(String fieldName) {
        BTypeDescValue refField = (BTypeDescValue)this.value.get(fieldName);
        if (refField == null) {
            return null;
        }
        return ValueImpl.createValue(refField);
    }

    @Override
    public Value getRefField(String fieldName) {
        BValue refField = this.value.get(fieldName);
        if (refField == null) {
            return null;
        }
        return ValueImpl.createValue(refField);
    }

    @Override
    public List<Annotation> getAnnotationList(String pkgPath, String name) {
        String key = pkgPath + ":" + name;
        return (List)this.annotationMap.get(key);
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.value.addNativeData(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.value.getNativeData(key);
    }

    @Override
    public String getAnnotationEntryKey() {
        return this.getName();
    }

    private static void setIndex(StructFieldImpl structField, int[] currentIndex) {
        switch (structField.field.getTag()) {
            case 1: {
                structField.index = currentIndex[0] = currentIndex[0] + 1;
                break;
            }
            case 3: {
                structField.index = currentIndex[1] = currentIndex[1] + 1;
                break;
            }
            case 5: {
                structField.index = currentIndex[2] = currentIndex[2] + 1;
                break;
            }
            case 6: {
                structField.index = currentIndex[3] = currentIndex[3] + 1;
                break;
            }
            default: {
                structField.index = currentIndex[5] = currentIndex[5] + 1;
            }
        }
    }

    static class StructFieldImpl
    implements StructField {
        private final String name;
        private final Value.Type field;
        protected int index;

        StructFieldImpl(String name, int tag) {
            this.name = name;
            this.field = Value.Type.getType(tag);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Value.Type getFieldType() {
            return this.field;
        }
    }
}

