/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.connector.impl.StructImpl;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public class ValueImpl
implements Value {
    private Value.Type type;
    private long intValue;
    private double floatValue;
    private String stringValue;
    private boolean booleanValue;
    private StructImpl structValue;
    private BValue value;

    private ValueImpl(Value.Type type, BValue value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public Value.Type getType() {
        return this.type;
    }

    @Override
    public long getIntValue() {
        return this.intValue;
    }

    @Override
    public double getFloatValue() {
        return this.floatValue;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    @Override
    public Struct getStructValue() {
        return this.structValue;
    }

    @Override
    public BValue getVMValue() {
        return this.value;
    }

    public static ValueImpl createValue(BValue value) {
        if (value == null) {
            return null;
        }
        ValueImpl val = new ValueImpl(Value.Type.getType(value), value);
        switch (val.type) {
            case INT: {
                val.intValue = ((BValueType)value).intValue();
                break;
            }
            case FLOAT: {
                val.floatValue = ((BValueType)value).floatValue();
                break;
            }
            case BOOLEAN: {
                val.booleanValue = ((BValueType)value).booleanValue();
                break;
            }
            case OBJECT: 
            case RECORD: {
                val.structValue = new StructImpl((BMap)value);
                break;
            }
            case NULL: {
                break;
            }
            default: {
                val.stringValue = value.stringValue();
            }
        }
        return val;
    }
}

