/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Struct;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.JSONDataSource;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableJSONDataSource
implements JSONDataSource {
    private BTable df;
    private JSONObjectGenerator objGen;

    public TableJSONDataSource(BTable df) {
        this(df, new DefaultJSONObjectGenerator());
    }

    private TableJSONDataSource(BTable df, JSONObjectGenerator objGen) {
        this.df = df;
        this.objGen = objGen;
    }

    @Override
    public void serialize(JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        while (this.hasNext()) {
            gen.serialize(this.next());
        }
        gen.writeEndArray();
    }

    @Override
    public boolean hasNext() {
        return this.df.hasNext();
    }

    @Override
    public BRefType<?> next() {
        try {
            this.df.moveToNext();
            return this.objGen.transform(this.df);
        }
        catch (IOException e) {
            throw new BLangRuntimeException("error while geting next data", e);
        }
    }

    @Override
    public BRefType<?> build() {
        BValueArray values = new BValueArray(new BArrayType(BTypes.typeJSON));
        while (this.hasNext()) {
            values.append(this.next());
        }
        return values;
    }

    private static void constructJsonData(BTable df, BMap<String, BRefType<?>> jsonObject, String name, TypeKind type, int index, BField[] structFields) {
        switch (type) {
            case STRING: {
                jsonObject.put(name, TableJSONDataSource.getBString(df.getString(index)));
                break;
            }
            case INT: {
                Long intVal = df.getInt(index);
                jsonObject.put(name, intVal == null ? null : new BInteger(intVal));
                break;
            }
            case FLOAT: {
                Double floatVal = df.getFloat(index);
                jsonObject.put(name, floatVal == null ? null : new BFloat(floatVal));
                break;
            }
            case DECIMAL: {
                BigDecimal decimalVal = df.getDecimal(index);
                jsonObject.put(name, decimalVal == null ? null : new BDecimal(decimalVal));
                break;
            }
            case BOOLEAN: {
                Boolean boolVal = df.getBoolean(index);
                jsonObject.put(name, boolVal == null ? null : new BBoolean(boolVal));
                break;
            }
            case BLOB: {
                jsonObject.put(name, TableJSONDataSource.getBString(df.getBlob(index)));
                break;
            }
            case ARRAY: {
                jsonObject.put(name, TableJSONDataSource.getDataArray(df, index));
                break;
            }
            case JSON: {
                jsonObject.put(name, df.getString(index) == null ? null : JsonParser.parse(df.getString(index)));
                break;
            }
            case OBJECT: 
            case RECORD: {
                jsonObject.put(name, TableJSONDataSource.getStructData(df.getStruct(index), structFields, index));
                break;
            }
            case XML: {
                jsonObject.put(name, TableJSONDataSource.getBString(df.getString(index)));
                break;
            }
            default: {
                jsonObject.put(name, TableJSONDataSource.getBString(df.getString(index)));
            }
        }
    }

    private static BRefType<?> getStructData(Object[] data, BField[] structFields, int index) {
        try {
            if (structFields == null) {
                BValueArray jsonArray = new BValueArray(new BArrayType(BTypes.typeJSON));
                if (data != null) {
                    for (Object value : data) {
                        if (value instanceof String) {
                            jsonArray.append(new BString((String)value));
                            continue;
                        }
                        if (value instanceof Boolean) {
                            jsonArray.append(new BBoolean((Boolean)value));
                            continue;
                        }
                        if (value instanceof Long) {
                            jsonArray.append(new BInteger((Long)value));
                            continue;
                        }
                        if (value instanceof Double) {
                            jsonArray.append(new BFloat((Double)value));
                            continue;
                        }
                        if (value instanceof Integer) {
                            jsonArray.append(new BInteger(((Integer)value).intValue()));
                            continue;
                        }
                        if (value instanceof Float) {
                            jsonArray.append(new BFloat(((Float)value).floatValue()));
                            continue;
                        }
                        if (!(value instanceof BigDecimal)) continue;
                        jsonArray.append(new BFloat(((BigDecimal)value).doubleValue()));
                    }
                }
                return jsonArray;
            }
            BMap<String, BValue> jsonData = new BMap<String, BValue>();
            boolean structError = true;
            if (data != null) {
                int i = 0;
                for (Object value : data) {
                    BField[] internalStructFields;
                    BType internaltType = structFields[index - 1].fieldType;
                    if ((internaltType.getTag() == 33 || internaltType.getTag() == 12) && (internalStructFields = ((BStructureType)internaltType).getFields().values().toArray(new BField[0])) != null) {
                        if (value instanceof String) {
                            jsonData.put(internalStructFields[i].fieldName, new BString((String)value));
                        } else if (value instanceof Boolean) {
                            jsonData.put(internalStructFields[i].fieldName, new BBoolean((Boolean)value));
                        } else if (value instanceof Long) {
                            jsonData.put(internalStructFields[i].fieldName, new BInteger((Long)value));
                        } else if (value instanceof Double) {
                            jsonData.put(internalStructFields[i].fieldName, new BFloat((Double)value));
                        } else if (value instanceof Integer) {
                            jsonData.put(internalStructFields[i].fieldName, new BInteger(((Integer)value).intValue()));
                        } else if (value instanceof Float) {
                            jsonData.put(internalStructFields[i].fieldName, new BFloat(((Float)value).floatValue()));
                        } else if (value instanceof BigDecimal) {
                            jsonData.put(internalStructFields[i].fieldName, new BFloat(((BigDecimal)value).doubleValue()));
                        } else if (value instanceof Struct) {
                            jsonData.put(internalStructFields[i].fieldName, TableJSONDataSource.getStructData(((Struct)value).getAttributes(), internalStructFields, i + 1));
                        }
                        structError = false;
                    }
                    ++i;
                }
            }
            if (structError) {
                throw new BallerinaException("error in constructing the json object from struct type data");
            }
            return jsonData;
        }
        catch (SQLException e) {
            throw new BallerinaException("error in retrieving struct data to construct the inner json object:" + e.getMessage());
        }
    }

    private static BRefType<?> getDataArray(BTable df, int columnIndex) {
        BValueArray jsonArray;
        block8: {
            Object obj;
            Object[] dataArray;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    dataArray = df.getArray(columnIndex);
                                    int length = dataArray.length;
                                    jsonArray = new BValueArray(new BArrayType(BTypes.typeJSON));
                                    if (length <= 0) break block8;
                                    obj = dataArray[0];
                                    if (!(obj instanceof String)) break block9;
                                    for (Object value : dataArray) {
                                        jsonArray.append(new BString((String)value));
                                    }
                                    break block8;
                                }
                                if (!(obj instanceof Boolean)) break block10;
                                for (Object value : dataArray) {
                                    jsonArray.append(new BBoolean((Boolean)value));
                                }
                                break block8;
                            }
                            if (!(obj instanceof Integer)) break block11;
                            for (Object value : dataArray) {
                                jsonArray.append(new BInteger(((Integer)value).intValue()));
                            }
                            break block8;
                        }
                        if (!(obj instanceof Long)) break block12;
                        for (Object value : dataArray) {
                            jsonArray.append(new BInteger((Long)value));
                        }
                        break block8;
                    }
                    if (!(obj instanceof Float)) break block13;
                    for (Object value : dataArray) {
                        jsonArray.append(new BFloat(((Float)value).floatValue()));
                    }
                    break block8;
                }
                if (!(obj instanceof Double)) break block14;
                for (Object value : dataArray) {
                    jsonArray.append(new BFloat((Double)value));
                }
                break block8;
            }
            if (!(obj instanceof BigDecimal)) break block8;
            for (Object value : dataArray) {
                if (value != null) {
                    jsonArray.append(new BFloat(((BigDecimal)value).doubleValue()));
                    continue;
                }
                jsonArray.append(null);
            }
        }
        return jsonArray;
    }

    private static BString getBString(String str) {
        return str != null ? new BString(str) : null;
    }

    public static interface JSONObjectGenerator {
        public BRefType<?> transform(BTable var1) throws IOException;
    }

    private static class DefaultJSONObjectGenerator
    implements JSONObjectGenerator {
        private DefaultJSONObjectGenerator() {
        }

        @Override
        public BRefType<?> transform(BTable df) throws IOException {
            BMap objNode = new BMap(BTypes.typeJSON);
            BStructureType structType = df.getStructType();
            BField[] structFields = null;
            if (structType != null) {
                structFields = structType.getFields().values().toArray(new BField[0]);
            }
            int index = 0;
            for (ColumnDefinition col : df.getColumnDefs()) {
                String name = structFields != null ? structFields[index].getFieldName() : col.getName();
                TableJSONDataSource.constructJsonData(df, objNode, name, col.getType(), index + 1, structFields);
                ++index;
            }
            return objNode;
        }
    }
}

