/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BValue;

public class BFiniteType
extends BType {
    public Set<BValue> valueSpace = new LinkedHashSet<BValue>();

    public BFiniteType(String typeName, String pkgPath) {
        super(typeName, pkgPath, BValue.class);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFiniteType)) {
            return false;
        }
        BFiniteType that = (BFiniteType)o;
        return this.valueSpace.size() == that.valueSpace.size() && this.valueSpace.containsAll(that.valueSpace);
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        if (this.valueSpace.stream().anyMatch(val -> val == null || val.getType().isNilable())) {
            return null;
        }
        Iterator<BValue> valueIterator = this.valueSpace.iterator();
        BValue firstVal = valueIterator.next();
        if (this.isSingletonType()) {
            return (V)firstVal;
        }
        Object implicitInitValOfType = firstVal.getType().getZeroValue();
        if (implicitInitValOfType.equals(firstVal)) {
            return implicitInitValOfType;
        }
        while (valueIterator.hasNext()) {
            BValue value = valueIterator.next();
            if (!implicitInitValOfType.equals(value)) continue;
            return implicitInitValOfType;
        }
        return null;
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        if (this.valueSpace.stream().anyMatch(val -> val == null || val.getType().isNilable())) {
            return null;
        }
        Iterator<BValue> valueIterator = this.valueSpace.iterator();
        BValue firstVal = valueIterator.next();
        if (this.isSingletonType()) {
            return (V)firstVal;
        }
        Object implicitInitValOfType = firstVal.getType().getEmptyValue();
        if (implicitInitValOfType.equals(firstVal)) {
            return implicitInitValOfType;
        }
        while (valueIterator.hasNext()) {
            BValue value = valueIterator.next();
            if (!implicitInitValOfType.equals(value)) continue;
            return implicitInitValOfType;
        }
        return null;
    }

    @Override
    public int getTag() {
        return 32;
    }

    private boolean isSingletonType() {
        return this.valueSpace.size() == 1;
    }
}

