/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util;

import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.util.exceptions.BLangFreezeException;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public class FreezeUtils {
    public static boolean isOpenForFreeze(BVM.FreezeStatus currentFreezeStatus, BVM.FreezeStatus receivedFreezeStatus) {
        switch (currentFreezeStatus.getState()) {
            case FROZEN: {
                return false;
            }
            case MID_FREEZE: {
                if (currentFreezeStatus == receivedFreezeStatus) {
                    return false;
                }
                throw new BallerinaException(BallerinaErrorReasons.CONCURRENT_MODIFICATION_ERROR, "concurrent 'freeze()' attempts not allowed");
            }
        }
        return true;
    }

    public static void handleInvalidUpdate(BVM.FreezeStatus.State currentState) {
        switch (currentState) {
            case FROZEN: {
                throw new BLangFreezeException(BallerinaErrorReasons.INVALID_UPDATE_ERROR, "modification not allowed on frozen value");
            }
            case MID_FREEZE: {
                throw new BLangFreezeException(BallerinaErrorReasons.INVALID_UPDATE_ERROR, "modification not allowed during freeze");
            }
        }
    }
}

