/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.types.BIndexedType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.siddhi.core.stream.input.InputHandler;
import org.ballerinalang.streams.StreamSubscriptionManager;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BStream
implements BRefType<Object> {
    private static final String TOPIC_NAME_PREFIX = "TOPIC_NAME_";
    private BType type;
    private BType constraintType;
    private String streamId = "";
    private StreamSubscriptionManager streamSubscriptionManager;
    public String topicName;

    public BStream(BType type, String name) {
        if (((BStreamType)type).getConstrainedType() == null) {
            throw new BallerinaException("a stream cannot be declared without a constraint");
        }
        this.streamSubscriptionManager = StreamSubscriptionManager.getInstance();
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.type = new BStreamType(this.constraintType);
        this.topicName = this.constraintType instanceof BIndexedType ? TOPIC_NAME_PREFIX + ((BIndexedType)((Object)this.constraintType)).getElementType() + "_" + name : (this.constraintType != null ? TOPIC_NAME_PREFIX + this.constraintType + "_" + name : TOPIC_NAME_PREFIX + name);
        this.topicName = this.topicName.concat("_").concat(UUID.randomUUID().toString());
        this.streamId = name;
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String stringValue() {
        return "";
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void stamp(BType type, List<BVM.TypeValuePair> unresolvedValues) {
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return null;
    }

    @Override
    public Object value() {
        return null;
    }

    public BType getConstraintType() {
        return this.constraintType;
    }

    public void publish(BValue data) {
        BType dataType = data.getType();
        if (!BVM.checkCast(data, this.constraintType)) {
            throw new BallerinaException("incompatible types: value of type:" + dataType + " cannot be added to a stream of type:" + this.constraintType);
        }
        this.streamSubscriptionManager.sendMessage(this, data);
    }

    public void subscribe(BFunctionPointer functionPointer) {
        int lastArrayIndex;
        BType[] parameters = functionPointer.value().getParamTypes();
        if (!BVM.isAssignable(this.constraintType, parameters[lastArrayIndex = parameters.length - 1], new ArrayList<BVM.TypePair>())) {
            throw new BallerinaException("incompatible function: subscription function needs to be a function accepting:" + this.constraintType);
        }
        this.streamSubscriptionManager.registerMessageProcessor(this, functionPointer);
    }

    public void subscribe(InputHandler inputHandler) {
        if (this.constraintType.getTag() != 33 && this.constraintType.getTag() != 12) {
            throw new BallerinaException("Streaming Support is only available with streams accepting objects");
        }
        this.streamSubscriptionManager.registerMessageProcessor(this, inputHandler);
    }
}

