/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.JSONDataSource;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BStreamingJSON
extends BValueArray {
    JSONDataSource datasource;

    public BStreamingJSON(JSONDataSource datasource) {
        this.datasource = datasource;
        this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
        this.arrayType = new BArrayType(BTypes.typeJSON);
    }

    @Override
    public void add(long index, BRefType<?> value) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        super.add(index, value);
    }

    @Override
    public void append(BRefType<?> value) {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        super.append(value);
    }

    @Override
    public BRefType<?> getRefValue(long index) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        return super.getRefValue(index);
    }

    public void serialize(JsonGenerator gen) {
        try {
            gen.writeStartArray();
            for (int i = 0; i < this.size; ++i) {
                gen.serialize(this.refValues[i]);
            }
            while (this.datasource.hasNext()) {
                gen.serialize(this.datasource.next());
            }
            gen.writeEndArray();
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("error occurred while serializing data", e);
        }
    }

    public void serialize(Writer writer) {
        this.serialize(new JsonGenerator(writer));
    }

    @Override
    public void serialize(OutputStream outputStream) {
        this.serialize(new JsonGenerator(outputStream));
    }

    @Override
    public BRefType<?>[] getValues() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.refValues;
    }

    @Override
    public String stringValue() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.stringValue();
    }

    @Override
    public BIterator newIterator() {
        return new BStreamingJSONIterator(this);
    }

    @Override
    public long size() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.size;
    }

    void appendToCache(BRefType<?> value) {
        super.add((long)this.size, value);
    }

    private void buildDatasource() {
        try {
            while (this.datasource.hasNext()) {
                this.appendToCache(this.datasource.next());
            }
        }
        catch (Throwable t) {
            throw new BallerinaException("error occurred while building JSON: ", t);
        }
    }

    static class BStreamingJSONIterator
    implements BIterator {
        BStreamingJSON array;
        long cursor = 0L;

        BStreamingJSONIterator(BStreamingJSON value) {
            this.array = value;
        }

        @Override
        public BValue getNext() {
            BRefType<?> value;
            if (this.cursor < (long)this.array.size) {
                value = this.array.getBValue(this.cursor);
            } else {
                BRefType<?> nextVal = this.array.datasource.next();
                this.array.appendToCache(nextVal);
                value = nextVal;
            }
            ++this.cursor;
            return value;
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < (long)this.array.size) {
                return true;
            }
            return this.array.datasource.hasNext();
        }

        @Override
        public void stamp(BType type, List<BVM.TypeValuePair> unresolvedValues) {
        }
    }
}

