/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.values.BValue;

public abstract class BValueType
implements BValue {
    public abstract long intValue();

    public abstract long byteValue();

    public abstract double floatValue();

    public abstract BigDecimal decimalValue();

    public abstract boolean booleanValue();

    @Override
    public void attemptFreeze(BVM.FreezeStatus freezeStatus) {
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    public String toString() {
        return this.stringValue();
    }

    public abstract void setType(BType var1);

    @Override
    public void stamp(BType type, List<BVM.TypeValuePair> unresolvedValues) {
        if (type.getTag() == 11 || type.getTag() == 7) {
            return;
        }
        if (type.getTag() == 20) {
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                if (!BVM.checkIsLikeType(this, memberType, new ArrayList<BVM.TypeValuePair>())) continue;
                this.stamp(memberType, unresolvedValues);
                type = memberType.getTag() == 11 || memberType.getTag() == 7 ? this.getType() : memberType;
                break;
            }
        }
        this.setType(type);
    }
}

