/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence;

import java.util.List;
import org.ballerinalang.bre.old.BLangScheduler;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.persistence.states.RuntimeStates;
import org.ballerinalang.persistence.states.State;
import org.ballerinalang.persistence.store.PersistenceStore;
import org.ballerinalang.util.codegen.ProgramFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryTask
implements Runnable {
    private ProgramFile programFile;
    private static final Logger logger = LoggerFactory.getLogger(RecoveryTask.class);

    public RecoveryTask(ProgramFile programFile) {
        this.programFile = programFile;
    }

    @Override
    public void run() {
        List<State> states = PersistenceStore.getStates(this.programFile);
        if (states.isEmpty()) {
            return;
        }
        logger.debug("RecoveryTask: Starting saved states.");
        states.forEach(state -> {
            WorkerExecutionContext context = state.getContext();
            context.runInCaller = false;
            BLangScheduler.schedule(context);
            RuntimeStates.add(state);
        });
    }
}

