/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence.store.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.persistence.store.StorageProvider;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageProvider
implements StorageProvider {
    public static final String INTERRUPTIBLE_STATES_FILE_PATH = "ballerina.interruptible.directory.path";
    private static String stateStoreDirPath = "ballerina-states";
    private static final Logger log = LoggerFactory.getLogger(FileStorageProvider.class);

    @Override
    public void persistState(String stateId, String stateString) {
        File baseDir = new File(stateStoreDirPath);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        try {
            String fileName = baseDir.getPath() + File.separator + stateId;
            Path path = Paths.get(fileName + ".tmp", new String[0]);
            Files.write(path, stateString.getBytes(), new OpenOption[0]);
            path.toFile().renameTo(new File(fileName + ".json"));
        }
        catch (IOException e) {
            log.error("Error while persisting the state for state id: {}", (Object)stateId, (Object)e);
        }
    }

    @Override
    public void removeActiveState(String stateId) {
        File baseDir = new File(stateStoreDirPath);
        if (!baseDir.exists()) {
            return;
        }
        try {
            Files.delete(Paths.get(baseDir.getPath() + File.separator + stateId + ".json", new String[0]));
        }
        catch (IOException e) {
            log.error("Error while removing the state for state id: {}", (Object)stateId, (Object)e);
        }
    }

    @Override
    public List<String> getAllSerializedStates() {
        LinkedList<String> states = new LinkedList<String>();
        File baseDir = new File(stateStoreDirPath);
        if (!baseDir.exists()) {
            return states;
        }
        try (Stream<Path> stream = Files.list(Paths.get(stateStoreDirPath, new String[0]));){
            stream.forEach(path -> {
                try {
                    if (path.toString().endsWith(".json")) {
                        states.add(new String(Files.readAllBytes(path)));
                    } else {
                        Files.delete(path);
                    }
                }
                catch (IOException e) {
                    throw new BallerinaException("Error occurred while reading state from file path: " + path, e);
                }
            });
        }
        catch (IOException e) {
            throw new BallerinaException("Failed to retrieve states.", e);
        }
        return states;
    }

    static {
        String pathPropValue = ConfigRegistry.getInstance().getAsString(INTERRUPTIBLE_STATES_FILE_PATH);
        if (pathPropValue != null) {
            stateStoreDirPath = pathPropValue;
        }
    }
}

