/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.runtime.threadpool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.runtime.threadpool.BLangThreadFactory;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.omg.PortableServer.ThreadPolicyOperations;

public class ThreadPoolFactory {
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private static final int MAX_THREAD_POOL_SIZE = 1000;
    private static final int MIN_THREAD_POOL_SIZE = 1;
    private static final String WORKER_THREAD_POOL_SIZE_PROP = "b7a.runtime.scheduler.threadpoolsize";
    private static ThreadPoolFactory instance;
    private ExecutorService workerExecutor;

    private ThreadPoolFactory() {
        int poolSize = this.extractThreadPoolSize();
        this.workerExecutor = Executors.newFixedThreadPool(poolSize, new BLangThreadFactory(new ThreadGroup("worker"), "worker-thread-pool"));
    }

    private int extractThreadPoolSize() {
        int poolSize = 100;
        String workerThreadPoolSizeProp = ConfigRegistry.getInstance().getAsString(WORKER_THREAD_POOL_SIZE_PROP);
        if (workerThreadPoolSizeProp != null) {
            try {
                poolSize = Integer.parseInt(workerThreadPoolSizeProp);
                if (poolSize < 1 || poolSize > 1000) {
                    throw new BallerinaException("b7a.runtime.scheduler.threadpoolsize must be between 1 and 1000 (inclusive)");
                }
            }
            catch (NumberFormatException ignore) {
                throw new BallerinaException("invalid value for 'b7a.runtime.scheduler.threadpoolsize': " + workerThreadPoolSizeProp);
            }
        }
        return poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolFactory getInstance() {
        if (instance != null) return instance;
        Class<ThreadPolicyOperations> clazz = ThreadPolicyOperations.class;
        synchronized (ThreadPolicyOperations.class) {
            if (instance != null) return instance;
            instance = new ThreadPoolFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ExecutorService getWorkerExecutor() {
        return this.workerExecutor;
    }
}

