/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.codegen.CustomTypeInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.codegen.TypeDefInfo;
import org.ballerinalang.util.codegen.TypeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.attributes.LineNumberTableAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.ConstantPool;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.exceptions.BallerinaException;

public class PackageInfo
implements ConstantPool,
AttributeInfoPool {
    public int orgNameCPIndex;
    public int nameCPIndex;
    public String pkgPath;
    public int versionCPIndex;
    public String pkgVersion;
    private FunctionInfo initFunctionInfo;
    private FunctionInfo startFunctionInfo;
    private FunctionInfo stopFunctionInfo;
    private FunctionInfo testInitFunctionInfo;
    private FunctionInfo testStartFunctionInfo;
    private FunctionInfo testStopFunctionInfo;
    public int pkgIndex;
    private ConstantPoolEntry[] constPool;
    private List<ConstantPoolEntry> constantPoolEntries = new ArrayList<ConstantPoolEntry>();
    private Instruction[] instructions;
    private List<Instruction> instructionList = new ArrayList<Instruction>();
    private Map<String, PackageVarInfo> globalVarInfoMap = new LinkedHashMap<String, PackageVarInfo>();
    private Map<String, FunctionInfo> functionInfoMap = new LinkedHashMap<String, FunctionInfo>();
    private Map<String, ServiceInfo> serviceInfoMap = new HashMap<String, ServiceInfo>();
    private Map<String, CustomTypeInfo> structureTypeInfoMap = new HashMap<String, CustomTypeInfo>();
    private Map<AttributeInfo.Kind, AttributeInfo> attributeInfoMap = new HashMap<AttributeInfo.Kind, AttributeInfo>();
    public Map<String, TypeDefInfo> typeDefInfoMap = new HashMap<String, TypeDefInfo>();
    ProgramFile programFile;

    public int getPkgNameCPIndex() {
        return this.nameCPIndex;
    }

    public String getPkgPath() {
        return this.pkgPath;
    }

    public int getPackageVersionCPIndex() {
        return this.versionCPIndex;
    }

    public String getPackageVersion() {
        return this.pkgVersion;
    }

    @Override
    public int addCPEntry(ConstantPoolEntry cpEntry) {
        this.constantPoolEntries.add(cpEntry);
        return this.constantPoolEntries.size() - 1;
    }

    @Override
    public ConstantPoolEntry getCPEntry(int index) {
        return this.constantPoolEntries.get(index);
    }

    @Override
    public int getCPEntryIndex(ConstantPoolEntry cpEntry) {
        return this.constantPoolEntries.indexOf(cpEntry);
    }

    @Override
    public ConstantPoolEntry[] getConstPoolEntries() {
        return this.constPool;
    }

    public PackageVarInfo getPackageVarInfo(String globalVarName) {
        return this.globalVarInfoMap.get(globalVarName);
    }

    public void addPackageVarInfo(String globalVarName, PackageVarInfo packageVarInfo) {
        this.globalVarInfoMap.put(globalVarName, packageVarInfo);
    }

    public PackageVarInfo[] getPackageInfoEntries() {
        return this.globalVarInfoMap.values().toArray(new PackageVarInfo[0]);
    }

    public FunctionInfo getFunctionInfo(String functionName) {
        return this.functionInfoMap.get(functionName);
    }

    public void addFunctionInfo(String functionName, FunctionInfo functionInfo) {
        this.functionInfoMap.put(functionName, functionInfo);
    }

    public FunctionInfo[] getFunctionInfoEntries() {
        return this.functionInfoMap.values().toArray(new FunctionInfo[0]);
    }

    public StructureTypeInfo getStructInfo(String name) {
        TypeInfo typeInfo = this.typeDefInfoMap.get((Object)name).typeInfo;
        if (typeInfo == null || typeInfo.getType().getTag() != 33 && typeInfo.getType().getTag() != 12) {
            throw new BallerinaException("structure - " + name + " does not exist");
        }
        return (StructureTypeInfo)this.typeDefInfoMap.get((Object)name).typeInfo;
    }

    public TypeInfo getTypeInfo(String name) {
        return this.typeDefInfoMap.get((Object)name).typeInfo;
    }

    public void addTypeDefInfo(String typeDefinitionName, TypeDefInfo typeDefinitionInfo) {
        this.typeDefInfoMap.put(typeDefinitionName, typeDefinitionInfo);
        this.structureTypeInfoMap.put(typeDefinitionName, typeDefinitionInfo);
    }

    public TypeDefInfo[] getTypeDefInfoEntries() {
        return this.typeDefInfoMap.values().toArray(new TypeDefInfo[0]);
    }

    public TypeDefInfo getTypeDefInfo(String typeDefName) {
        return this.typeDefInfoMap.get(typeDefName);
    }

    public ServiceInfo[] getServiceInfoEntries() {
        return this.serviceInfoMap.values().toArray(new ServiceInfo[0]);
    }

    public ServiceInfo getServiceInfo(String serviceName) {
        return this.serviceInfoMap.get(serviceName);
    }

    public ServiceInfo getServiceInfo(BType serviceType) {
        return this.serviceInfoMap.values().stream().filter(serviceInfo -> serviceInfo.serviceType.getType().equals(serviceType)).findFirst().orElse(null);
    }

    public void addServiceInfo(String serviceName, ServiceInfo serviceInfo) {
        serviceInfo.setPackageInfo(this);
        this.serviceInfoMap.put(serviceName, serviceInfo);
    }

    public CustomTypeInfo getStructureTypeInfo(String structureTypeName) {
        return this.structureTypeInfoMap.get(structureTypeName);
    }

    public int addInstruction(Instruction instruction) {
        this.instructionList.add(instruction);
        return this.instructionList.size() - 1;
    }

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public int getInstructionCount() {
        return this.instructionList.size();
    }

    public LineNumberInfo getLineNumberInfo(LineNumberInfo lineNumberInfo) {
        LineNumberTableAttributeInfo lineNumberTableAttributeInfo = (LineNumberTableAttributeInfo)this.attributeInfoMap.get((Object)AttributeInfo.Kind.LINE_NUMBER_TABLE_ATTRIBUTE);
        List<LineNumberInfo> lineNumberInfos = lineNumberTableAttributeInfo.getLineNumberInfoList();
        int index = lineNumberInfos.indexOf(lineNumberInfo);
        if (index >= 0) {
            return lineNumberInfos.get(index);
        }
        return null;
    }

    public LineNumberInfo getLineNumberInfo(int currentIP) {
        LineNumberTableAttributeInfo lineNumberTableAttributeInfo = (LineNumberTableAttributeInfo)this.attributeInfoMap.get((Object)AttributeInfo.Kind.LINE_NUMBER_TABLE_ATTRIBUTE);
        ArrayList<LineNumberInfo> lineNumberInfos = new ArrayList<LineNumberInfo>(lineNumberTableAttributeInfo.getLineNumberInfoList());
        Collections.reverse(lineNumberInfos);
        for (LineNumberInfo lineNumberInfo : lineNumberInfos) {
            if (currentIP < lineNumberInfo.getIp()) continue;
            return lineNumberInfo;
        }
        return null;
    }

    public ProgramFile getProgramFile() {
        return this.programFile;
    }

    public void setProgramFile(ProgramFile programFile) {
        this.programFile = programFile;
    }

    public FunctionInfo getInitFunctionInfo() {
        return this.initFunctionInfo;
    }

    public void setInitFunctionInfo(FunctionInfo initFunctionInfo) {
        this.initFunctionInfo = initFunctionInfo;
    }

    public FunctionInfo getStartFunctionInfo() {
        return this.startFunctionInfo;
    }

    public void setStartFunctionInfo(FunctionInfo startFunctionInfo) {
        this.startFunctionInfo = startFunctionInfo;
    }

    public FunctionInfo getStopFunctionInfo() {
        return this.stopFunctionInfo;
    }

    public void setStopFunctionInfo(FunctionInfo stopFunctionInfo) {
        this.stopFunctionInfo = stopFunctionInfo;
    }

    public void complete() {
        this.constPool = this.constantPoolEntries.toArray(new ConstantPoolEntry[0]);
        this.instructions = this.instructionList.toArray(new Instruction[0]);
    }

    public FunctionInfo getTestInitFunctionInfo() {
        return this.testInitFunctionInfo;
    }

    public void setTestInitFunctionInfo(FunctionInfo testInitFunctionInfo) {
        this.testInitFunctionInfo = testInitFunctionInfo;
    }

    public FunctionInfo getTestStartFunctionInfo() {
        return this.testStartFunctionInfo;
    }

    public void setTestStartFunctionInfo(FunctionInfo testStartFunctionInfo) {
        this.testStartFunctionInfo = testStartFunctionInfo;
    }

    public FunctionInfo getTestStopFunctionInfo() {
        return this.testStopFunctionInfo;
    }

    public void setTestStopFunctionInfo(FunctionInfo testStopFunctionInfo) {
        this.testStopFunctionInfo = testStopFunctionInfo;
    }

    @Override
    public AttributeInfo getAttributeInfo(AttributeInfo.Kind attributeKind) {
        return this.attributeInfoMap.get((Object)attributeKind);
    }

    @Override
    public void addAttributeInfo(AttributeInfo.Kind attributeKind, AttributeInfo attributeInfo) {
        this.attributeInfoMap.put(attributeKind, attributeInfo);
    }

    @Override
    public AttributeInfo[] getAttributeInfoEntries() {
        return this.attributeInfoMap.values().toArray(new AttributeInfo[0]);
    }
}

