/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen.cpentries;

import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.wso2.ballerinalang.programfile.ConstantValue;
import org.wso2.ballerinalang.programfile.KeyInfo;

public class MapCPEntry
implements ConstantPoolEntry {
    private Map<KeyInfo, ConstantValue> constantValueMap;
    private BMap<String, BRefType> bMap;

    public MapCPEntry(Map<KeyInfo, ConstantValue> constantValueMap, BMap<String, BRefType> bMap) {
        this.constantValueMap = constantValueMap;
        this.bMap = bMap;
        this.bMap.attemptFreeze(new BVM.FreezeStatus(BVM.FreezeStatus.State.FROZEN));
    }

    public Map<KeyInfo, ConstantValue> getConstantValueMap() {
        return this.constantValueMap;
    }

    public BMap<String, BRefType> getBMap() {
        return this.bMap;
    }

    @Override
    public ConstantPoolEntry.EntryType getEntryType() {
        return ConstantPoolEntry.EntryType.CP_ENTRY_MAP;
    }

    public boolean equals(Object o) {
        ConstantValue value2;
        ConstantValue value1;
        KeyInfo key;
        if (!(o instanceof MapCPEntry)) {
            return false;
        }
        MapCPEntry mapCPEntry = (MapCPEntry)o;
        if (this.constantValueMap.size() != mapCPEntry.constantValueMap.size()) {
            return false;
        }
        for (Map.Entry<KeyInfo, ConstantValue> entry : mapCPEntry.constantValueMap.entrySet()) {
            key = entry.getKey();
            if (!this.constantValueMap.containsKey(key)) {
                return false;
            }
            value1 = entry.getValue();
            if (value1.equals((Object)(value2 = this.constantValueMap.get(key)))) continue;
            return false;
        }
        for (Map.Entry<KeyInfo, ConstantValue> entry : this.constantValueMap.entrySet()) {
            key = entry.getKey();
            if (!mapCPEntry.constantValueMap.containsKey(key)) {
                return false;
            }
            value1 = entry.getValue();
            if (value1.equals((Object)(value2 = mapCPEntry.constantValueMap.get(key)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.constantValueMap.hashCode();
    }
}

