/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ServiceLoader;
import org.ballerinalang.bre.old.BLangScheduler;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.LaunchListener;
import org.ballerinalang.util.metrics.BallerinaMetricsObserver;
import org.ballerinalang.util.metrics.DefaultMetricRegistry;
import org.ballerinalang.util.metrics.Gauge;
import org.ballerinalang.util.metrics.MetricRegistry;
import org.ballerinalang.util.metrics.PolledGauge;
import org.ballerinalang.util.metrics.noop.NoOpMetricProvider;
import org.ballerinalang.util.metrics.noop.NoOpMetricReporter;
import org.ballerinalang.util.metrics.spi.MetricProvider;
import org.ballerinalang.util.metrics.spi.MetricReporter;
import org.ballerinalang.util.observability.ObserveUtils;
import org.ballerinalang.util.tracer.exception.InvalidConfigurationException;

public class MetricsLaunchListener
implements LaunchListener {
    private static final PrintStream consoleError = System.err;
    private static final String METRIC_PROVIDER_NAME = "b7a.observability.metrics.provider";
    private static final String METRIC_REPORTER_NAME = "b7a.observability.metrics.reporter";
    private static final String DEFAULT_METRIC_PROVIDER_NAME = "default";
    private static final String DEFAULT_METRIC_REPORTER_NAME = "prometheus";

    @Override
    public void beforeRunProgram(boolean service) {
        if (DefaultMetricRegistry.getInstance() == null) {
            ConfigRegistry configRegistry = ConfigRegistry.getInstance();
            if (!configRegistry.getAsBoolean("b7a.observability.metrics.enabled")) {
                DefaultMetricRegistry.setInstance(new MetricRegistry(new NoOpMetricProvider()));
                return;
            }
            MetricProvider metricProvider = this.loadMetricProvider(configRegistry);
            metricProvider.init();
            DefaultMetricRegistry.setInstance(new MetricRegistry(metricProvider));
            this.registerBallerinaMetrics();
            MetricReporter reporter = this.loadMetricReporter(configRegistry);
            try {
                reporter.init();
            }
            catch (InvalidConfigurationException e) {
                consoleError.println("Invalid configuration error when initializing metrics reporter. " + e.getMessage());
            }
            ObserveUtils.addObserver(new BallerinaMetricsObserver());
        }
    }

    private MetricProvider loadMetricProvider(ConfigRegistry configRegistry) {
        String providerName = configRegistry.getConfigOrDefault(METRIC_PROVIDER_NAME, DEFAULT_METRIC_PROVIDER_NAME);
        for (MetricProvider temp : ServiceLoader.load(MetricProvider.class)) {
            if (providerName == null || !providerName.equalsIgnoreCase(temp.getName())) continue;
            return temp;
        }
        return new NoOpMetricProvider();
    }

    private MetricReporter loadMetricReporter(ConfigRegistry configRegistry) {
        String reporterName = configRegistry.getConfigOrDefault(METRIC_REPORTER_NAME, DEFAULT_METRIC_REPORTER_NAME);
        for (MetricReporter temp : ServiceLoader.load(MetricReporter.class)) {
            if (reporterName == null || !reporterName.equalsIgnoreCase(temp.getName())) continue;
            return temp;
        }
        return new NoOpMetricReporter();
    }

    private void registerBallerinaMetrics() {
        BLangScheduler.SchedulerStats schedulerStats = BLangScheduler.getStats();
        String prefix = "ballerina_scheduler_";
        PolledGauge.builder("ballerina_scheduler_ready_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getReadyWorkerCount).register();
        PolledGauge.builder("ballerina_scheduler_running_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getRunningWorkerCount).register();
        PolledGauge.builder("ballerina_scheduler_excepted_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getExceptedWorkerCount).register();
        PolledGauge.builder("ballerina_scheduler_paused_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getPausedWorkerCount).register();
        PolledGauge.builder("ballerina_scheduler_waiting_for_response_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getWaitingForResponseWorkerCount).register();
        PolledGauge.builder("ballerina_scheduler_waiting_for_lock_worker_count", schedulerStats, BLangScheduler.SchedulerStats::getWaitingForLockWorkerCount).register();
    }

    @Override
    public void afterRunProgram(boolean service) {
        if (service) {
            Gauge gauge = Gauge.builder("startup_time_milliseconds").description("Startup time in milliseconds").register();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            gauge.setValue(System.currentTimeMillis() - runtimeMXBean.getStartTime());
        }
    }
}

