/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.transactions;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.util.transactions.BallerinaTransactionContext;
import org.ballerinalang.util.transactions.TransactionResourceManager;

public class TransactionLocalContext {
    private String globalTransactionId;
    private String url;
    private String protocol;
    private int transactionLevel;
    private Map<String, Integer> allowedTransactionRetryCounts;
    private Map<String, Integer> currentTransactionRetryCounts;
    private Map<String, BallerinaTransactionContext> transactionContextStore;
    private Stack<String> transactionBlockIdStack;
    private Stack<TransactionFailure> transactionFailure;
    private static final TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
    private boolean isResourceParticipant;

    private TransactionLocalContext(String globalTransactionId, String url, String protocol) {
        this.globalTransactionId = globalTransactionId;
        this.url = url;
        this.protocol = protocol;
        this.transactionLevel = 0;
        this.allowedTransactionRetryCounts = new HashMap<String, Integer>();
        this.currentTransactionRetryCounts = new HashMap<String, Integer>();
        this.transactionContextStore = new HashMap<String, BallerinaTransactionContext>();
        this.transactionBlockIdStack = new Stack();
        this.transactionFailure = new Stack();
    }

    public static TransactionLocalContext createTransactionParticipantLocalCtx(String globalTransactionId, String url, String protocol) {
        TransactionLocalContext localContext = new TransactionLocalContext(globalTransactionId, url, protocol);
        localContext.setResourceParticipant(true);
        return localContext;
    }

    public static TransactionLocalContext create(String globalTransactionId, String url, String protocol) {
        return new TransactionLocalContext(globalTransactionId, url, protocol);
    }

    public String getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public String getCurrentTransactionBlockId() {
        return this.transactionBlockIdStack.peek();
    }

    public boolean hasTransactionBlock() {
        return !this.transactionBlockIdStack.empty();
    }

    public String getURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void beginTransactionBlock(String localTransactionID, int retryCount) {
        this.transactionBlockIdStack.push(localTransactionID);
        this.allowedTransactionRetryCounts.put(localTransactionID, retryCount);
        this.currentTransactionRetryCounts.put(localTransactionID, 0);
        ++this.transactionLevel;
    }

    public void incrementCurrentRetryCount(String localTransactionID) {
        this.currentTransactionRetryCounts.putIfAbsent(localTransactionID, 0);
        this.currentTransactionRetryCounts.computeIfPresent(localTransactionID, (k, v) -> v + 1);
    }

    public BallerinaTransactionContext getTransactionContext(String connectorid) {
        return this.transactionContextStore.get(connectorid);
    }

    public void registerTransactionContext(String connectorid, BallerinaTransactionContext txContext) {
        this.transactionContextStore.put(connectorid, txContext);
    }

    public boolean isRetryAttempt(String transactionId) {
        return this.getCurrentRetryCount(transactionId) > 0;
    }

    public boolean isRetryPossible(Strand context, String transactionId) {
        int allowedRetryCount = this.getAllowedRetryCount(transactionId);
        int currentRetryCount = this.getCurrentRetryCount(transactionId);
        return currentRetryCount < allowedRetryCount || currentRetryCount == 0;
    }

    public boolean onTransactionFailed(Strand context, String transactionBlockId) {
        if (this.isRetryPossible(context, transactionBlockId)) {
            this.transactionContextStore.clear();
            transactionResourceManager.rollbackTransaction(this.globalTransactionId, transactionBlockId);
            return false;
        }
        return true;
    }

    public void notifyLocalParticipantFailure() {
        String bockId = this.transactionBlockIdStack.peek();
        transactionResourceManager.notifyLocalParticipantFailure(this.globalTransactionId, bockId);
    }

    public void notifyLocalRemoteParticipantFailure() {
        TransactionResourceManager.getInstance().notifyResourceFailure(this.globalTransactionId);
    }

    public boolean onTransactionEnd(String transactionBlockId) {
        boolean isOuterTx = false;
        this.transactionBlockIdStack.pop();
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            transactionResourceManager.endXATransaction(this.globalTransactionId, transactionBlockId);
            this.resetTransactionInfo();
            isOuterTx = true;
        }
        return isOuterTx;
    }

    public int getAllowedRetryCount(String localTransactionID) {
        return this.allowedTransactionRetryCounts.get(localTransactionID);
    }

    private int getCurrentRetryCount(String localTransactionID) {
        return this.currentTransactionRetryCounts.get(localTransactionID);
    }

    private void resetTransactionInfo() {
        this.allowedTransactionRetryCounts.clear();
        this.currentTransactionRetryCounts.clear();
        this.transactionContextStore.clear();
    }

    public void markFailure() {
        this.transactionFailure.push(TransactionFailure.at(-1));
    }

    public TransactionFailure getAndClearFailure() {
        if (this.transactionFailure.empty()) {
            return null;
        }
        TransactionFailure failure = this.transactionFailure.pop();
        this.transactionFailure.clear();
        return failure;
    }

    public TransactionFailure getFailure() {
        if (this.transactionFailure.empty()) {
            return null;
        }
        return this.transactionFailure.peek();
    }

    public boolean isResourceParticipant() {
        return this.isResourceParticipant;
    }

    public void setResourceParticipant(boolean resourceParticipant) {
        this.isResourceParticipant = resourceParticipant;
    }

    public static class TransactionFailure {
        private final int offendingIp;

        private TransactionFailure(int offendingIp) {
            this.offendingIp = offendingIp;
        }

        private static TransactionFailure at(int offendingIp) {
            return new TransactionFailure(offendingIp);
        }

        public int getOffendingIp() {
            return this.offendingIp;
        }
    }
}

