/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.transactions;

import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TransactionUtils {
    public static BValue[] notifyTransactionBegin(Strand ctx, String globalTransactionId, String url, String transactionBlockId, String protocol) {
        BValue[] args = new BValue[]{globalTransactionId == null ? null : new BString(globalTransactionId), new BString(transactionBlockId), new BString(url), new BString(protocol)};
        BValue[] returns = TransactionUtils.invokeCoordinatorFunction(ctx, "beginTransaction", args);
        TransactionUtils.checkTransactionCoordinatorError(returns[0], "error in global transaction start: ");
        return returns;
    }

    public static CoordinatorCommit notifyTransactionEnd(Strand ctx, String globalTransactionId, String transactionBlockId) {
        BValue[] args = new BValue[]{new BString(globalTransactionId), new BString(transactionBlockId)};
        BValue[] returns = TransactionUtils.invokeCoordinatorFunction(ctx, "endTransaction", args);
        TransactionUtils.checkTransactionCoordinatorError(returns[0], "error in transaction end: ");
        switch (returns[0].getType().getTag()) {
            case 5: {
                String statusMessage = returns[0].stringValue();
                if (statusMessage.equals("committed")) {
                    return CoordinatorCommit.COMMITTED;
                }
                return CoordinatorCommit.ABORTED;
            }
        }
        throw new IllegalStateException("Transaction coordinator returned unexpected result upon trx end: " + returns[0].stringValue());
    }

    public static void notifyTransactionAbort(Strand ctx, String globalTransactionId, String transactionBlockId) {
        BValue[] args = new BValue[]{new BString(globalTransactionId), new BString(transactionBlockId)};
        TransactionUtils.invokeCoordinatorFunction(ctx, "abortTransaction", args);
    }

    private static void checkTransactionCoordinatorError(BValue value, String errMsg) {
        if (value.getType().getTag() == 27) {
            throw new BallerinaException(errMsg + ((BError)value).getReason());
        }
    }

    private static BValue[] invokeCoordinatorFunction(Strand ctx, String functionName, BValue[] args) {
        PackageInfo packageInfo = ctx.programFile.getPackageInfo("ballerina/transactions");
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(functionName);
        return BVMExecutor.executeFunction(functionInfo.getPackageInfo().getProgramFile(), functionInfo, args);
    }

    public static enum CoordinatorCommit {
        COMMITTED,
        ABORTED,
        ERROR;

        private String status;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

