/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.model.types.BErrorType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;

public class BLangVMErrors {
    private static final String DEFAULT_PKG_PATH = ".";
    private static final String MSG_CALL_FAILED = "call failed";
    private static final String MSG_CALL_CANCELLED = "call cancelled";
    public static final String STRUCT_GENERIC_ERROR = "error";
    public static final String NULL_REF_EXCEPTION = "NullReferenceException";
    public static final String STRUCT_CALL_STACK_ELEMENT = "CallStackElement";
    public static final String TRANSACTION_ERROR = "TransactionError";
    public static final String ERROR_MESSAGE_FIELD = "message";
    public static final String STACK_FRAME_CALLABLE_NAME = "callableName";
    public static final String STACK_FRAME_PACKAGE_NAME = "moduleName";
    public static final String STACK_FRAME_FILE_NAME = "fileName";
    public static final String STACK_FRAME_LINE_NUMBER = "lineNumber";

    public static BError createError(String reason, BMap<String, BValue> detail) {
        return BLangVMErrors.generateError(null, false, BTypes.typeError, reason, detail);
    }

    public static BError createError(Context context, String reason) {
        return BLangVMErrors.generateError(context.getStrand(), true, BTypes.typeError, reason, null);
    }

    public static BError createError(Strand strand, String message) {
        return BLangVMErrors.generateError(strand, true, BTypes.typeError, message, null);
    }

    public static BError createError(Strand strand, String reason, String detail) {
        BMap<String, BValue> detailMap = new BMap<String, BValue>(BTypes.typeMap);
        if (detail != null) {
            detailMap.put(ERROR_MESSAGE_FIELD, new BString(detail));
        }
        return BLangVMErrors.generateError(strand, true, BTypes.typeError, reason, detailMap);
    }

    public static BError createError(Context context, boolean attachCallStack, BErrorType errorType, String reason, BMap<String, BValue> details) {
        return BLangVMErrors.generateError(context.getStrand(), attachCallStack, errorType, reason, details);
    }

    public static BError createError(Strand strand, boolean attachCallStack, BErrorType errorType, String reason, BMap<String, BValue> details) {
        return BLangVMErrors.generateError(strand, attachCallStack, errorType, reason, details);
    }

    public static BError createTypeCastError(Strand context, String sourceType, String targetType) {
        String errorMessage = "'" + sourceType + "' cannot be cast to '" + targetType + "'";
        return BLangVMErrors.createError(context, errorMessage);
    }

    public static BError createCancelledFutureError(Strand context) {
        String errorMessage = "future is already cancelled";
        return BLangVMErrors.createError(context, errorMessage);
    }

    public static BError createTypeConversionError(Strand context, String errorMessage) {
        return BLangVMErrors.createError(context, BallerinaErrorReasons.CONVERSION_ERROR, errorMessage);
    }

    public static BError createNullRefException(Strand strand) {
        return BLangVMErrors.generateError(strand, true, BTypes.typeError, NULL_REF_EXCEPTION, null);
    }

    private static BError generateError(Strand strand, boolean attachCallStack, BErrorType type, String reason, BMap<String, BValue> details) {
        BMap detailMap = Optional.ofNullable(details).orElse(new BMap(BTypes.typeMap));
        BError error = new BError(type, Optional.ofNullable(reason).orElse(""), detailMap);
        StructureTypeInfo typeInfo = BLangVMErrors.getStructureTypeInfo(strand.programFile);
        if (attachCallStack) {
            BLangVMErrors.attachStack(error, typeInfo, strand);
        }
        return error;
    }

    public static void attachStack(BError error, StructureTypeInfo typeInfo, Strand strand) {
        for (StackFrame frame : strand.getStack()) {
            Optional.ofNullable(BLangVMErrors.getStackFrame(typeInfo, frame)).ifPresent(sf -> error.callStack.add(0, (BMap<String, BValue>)sf));
        }
    }

    public static BValueArray generateCallStack(WorkerExecutionContext context, CallableUnitInfo nativeCUI) {
        BValueArray callStack = new BValueArray();
        long index = 0L;
        if (nativeCUI != null) {
            callStack.add(index, BLangVMErrors.getStackFrame(BLangVMErrors.getStructureTypeInfo(context.programFile), nativeCUI, 0));
            ++index;
        }
        while (!context.isRootContext()) {
            context = context.parent;
            ++index;
        }
        return callStack;
    }

    public static BValueArray generateCallStack(ProgramFile programFile, Strand strand) {
        StructureTypeInfo typeInfo = BLangVMErrors.getStructureTypeInfo(programFile);
        ArrayList<BMap<String, BValue>> sfList = new ArrayList<BMap<String, BValue>>();
        for (StackFrame frame : strand.getStack()) {
            BMap<String, BValue> sf = BLangVMErrors.getStackFrame(typeInfo, frame);
            if (sf == null) continue;
            sfList.add(0, sf);
        }
        BValueArray callStack = new BValueArray(typeInfo.getType());
        for (int i = 0; i < sfList.size(); ++i) {
            callStack.add((long)i, (BRefType)sfList.get(i));
        }
        return callStack;
    }

    public static BMap<String, BValue> getStackFrame(StructureTypeInfo typeInfo, CallableUnitInfo callableUnitInfo, int ip) {
        if (callableUnitInfo == null) {
            return null;
        }
        int currentIP = ip - 1;
        Object[] values = new Object[4];
        String parentScope = "";
        values[0] = parentScope + callableUnitInfo.getName();
        values[1] = callableUnitInfo.getPkgPath();
        if (callableUnitInfo.isNative()) {
            values[2] = "<native>";
            values[3] = 0;
        } else {
            LineNumberInfo lineNumberInfo = callableUnitInfo.getPackageInfo().getLineNumberInfo(currentIP);
            if (lineNumberInfo != null) {
                values[2] = lineNumberInfo.getFileName();
                values[3] = lineNumberInfo.getLineNumber();
            }
        }
        return BLangVMStructs.createBStruct(typeInfo, values);
    }

    public static BMap<String, BValue> getStackFrame(StructureTypeInfo typeInfo, StackFrame sf) {
        if (sf == null) {
            return null;
        }
        return BLangVMErrors.getStackFrame(typeInfo, sf.callableUnitInfo, sf.ip);
    }

    public static String getPrintableStackTrace(BError error) {
        StringBuilder sb = new StringBuilder();
        String errorMsg = BLangVMErrors.getErrorMessage(error);
        sb.append(errorMsg).append("\n\tat ");
        List<BMap<String, BValue>> stackFrames = error.callStack;
        for (int i = 0; i < stackFrames.size(); ++i) {
            BMap<String, BValue> stackFrame = stackFrames.get(i);
            String pkgName = stackFrame.get(STACK_FRAME_PACKAGE_NAME).stringValue();
            if (pkgName.isEmpty() || DEFAULT_PKG_PATH.equals(pkgName) || "ballerina/builtin".equals(pkgName)) {
                sb.append(stackFrame.get(STACK_FRAME_CALLABLE_NAME).stringValue());
            } else {
                sb.append(pkgName).append(":").append(stackFrame.get(STACK_FRAME_CALLABLE_NAME).stringValue());
            }
            sb.append("(").append(stackFrame.get(STACK_FRAME_FILE_NAME).stringValue());
            long lineNo = ((BInteger)stackFrame.get(STACK_FRAME_LINE_NUMBER)).intValue();
            if (lineNo > 0L) {
                sb.append(":").append(lineNo);
            }
            sb.append(")");
            if (i == stackFrames.size() - 1) continue;
            sb.append("\n\t   ");
        }
        return sb.toString();
    }

    public static String getErrorMessage(BError error) {
        String errorMsg = "";
        boolean reasonAdded = false;
        if (error.getReason() != null && !error.getReason().isEmpty()) {
            errorMsg = BLangVMErrors.removeJava(error.getReason());
            reasonAdded = true;
        }
        if (error.getDetails() != null) {
            errorMsg = errorMsg + (reasonAdded ? " " : "") + error.getDetails().toString();
        }
        return errorMsg;
    }

    private static String removeJava(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("java", "runtime");
    }

    private static StructureTypeInfo getStructureTypeInfo(ProgramFile programFile) {
        PackageInfo runtimePackage = programFile.getPackageInfo("ballerina/runtime");
        StructureTypeInfo typeInfo = runtimePackage.getStructInfo(STRUCT_CALL_STACK_ELEMENT);
        if (typeInfo == null || typeInfo.getType().getTag() != 12) {
            throw new BallerinaConnectorException("record - CallStackElement does not exist");
        }
        return typeInfo;
    }
}

