/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.bvm.StrandCallback;
import org.ballerinalang.bre.bvm.StrandResourceCallback;
import org.ballerinalang.bre.bvm.StrandWaitCallback;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.observability.ObserveUtils;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.TransactionLocalContext;

public class BVMExecutor {
    public static void stopProgramFile(ProgramFile programFile) {
        BVMExecutor.invokePackageStopFunctions(programFile);
    }

    public static BValue[] executeFunction(ProgramFile programFile, FunctionInfo functionInfo, BValue ... args) {
        int providedArgNo;
        int requiredArgNo = functionInfo.getParamTypes().length;
        if (requiredArgNo != (providedArgNo = args.length)) {
            throw new RuntimeException("Wrong number of arguments. Required: " + requiredArgNo + " , found: " + providedArgNo + ".");
        }
        return new BValue[]{BVMExecutor.execute(programFile, functionInfo, args, null, true)};
    }

    public static void executeResource(ProgramFile programFile, FunctionInfo resourceInfo, CallableUnitCallback responseCallback, Map<String, Object> properties, ObserverContext observerContext, ServiceInfo serviceInfo, BValue ... args) {
        Strand strand = BVMExecutor.populateAndGetStrand(programFile, resourceInfo, responseCallback, properties, observerContext, serviceInfo, args);
        BVMScheduler.schedule(strand);
    }

    public static void execute(ProgramFile programFile, FunctionInfo resourceInfo, CallableUnitCallback responseCallback, Map<String, Object> properties, ObserverContext observerContext, ServiceInfo serviceInfo, BValue ... args) {
        Strand strand = BVMExecutor.populateAndGetStrand(programFile, resourceInfo, responseCallback, properties, observerContext, serviceInfo, args);
        BVMScheduler.execute(strand);
    }

    private static Strand populateAndGetStrand(ProgramFile programFile, FunctionInfo resourceInfo, CallableUnitCallback responseCallback, Map<String, Object> properties, ObserverContext observerContext, ServiceInfo serviceInfo, BValue[] args) {
        HashMap<String, Object> globalProps = new HashMap<String, Object>();
        if (properties != null) {
            globalProps.putAll(properties);
        }
        StrandResourceCallback strandCallback = new StrandResourceCallback(null, responseCallback, resourceInfo.workerSendInChannels);
        Strand strand = new Strand(programFile, resourceInfo.getName(), globalProps, strandCallback);
        BVMExecutor.infectResourceFunction(strandCallback, strand);
        BLangVMUtils.setServiceInfo(strand, serviceInfo);
        StackFrame idf = new StackFrame(resourceInfo.getPackageInfo(), resourceInfo, resourceInfo.getDefaultWorkerInfo().getCodeAttributeInfo(), -1, 0, resourceInfo.workerSendInChannels);
        BVMExecutor.copyArgValues(args, idf, resourceInfo.getParamTypes());
        strand.pushFrame(idf);
        ObserveUtils.startResourceObservation(strand, observerContext);
        BVMScheduler.stateChange(strand, Strand.State.NEW, Strand.State.RUNNABLE);
        return strand;
    }

    private static void infectResourceFunction(StrandResourceCallback strandResourceCallback, Strand strand) {
        String gTransactionId = (String)strand.globalProps.get("globalTransactionId");
        if (gTransactionId != null) {
            String globalTransactionId = strand.globalProps.get("globalTransactionId").toString();
            String url = strand.globalProps.get("transactionUrl").toString();
            TransactionLocalContext transactionLocalContext = TransactionLocalContext.create(globalTransactionId, url, "2pc");
            strand.setLocalTransactionContext(transactionLocalContext);
            strandResourceCallback.setTransactionLocalContext(transactionLocalContext);
        }
    }

    private static BValue execute(ProgramFile programFile, CallableUnitInfo callableInfo, BValue[] args, Map<String, Object> properties, boolean waitForResponse) {
        HashMap<String, Object> globalProps = new HashMap<String, Object>();
        if (properties != null) {
            globalProps.putAll(properties);
        }
        StrandWaitCallback strandCallback = new StrandWaitCallback(callableInfo.getRetParamTypes()[0], callableInfo.workerSendInChannels);
        Strand strand = new Strand(programFile, callableInfo.getName(), globalProps, strandCallback);
        StackFrame idf = new StackFrame(callableInfo.getPackageInfo(), callableInfo, callableInfo.getDefaultWorkerInfo().getCodeAttributeInfo(), -1, 0, callableInfo.workerSendInChannels);
        BVMExecutor.copyArgValues(args, idf, callableInfo.getParamTypes());
        strand.pushFrame(idf);
        BVMScheduler.stateChange(strand, Strand.State.NEW, Strand.State.RUNNABLE);
        BVMScheduler.execute(strand);
        if (waitForResponse) {
            strandCallback.waitForResponse();
            if (strand.getError() != null) {
                throw new BLangRuntimeException("error: " + BLangVMErrors.getPrintableStackTrace(strand.getError()));
            }
        }
        return BVMExecutor.populateReturnData(strandCallback, callableInfo);
    }

    private static void copyArgValues(BValue[] args, StackFrame callee, BType[] paramTypes) {
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        block7: for (int i = 0; i < paramTypes.length; ++i) {
            BType paramType = paramTypes[i];
            switch (paramType.getTag()) {
                case 1: {
                    callee.longRegs[++longRegIndex] = ((BValueType)args[i]).intValue();
                    continue block7;
                }
                case 2: {
                    callee.longRegs[++longRegIndex] = ((BValueType)args[i]).byteValue();
                    continue block7;
                }
                case 3: {
                    callee.doubleRegs[++doubleRegIndex] = ((BValueType)args[i]).floatValue();
                    continue block7;
                }
                case 5: {
                    callee.stringRegs[++stringRegIndex] = args[i].stringValue();
                    continue block7;
                }
                case 6: {
                    if (args[i] instanceof BString) {
                        callee.intRegs[++booleanRegIndex] = ((BString)args[i]).value().equalsIgnoreCase("true") ? 1 : 0;
                        continue block7;
                    }
                    callee.intRegs[++booleanRegIndex] = ((BValueType)args[i]).booleanValue() ? 1 : 0;
                    continue block7;
                }
                default: {
                    callee.refRegs[++refRegIndex] = (BRefType)args[i];
                }
            }
        }
    }

    private static BValue populateReturnData(StrandCallback strandCallback, CallableUnitInfo callableUnitInfo) {
        BValueType returnValue;
        BType retType = callableUnitInfo.getRetParamTypes()[0];
        switch (retType.getTag()) {
            case 1: {
                returnValue = new BInteger(strandCallback.getIntRetVal());
                break;
            }
            case 2: {
                returnValue = new BByte(strandCallback.getByteRetVal());
                break;
            }
            case 3: {
                returnValue = new BFloat(strandCallback.getFloatRetVal());
                break;
            }
            case 5: {
                returnValue = new BString(strandCallback.getStringRetVal());
                break;
            }
            case 6: {
                boolean boolValue = strandCallback.getBooleanRetVal() == 1;
                returnValue = new BBoolean(boolValue);
                break;
            }
            default: {
                returnValue = strandCallback.getRefRetVal();
            }
        }
        return returnValue;
    }

    public static void invokePackageInitFunctions(ProgramFile programFile) {
        for (PackageInfo info : programFile.getPackageInfoEntries()) {
            BValue result = BVMExecutor.execute(programFile, info.getInitFunctionInfo(), new BValue[0], null, true);
            BVMExecutor.validateInvocationError(result);
        }
    }

    public static void invokePackageStartFunctions(ProgramFile programFile) {
        for (PackageInfo info : programFile.getPackageInfoEntries()) {
            BValue result = BVMExecutor.execute(programFile, info.getStartFunctionInfo(), new BValue[0], null, true);
            BVMExecutor.validateInvocationError(result);
        }
    }

    private static void invokePackageStopFunctions(ProgramFile programFile) {
        for (PackageInfo info : programFile.getPackageInfoEntries()) {
            BValue result = BVMExecutor.execute(programFile, info.getStopFunctionInfo(), new BValue[0], null, true);
            BVMExecutor.validateInvocationError(result);
        }
    }

    private static void validateInvocationError(BValue value) {
        if (value != null && value.getType().getTag() == 27) {
            throw new BLangRuntimeException("error: " + BLangVMErrors.getPrintableStackTrace((BError)value));
        }
    }

    private BVMExecutor() {
    }
}

