/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.bvm.WDChannels;
import org.ballerinalang.bre.bvm.WorkerDataChannel;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.observability.ObserverContext;

public class StackFrame {
    public int invocationFlags = 0;
    public long[] longRegs;
    public double[] doubleRegs;
    public String[] stringRegs;
    public int[] intRegs;
    public BRefType<?>[] refRegs;
    public CallableUnitInfo callableUnitInfo;
    public Map<String, Object> localProps = new HashMap<String, Object>();
    ConstantPoolEntry[] constPool;
    public Instruction[] code;
    public int ip;
    int retReg;
    public ObserverContext observerContext;
    TransactionParticipantType trxParticipant;
    int errorRetReg = -1;
    public WDChannels wdChannels;
    public CallableUnitInfo.ChannelDetails[] workerSendInChannels;

    public StackFrame() {
    }

    public StackFrame(PackageInfo packageInfo, CallableUnitInfo callableUnitInfo, CodeAttributeInfo ci, int retReg, int invocationFlags, CallableUnitInfo.ChannelDetails[] workerSendInChannels) {
        if (ci.maxLongRegs > 0) {
            this.longRegs = new long[ci.maxLongRegs];
        }
        if (ci.maxDoubleRegs > 0) {
            this.doubleRegs = new double[ci.maxDoubleRegs];
        }
        if (ci.maxStringRegs > 0) {
            this.stringRegs = new String[ci.maxStringRegs];
        }
        if (ci.maxIntRegs > 0) {
            this.intRegs = new int[ci.maxIntRegs];
        }
        if (ci.maxBValueRegs > 0) {
            this.refRegs = new BRefType[ci.maxBValueRegs];
        }
        this.ip = ci.getCodeAddrs();
        this.callableUnitInfo = callableUnitInfo;
        this.constPool = packageInfo.getConstPoolEntries();
        this.code = packageInfo.getInstructions();
        this.retReg = retReg;
        this.invocationFlags = invocationFlags;
        this.wdChannels = new WDChannels();
        this.workerSendInChannels = workerSendInChannels;
    }

    public void handleChannelPanic(BError error, WDChannels parentChannels) {
        for (int i = 0; i < this.workerSendInChannels.length; ++i) {
            CallableUnitInfo.ChannelDetails channelDetails = this.workerSendInChannels[i];
            WorkerDataChannel channel = channelDetails.channelInSameStrand ? this.wdChannels.getWorkerDataChannel(channelDetails.name) : parentChannels.getWorkerDataChannel(channelDetails.name);
            if (channelDetails.send) {
                channel.setSendPanic(error);
                continue;
            }
            channel.setReceiverPanic(error);
        }
    }

    public void handleChannelError(BRefType value, WDChannels parentChannels) {
        for (int i = 0; i < this.workerSendInChannels.length; ++i) {
            CallableUnitInfo.ChannelDetails channelDetails = this.workerSendInChannels[i];
            WorkerDataChannel channel = channelDetails.channelInSameStrand ? this.wdChannels.getWorkerDataChannel(channelDetails.name) : parentChannels.getWorkerDataChannel(channelDetails.name);
            if (channelDetails.send) {
                channel.setSendError(value);
                continue;
            }
            channel.setRecieveError(value);
        }
    }

    static enum TransactionParticipantType {
        LOCAL_PARTICIPANT,
        REMOTE_PARTICIPANT,
        NON_PARTICIPANT;

    }
}

