/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.WDChannels;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.observability.ObserveUtils;
import org.ballerinalang.util.observability.ObserverContext;

public abstract class StrandCallback {
    private long longVal;
    private double doubleVal;
    private String stringVal;
    private int intVal;
    private BRefType<?> refVal;
    private BError error;
    private ObserverContext observerContext;
    private volatile CallbackStatus status;
    private CallbackStatus valueStatus;
    CallableUnitInfo.ChannelDetails[] sendIns;
    protected BType retType;
    public WDChannels parentChannels;

    StrandCallback(BType retType, CallableUnitInfo.ChannelDetails[] sendIns, WDChannels parentChannels) {
        this.retType = retType;
        this.status = CallbackStatus.NOT_RETURNED;
        this.sendIns = sendIns;
        this.parentChannels = parentChannels;
        BVMScheduler.strandCountUp();
    }

    public void signal() {
        this.status = this.valueStatus;
        if (this.status == null) {
            this.status = CallbackStatus.VALUE_RETURNED;
        }
        ObserveUtils.stopObservation(this.observerContext);
        BVMScheduler.strandCountDown();
    }

    public CallbackStatus getStatus() {
        return this.status;
    }

    public void setIntReturn(long value) {
        this.longVal = value;
        this.valueStatus = CallbackStatus.VALUE_RETURNED;
    }

    public void setFloatReturn(double value) {
        this.doubleVal = value;
        this.valueStatus = CallbackStatus.VALUE_RETURNED;
    }

    public void setStringReturn(String value) {
        this.stringVal = value;
        this.valueStatus = CallbackStatus.VALUE_RETURNED;
    }

    public void setBooleanReturn(int value) {
        this.intVal = value;
        this.valueStatus = CallbackStatus.VALUE_RETURNED;
    }

    public void setByteReturn(long value) {
        this.longVal = value;
        this.valueStatus = CallbackStatus.VALUE_RETURNED;
    }

    public void setRefReturn(BRefType<?> value) {
        this.refVal = value;
        this.valueStatus = BVM.checkIsType(this.refVal, BTypes.typeError) ? CallbackStatus.ERROR_RETURN : CallbackStatus.VALUE_RETURNED;
    }

    public void setError(BError error) {
        this.error = error;
        this.valueStatus = CallbackStatus.PANIC;
    }

    public long getIntRetVal() {
        return this.longVal;
    }

    public double getFloatRetVal() {
        return this.doubleVal;
    }

    public String getStringRetVal() {
        return this.stringVal;
    }

    public int getBooleanRetVal() {
        return this.intVal;
    }

    public long getByteRetVal() {
        return this.longVal;
    }

    public BRefType<?> getRefRetVal() {
        return this.refVal;
    }

    public BError getErrorVal() {
        return this.error;
    }

    public void setObserverContext(ObserverContext context) {
        this.observerContext = context;
    }

    public ObserverContext getObserverContext() {
        return this.observerContext;
    }

    public static enum CallbackStatus {
        NOT_RETURNED(false),
        VALUE_RETURNED(true),
        ERROR_RETURN(true),
        PANIC(false);

        public final boolean returned;

        private CallbackStatus(boolean returned) {
            this.returned = returned;
        }
    }
}

