/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.old;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.WorkerDataChannel;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.bre.old.WorkerResponseContext;
import org.ballerinalang.bre.old.WorkerSignal;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.util.debugger.DebugCommand;
import org.ballerinalang.util.transactions.TransactionLocalContext;

public abstract class BaseWorkerResponseContext
implements WorkerResponseContext {
    protected int[] retRegIndexes;
    protected WorkerSignal currentSignal;
    protected List<CallableUnitCallback> responseCallbacks;
    protected WorkerExecutionContext targetCtx;
    protected Map<String, WorkerDataChannel> workerDataChannels;
    protected int workerCount;

    public BaseWorkerResponseContext(int workerCount) {
        this.workerCount = workerCount;
    }

    @Override
    public WorkerExecutionContext signal(WorkerSignal signal) {
        switch (signal.getType()) {
            case ERROR: {
                return this.onError(signal);
            }
            case MESSAGE: {
                this.onMessage(signal);
                break;
            }
            case HALT: {
                return this.onHalt(signal);
            }
            case RETURN: {
                return this.onReturn(signal);
            }
            case TIMEOUT: {
                return this.onTimeout(signal);
            }
        }
        return null;
    }

    protected WorkerExecutionContext onTimeout(WorkerSignal signal) {
        return null;
    }

    protected void onMessage(WorkerSignal signal) {
    }

    protected WorkerExecutionContext onHalt(WorkerSignal signal) {
        return null;
    }

    protected WorkerExecutionContext onError(WorkerSignal signal) {
        return null;
    }

    protected WorkerExecutionContext onReturn(WorkerSignal signal) {
        return null;
    }

    protected void modifyDebugCommands(WorkerExecutionContext parent, WorkerExecutionContext child) {
        if (child == null || child.programFile == null || !child.programFile.getDebugger().isDebugEnabled() || parent == null || parent.getDebugContext() == null) {
            return;
        }
        DebugCommand crntCommand = child.getDebugContext().getCurrentCommand();
        if (!child.getDebugContext().isCmdChanged()) {
            return;
        }
        if (crntCommand == DebugCommand.STEP_OUT) {
            parent.getDebugContext().setCurrentCommand(DebugCommand.STEP_OVER);
        } else {
            parent.getDebugContext().setCurrentCommand(crntCommand);
        }
    }

    @Override
    public WorkerExecutionContext joinTargetContextInfo(WorkerExecutionContext targetCtx, int[] retRegIndexes) {
        this.targetCtx = targetCtx;
        this.retRegIndexes = retRegIndexes;
        return null;
    }

    public WorkerExecutionContext getTargetContext() {
        return this.targetCtx;
    }

    public int[] getRetRegIndexes() {
        return this.retRegIndexes;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public synchronized WorkerDataChannel getWorkerDataChannel(String name) {
        WorkerDataChannel channel;
        if (this.workerDataChannels == null) {
            this.workerDataChannels = new HashMap<String, WorkerDataChannel>();
        }
        if ((channel = this.workerDataChannels.get(name)) == null) {
            channel = new WorkerDataChannel();
            this.workerDataChannels.put(name, channel);
        }
        return channel;
    }

    public synchronized void registerResponseCallback(CallableUnitCallback responseCallback) {
        if (this.responseCallbacks == null) {
            this.responseCallbacks = new ArrayList<CallableUnitCallback>();
        }
        this.responseCallbacks.add(responseCallback);
    }

    protected void doSuccessCallbackNotify() {
        if (this.responseCallbacks != null) {
            for (CallableUnitCallback callback : this.responseCallbacks) {
                callback.notifySuccess();
            }
        }
    }

    protected void doFailCallbackNotify(BError error) {
        if (this.responseCallbacks != null) {
            for (CallableUnitCallback callback : this.responseCallbacks) {
                callback.notifyFailure(error);
            }
        }
    }

    void signalTransactionError(WorkerSignal signal) {
        TransactionLocalContext transactionLocalContext = signal.getSourceContext().getLocalTransactionInfo();
        if (transactionLocalContext == null) {
            return;
        }
        transactionLocalContext.notifyLocalParticipantFailure();
    }

    void signalTransactionParticipantSuccess(WorkerSignal signal) {
        TransactionLocalContext transactionLocalContext = signal.getSourceContext().getLocalTransactionInfo();
        if (transactionLocalContext == null) {
            return;
        }
    }
}

