/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.api;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.impl.ConnectorSPIModelHelper;
import org.ballerinalang.model.types.BObjectType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.ObjectTypeInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.ballerinalang.compiler.util.Names;

public final class BLangConnectorSPIUtil {
    public static Struct getConnectorEndpointStruct(Context context) {
        BValue result = context.getRefArgument(0);
        if (result == null || result.getType().getTag() != 33) {
            throw new BallerinaException("Can't get connector endpoint struct");
        }
        return ConnectorSPIModelHelper.createStruct((BMap)result);
    }

    public static Service getServiceRegistered(Context context) {
        BValue result = context.getRefArgument(1);
        if (result == null || result.getType().getTag() != 33) {
            throw new BallerinaConnectorException("Can't get service reference");
        }
        ProgramFile programFile = context.getProgramFile();
        Service service = BLangConnectorSPIUtil.getService(programFile, (BMap)result);
        return service;
    }

    public static BMap<String, BValue> createBStruct(Context context, String pkgPath, String structName, Object ... values) {
        return BLangConnectorSPIUtil.createBStruct(context.getProgramFile(), pkgPath, structName, values);
    }

    public static BMap<String, BValue> createBStruct(ProgramFile programFile, String pkgPath, String structName, Object ... values) {
        PackageInfo packageInfo = programFile.getPackageInfo(pkgPath);
        if (packageInfo == null) {
            throw new BallerinaConnectorException("module - " + pkgPath + " does not exist");
        }
        StructureTypeInfo structureInfo = packageInfo.getStructInfo(structName);
        return BLangVMStructs.createBStruct(structureInfo, values);
    }

    public static BMap<String, BValue> createObject(Context context, String pkgPath, String structName, BValue ... values) {
        return BLangConnectorSPIUtil.createObject(context.getProgramFile(), pkgPath, structName, values);
    }

    public static BMap<String, BValue> createObject(ProgramFile programFile, String pkgPath, String objectName, BValue ... values) {
        PackageInfo packageInfo = programFile.getPackageInfo(pkgPath);
        if (packageInfo == null) {
            throw new BallerinaConnectorException("module - " + pkgPath + " does not exist");
        }
        StructureTypeInfo typeInfo = packageInfo.getStructInfo(objectName);
        if (typeInfo == null || typeInfo.getType().getTag() != 33) {
            throw new BallerinaConnectorException("object - " + objectName + " does not exist");
        }
        return BLangVMStructs.createObject((ObjectTypeInfo)typeInfo, values);
    }

    public static Struct toStruct(BMap<String, BValue> bStruct) {
        return ConnectorSPIModelHelper.createStruct(bStruct);
    }

    public static Service getServiceFromType(ProgramFile programFile, BValue value) {
        if (value == null || value.getType().getTag() != 33) {
            throw new BallerinaConnectorException("Can't get service reference");
        }
        return BLangConnectorSPIUtil.getService(programFile, (BMap)value);
    }

    public static BMap<String, BValue> getPackageEndpoint(ProgramFile programFile, String pkgName, String version, String endpointName) {
        String pkgID = BLangConnectorSPIUtil.getPackageID(pkgName, version);
        PackageInfo packageInfo = programFile.getPackageInfo(pkgID);
        if (packageInfo == null) {
            throw new BallerinaConnectorException("Incorrect module name");
        }
        PackageVarInfo packageVarInfo = packageInfo.getPackageVarInfo(endpointName);
        if (packageVarInfo == null) {
            throw new BallerinaConnectorException("Can't locate " + endpointName + " endpoint variable");
        }
        return (BMap)programFile.globalMemArea.getRefField(packageInfo.pkgIndex, packageVarInfo.getGlobalMemIndex());
    }

    public static Service getService(ProgramFile programFile, BMap serviceValue) {
        BObjectType serviceType = (BObjectType)serviceValue.getType();
        ServiceInfo serviceInfo = programFile.getPackageInfo(serviceType.getPackagePath()).getServiceInfo(serviceType);
        serviceInfo.serviceValue = serviceValue;
        return ConnectorSPIModelHelper.createService(programFile, serviceInfo, serviceValue);
    }

    private static String getPackageID(String pkgName, String version) {
        if (version == null || Names.EMPTY.value.equals(version)) {
            return pkgName;
        }
        return String.join((CharSequence)Names.VERSION_SEPARATOR.value, pkgName, version);
    }
}

