/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import org.ballerinalang.model.symbols.BLangSymbol;
import org.ballerinalang.model.values.BValue;

public abstract class BType
implements BLangSymbol {
    protected String typeName;
    protected String pkgPath;
    protected Class<? extends BValue> valueClass;

    protected BType(String typeName, String pkgPath, Class<? extends BValue> valueClass) {
        this.typeName = typeName;
        this.pkgPath = pkgPath;
        this.valueClass = valueClass;
    }

    public <V extends BValue> Class<V> getValueClass() {
        return this.valueClass;
    }

    public abstract <V extends BValue> V getZeroValue();

    public abstract <V extends BValue> V getEmptyValue();

    public abstract int getTag();

    public String toString() {
        return this.pkgPath == null || this.pkgPath.equals(".") ? this.typeName : this.pkgPath + ":" + this.typeName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BType) {
            BType other = (BType)obj;
            boolean namesEqual = this.typeName.equals(other.getName());
            if (this.pkgPath == null && other.getPackagePath() == null) {
                return namesEqual;
            }
            if (this.pkgPath != null && other.getPackagePath() != null) {
                return this.pkgPath.equals(other.getPackagePath()) && namesEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.pkgPath + ":" + this.typeName).hashCode();
    }

    public boolean isNilable() {
        return false;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public String getPackagePath() {
        return this.pkgPath;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }
}

