/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.serializer.BTreeHelper;
import org.ballerinalang.model.util.serializer.BValueArrays;
import org.ballerinalang.model.util.serializer.BValueProvider;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.ObjectHelper;
import org.ballerinalang.model.util.serializer.ObjectUID;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BValueTree
implements BValueSerializer {
    private static final BValueProvider bValueProvider = BValueProvider.getInstance();
    private final BValueArrays bValueArrays;
    private final ObjectUID objectUID = new ObjectUID();

    BValueTree() {
        this.bValueArrays = new BValueArrays(this);
    }

    BRefType toBValueTree(Object src) {
        BValue tree = this.toBValue(src, (Class)src.getClass());
        BTreeHelper.trimTree(tree, this.objectUID.getRepeatedReferences());
        return tree;
    }

    @Override
    public BRefType toBValue(Object src, Class<?> leftSideType) {
        BRefType num;
        BRefType array;
        if (src == null) {
            return null;
        }
        if (src instanceof String) {
            return BTreeHelper.createBString((String)src);
        }
        if (src.getClass().isArray() && (array = this.arrayFrom(src)) != null) {
            return array;
        }
        if (src instanceof Character) {
            return new BInteger(((Character)src).charValue());
        }
        if (src instanceof Number && (num = this.numberToBValue(src)) != null) {
            return num;
        }
        if (src instanceof Boolean) {
            return new BBoolean((Boolean)src);
        }
        if (src instanceof Enum) {
            return this.enumToBValue((Enum)src);
        }
        return this.convertReferenceSemanticObject(src, leftSideType);
    }

    private BMap mapToBValue(Map<Object, Object> source) {
        BMap<String, BValue> target = new BMap<String, BValue>();
        BMap<String, BValue> complexKeyMap = new BMap<String, BValue>();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            BValue serializedValue = this.toBValue(entry.getValue(), (Class)null);
            if (key instanceof String) {
                target.put((String)key, serializedValue);
                continue;
            }
            BValue serializedKey = this.toBValue(key, (Class)null);
            String complexKeyId = Long.toString(this.objectUID.findUID(key));
            target.put(complexKeyId, serializedValue);
            complexKeyMap.put(complexKeyId, serializedKey);
        }
        if (!complexKeyMap.isEmpty()) {
            target.put("#complex_key_map#", complexKeyMap);
        }
        return BTreeHelper.wrapWithTypeMetadata("map#", target);
    }

    private BMap<String, BValue> listToBValue(List list) {
        BValueArray array = new BValueArray(new BArrayType(BTypes.typeAny));
        for (Object item : list) {
            array.append((BRefType<?>)this.toBValue(item, (Class)null));
        }
        BMap<String, BValue> bMap = BTreeHelper.wrapWithTypeMetadata("list#", array);
        bMap.put("len#", new BInteger(list.size()));
        return bMap;
    }

    private BMap enumToBValue(Enum obj) {
        String fullEnumName = ObjectHelper.getTrimmedClassName(obj) + "." + obj.toString();
        BString name = BTreeHelper.createBString(fullEnumName);
        return BTreeHelper.wrapWithTypeMetadata("enum#", name);
    }

    private BRefType arrayFrom(Object src) {
        Class<?> srcClass = src.getClass();
        if (srcClass == int[].class) {
            return this.bValueArrays.from((int[])src);
        }
        if (srcClass == long[].class) {
            return this.bValueArrays.from((long[])src);
        }
        if (srcClass == double[].class) {
            return this.bValueArrays.from((double[])src);
        }
        if (srcClass == float[].class) {
            return this.bValueArrays.from((float[])src);
        }
        if (srcClass == char[].class) {
            return this.bValueArrays.from((char[])src);
        }
        if (srcClass == byte[].class) {
            return this.bValueArrays.from((byte[])src);
        }
        if (srcClass == short[].class) {
            return this.bValueArrays.from((short[])src);
        }
        if (srcClass == String[].class || srcClass == Integer[].class || srcClass == Long[].class || srcClass == Double[].class || srcClass == Float[].class || srcClass == Character[].class || srcClass == Byte[].class || srcClass == Short[].class) {
            return this.bValueArrays.from((Object[])src);
        }
        return null;
    }

    private BRefType numberToBValue(Object src) {
        Class<?> srcClass = src.getClass();
        if (srcClass == Integer.class) {
            return new BInteger(((Integer)src).longValue());
        }
        if (srcClass == Long.class) {
            return new BInteger((Long)src);
        }
        if (srcClass == Float.class) {
            return new BFloat(((Float)src).doubleValue());
        }
        if (srcClass == Double.class) {
            return new BFloat((Double)src);
        }
        if (srcClass == Byte.class) {
            return new BInteger(((Byte)src).longValue());
        }
        if (srcClass == Short.class) {
            return new BInteger(((Short)src).intValue());
        }
        return null;
    }

    private BMap<String, BValue> convertReferenceSemanticObject(Object obj, Class<?> leftSideType) {
        if (this.objectUID.isTracked(obj)) {
            return this.createExistingReferenceNode(obj);
        }
        this.objectUID.track(obj);
        String className = ObjectHelper.getTrimmedClassName(obj);
        SerializationBValueProvider provider = bValueProvider.find(className);
        BMap<String, BValue> converted = provider != null ? provider.toBValue(obj, this).toBMap() : (obj instanceof Map ? this.mapToBValue((Map)obj) : (obj instanceof List ? this.listToBValue((List)obj) : (obj.getClass().isArray() ? this.arrayToBValue(obj) : this.convertToBValueViaReflection(obj, leftSideType))));
        this.objectUID.addUID(obj, converted);
        return converted;
    }

    private BMap<String, BValue> arrayToBValue(Object array) {
        BValueArray bArray = new BValueArray(new BArrayType(BTypes.typeAny));
        int arrayLength = Array.getLength(array);
        for (int i = 0; i < arrayLength; ++i) {
            bArray.append((BRefType<?>)this.toBValue(Array.get(array, i), (Class)null));
        }
        BMap<String, BValue> bMap = BTreeHelper.wrapWithTypeMetadata("array#", bArray);
        bMap.put("len#", new BInteger(arrayLength));
        Class<?> componentType = array.getClass().getComponentType();
        String trimmedName = ObjectHelper.getTrimmedClassName(componentType);
        bMap.put("componentType#", BTreeHelper.createBString(trimmedName));
        return bMap;
    }

    private BMap<String, BValue> createExistingReferenceNode(Object obj) {
        BMap<String, BValue> map = new BMap<String, BValue>();
        long objId = this.objectUID.findUID(obj);
        map.put("#existing#", new BInteger(objId));
        this.objectUID.addRepeatedRef(objId);
        return map;
    }

    private BMap convertToBValueViaReflection(Object obj, Class<?> targetFieldType) {
        Class<?> objectType = obj.getClass();
        BMap<String, BValue> map = new BMap<String, BValue>();
        HashMap<String, Field> allFields = ObjectHelper.getAllFields(objectType, 0);
        for (Map.Entry<String, Field> fieldEntry : allFields.entrySet()) {
            String fieldName = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            field.setAccessible(true);
            try {
                map.put(fieldName, this.toBValue(field.get(obj), (Class)field.getType()));
            }
            catch (IllegalAccessException e) {
                throw new BallerinaException(String.format("Error while reflective field access: %s.%s", objectType.getName(), fieldName), e);
            }
        }
        if (targetFieldType != objectType) {
            String className = ObjectHelper.getTrimmedClassName(obj);
            return BTreeHelper.wrapWithTypeMetadata(className, map);
        }
        return map;
    }
}

